/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.PikerAnimations;
import com.Polarice3.Goety.common.entities.ally.illager.PikerServant;
import com.Polarice3.Goety.common.entities.hostile.illagers.Piker;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class PikerModel<T extends Mob>
extends HierarchicalModel<T>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart upperBody;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public PikerModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.rightLeg = this.illager.m_171324_("right_leg");
        this.leftLeg = this.illager.m_171324_("left_leg");
        this.upperBody = this.illager.m_171324_("upperBody");
        this.leftArm = this.upperBody.m_171324_("left_arm");
        this.head = this.upperBody.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = illager.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-2.1f, 6.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-2.1f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = illager.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 38).m_171480_().m_171488_(-1.9f, 6.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)1.95f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody = illager.m_171599_("upperBody", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = upperBody.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -7.5f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 47).m_171480_().m_171488_(-4.0f, 1.75f, -3.0f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(0, 64).m_171488_(-4.5f, -7.75f, -3.5f, 9.0f, 7.0f, 7.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)0.0f));
        PartDefinition upperBody_r1 = body.m_171599_("upperBody_r1", CubeListBuilder.m_171558_().m_171514_(30, 46).m_171488_(-6.5f, -16.0f, 1.5f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)18.5f, (float)-7.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition upperBody_r2 = body.m_171599_("upperBody_r2", CubeListBuilder.m_171558_().m_171514_(30, 46).m_171488_(-6.5f, -16.0f, 1.5f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)18.5f, (float)-3.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition bedroll = body.m_171599_("bedroll", CubeListBuilder.m_171558_().m_171514_(60, 6).m_171488_(-7.0f, -1.5f, 0.0f, 14.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)3.0f));
        PartDefinition bedroll1 = bedroll.m_171599_("bedroll1", CubeListBuilder.m_171558_().m_171514_(76, 14).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)4.0f));
        PartDefinition Scabbard = body.m_171599_("Scabbard", CubeListBuilder.m_171558_().m_171514_(0, 105).m_171488_(1.5f, -12.5f, 0.0f, 11.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(3.5f, -2.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(2.5f, -3.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(1.5f, -4.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(3.5f, -6.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(4.5f, -7.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(6.5f, -9.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(7.5f, -10.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(9.5f, -12.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(10.5f, -12.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(11.5f, -12.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(11.5f, -11.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(11.5f, -10.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(9.5f, -8.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(8.5f, -7.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(6.5f, -5.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 75).m_171488_(5.5f, -4.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(4.5f, -3.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(7.5f, -6.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(10.5f, -9.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(8.5f, -11.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(5.5f, -8.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(2.5f, -5.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)2.0f, (float)-8.0f, (float)-1.5708f, (float)-0.5236f, (float)1.5708f));
        PartDefinition Scabbard1 = Scabbard.m_171599_("Scabbard1", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171488_(-1.0f, 2.0f, -1.0f, 9.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(-1.0f, 10.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(3.0f, 4.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(2.0f, 2.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(3.0f, 3.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(7.0f, 7.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(6.0f, 6.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(-1.0f, 9.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(-1.0f, 8.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 75).m_171488_(0.0f, 8.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(1.0f, 7.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(2.0f, 6.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(4.0f, 6.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(4.0f, 4.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(5.0f, 5.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(3.0f, 5.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(2.0f, 3.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(6.0f, 7.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(0.0f, 10.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 75).m_171488_(1.0f, 10.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 75).m_171488_(1.0f, 9.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(2.0f, 8.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(3.0f, 7.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-7.5f, (float)1.0f));
        PartDefinition right_arm = upperBody.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 54).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightPauldron = right_arm.m_171599_("rightPauldron", CubeListBuilder.m_171558_().m_171514_(76, 64).m_171488_(-2.5f, -3.5f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(99, 66).m_171488_(1.5f, -4.5f, -3.5f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(99, 64).m_171488_(-3.5f, -1.5f, -3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(99, 64).m_171488_(-3.5f, -1.5f, 2.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(99, 64).m_171488_(-3.5f, 1.5f, 2.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(99, 67).m_171488_(1.5f, -0.5f, -3.5f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(99, 58).m_171488_(-3.5f, 1.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(99, 58).m_171488_(-3.5f, -1.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(99, 64).m_171488_(-3.5f, 1.5f, -3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.25f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition spear = right_arm.m_171599_("spear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)9.6884f, (float)-2.3116f));
        PartDefinition Rotate = spear.m_171599_("Rotate", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-14.3116f, -12.6884f, -0.5f, 27.0f, 27.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(53, 67).m_171488_(-14.3116f, 13.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(53, 67).m_171488_(-7.3116f, 7.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(-8.3116f, 6.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(53, 67).m_171488_(-13.3116f, 13.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(53, 67).m_171488_(-14.3116f, 12.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(-14.3116f, 11.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(-13.3116f, 11.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(-12.3116f, 12.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(-12.3116f, 13.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-11.3116f, 11.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-10.3116f, 10.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-9.3116f, 9.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-8.3116f, 8.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-12.3116f, 10.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-11.3116f, 9.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 71).m_171488_(-10.3116f, 8.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 71).m_171488_(-9.3116f, 7.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 71).m_171488_(1.6884f, -3.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 71).m_171488_(0.6884f, -2.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(-0.3116f, -1.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(1.6884f, -1.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(2.6884f, -2.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 71).m_171488_(0.6884f, -0.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-0.3116f, 0.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-1.3116f, 1.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-2.3116f, 2.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-3.3116f, 3.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-4.3116f, 4.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-5.3116f, 5.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-6.3116f, 6.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-6.3116f, 4.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-7.3116f, 5.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(-4.3116f, 2.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(5.6884f, -5.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 71).m_171488_(4.6884f, -4.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(4.6884f, -6.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(3.6884f, -5.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(-1.3116f, -0.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(-2.3116f, 0.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(-3.3116f, 1.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 71).m_171488_(-5.3116f, 3.3116f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(1.6884f, -4.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 67).m_171488_(2.6884f, -4.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(3.6884f, -2.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 67).m_171488_(4.6884f, -2.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(1.6884f, -5.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(3.6884f, -3.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(3.6884f, -7.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 67).m_171488_(4.6884f, -7.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(4.6884f, -8.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(4.6884f, -9.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 67).m_171488_(5.6884f, -9.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 67).m_171488_(6.6884f, -9.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 67).m_171488_(7.6884f, -10.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 67).m_171488_(8.6884f, -11.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 67).m_171488_(9.6884f, -11.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(10.6884f, -12.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 67).m_171488_(11.6884f, -12.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(11.6884f, -11.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(10.6884f, -10.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(10.6884f, -9.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(9.6884f, -8.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(8.6884f, -7.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 67).m_171488_(8.6884f, -6.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 67).m_171488_(8.6884f, -5.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 67).m_171488_(7.6884f, -5.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 67).m_171488_(6.6884f, -5.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 67).m_171488_(6.6884f, -4.6884f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.7854f, (float)1.5708f));
        PartDefinition left_arm = upperBody.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(44, 38).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(44, 54).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition head = upperBody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(60, 19).m_171488_(-4.5f, -5.75f, -4.55f, 4.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)).m_171514_(60, 19).m_171480_().m_171488_(0.5f, -5.75f, -4.55f, 4.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-4.0f));
        PartDefinition rightbeard = head.m_171599_("rightbeard", CubeListBuilder.m_171558_().m_171514_(34, 2).m_171488_(-2.75f, -0.85f, -1.25f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition leftbeard = head.m_171599_("leftbeard", CubeListBuilder.m_171558_().m_171514_(34, 2).m_171480_().m_171488_(-0.25f, -0.85f, -1.25f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(60, 50).m_171488_(-4.5f, -11.0f, -4.5f, 9.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(60, 34).m_171488_(-1.0f, -12.0f, -5.0f, 2.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition helmet_r1 = helmet.m_171599_("helmet_r1", CubeListBuilder.m_171558_().m_171514_(33, 1).m_171480_().m_171488_(0.0f, 0.0f, -1.5f, 7.0f, 1.0f, 13.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition helmet_r2 = helmet.m_171599_("helmet_r2", CubeListBuilder.m_171558_().m_171514_(33, 1).m_171488_(-7.0f, 0.0f, -1.5f, 7.0f, 1.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity instanceof Piker) {
            Piker piker = (Piker)entity;
            if (!piker.m_21224_()) {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
                if (piker.isMeleeAttacking()) {
                    this.animateWalk(limbSwing, limbSwingAmount);
                }
            }
            Vec3 velocity = piker.m_20184_();
            float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            if (piker.aggressiveMode) {
                this.m_233381_(piker.idleAnimationState, PikerAnimations.IDLE, ageInTicks);
            } else {
                this.m_233381_(piker.idleAnimationState, PikerAnimations.IDLE_PASSIVE, ageInTicks);
            }
            if (this.f_102609_) {
                this.rightLeg.f_104203_ = -1.4137167f;
                this.rightLeg.f_104204_ = 0.31415927f;
                this.rightLeg.f_104205_ = 0.07853982f;
                this.leftLeg.f_104203_ = -1.4137167f;
                this.leftLeg.f_104204_ = -0.31415927f;
                this.leftLeg.f_104205_ = -0.07853982f;
            } else if (piker.aggressiveMode) {
                this.m_233385_(piker.walkAnimationState, PikerAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
            } else {
                this.m_233381_(piker.walkAnimationState, PikerAnimations.WALK_PASSIVE, ageInTicks);
                this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
                this.leftArm.f_104204_ = 0.0f;
                this.leftArm.f_104205_ = 0.0f;
                this.animateWalk(limbSwing, limbSwingAmount);
            }
            this.m_233381_(piker.attackAnimationState, PikerAnimations.ATTACK, ageInTicks);
        } else if (entity instanceof PikerServant) {
            PikerServant piker = (PikerServant)entity;
            if (!piker.m_21224_()) {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
                if (piker.isMeleeAttacking()) {
                    this.animateWalk(limbSwing, limbSwingAmount);
                }
            }
            Vec3 velocity = piker.m_20184_();
            float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            if (piker.aggressiveMode) {
                this.m_233381_(piker.idleAnimationState, PikerAnimations.IDLE, ageInTicks);
            } else {
                this.m_233381_(piker.idleAnimationState, PikerAnimations.IDLE_PASSIVE, ageInTicks);
            }
            if (this.f_102609_) {
                this.rightLeg.f_104203_ = -1.4137167f;
                this.rightLeg.f_104204_ = 0.31415927f;
                this.rightLeg.f_104205_ = 0.07853982f;
                this.leftLeg.f_104203_ = -1.4137167f;
                this.leftLeg.f_104204_ = -0.31415927f;
                this.leftLeg.f_104205_ = -0.07853982f;
            } else if (piker.aggressiveMode) {
                this.m_233385_(piker.walkAnimationState, PikerAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
            } else {
                this.m_233381_(piker.walkAnimationState, PikerAnimations.WALK_PASSIVE, ageInTicks);
                this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
                this.leftArm.f_104204_ = 0.0f;
                this.leftArm.f_104205_ = 0.0f;
                this.animateWalk(limbSwing, limbSwingAmount);
            }
            this.m_233381_(piker.attackAnimationState, PikerAnimations.ATTACK, ageInTicks);
        }
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

