/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.TrainingBlockEntity;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.BlazeServant;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlazingCageBlockEntity
extends TrainingBlockEntity {
    public BlazingCageBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.BLAZING_CAGE.get(), p_155229_, p_155230_);
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        super.tick(level, blockPos, blockState, blockEntity);
        if (blockEntity.isTraining()) {
            if (blockEntity.trainTime != blockEntity.getMaxTrainTime()) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    double d0 = (double)blockPos.m_123341_() + level.f_46441_.m_188500_();
                    double d1 = (double)blockPos.m_123342_() + level.f_46441_.m_188500_();
                    double d2 = (double)blockPos.m_123343_() + level.f_46441_.m_188500_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.trainTime == 20) {
                    level.m_5594_(null, blockPos, (SoundEvent)ModSounds.BLAZING_CAGE_TRAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double d0 = (double)blockPos.m_123341_() + level.f_46441_.m_188500_();
                double d1 = (double)blockPos.m_123342_() + level.f_46441_.m_188500_();
                double d2 = (double)blockPos.m_123343_() + level.f_46441_.m_188500_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void setVariant(ItemStack itemStack, Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel && this.getTrainMob() != ModEntityType.BLAZE_SERVANT.get()) {
            this.setEntityType((EntityType)ModEntityType.BLAZE_SERVANT.get());
            this.markUpdated();
        }
    }

    @Override
    public void startTraining(int amount, ItemStack itemStack) {
        super.startTraining(amount, itemStack);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.BLAZING_CAGE_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public void playSpawnSound() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SUMMON_SPELL_FIERY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public int maxTrainAmount() {
        return 5;
    }

    @Override
    public boolean summonLimit() {
        int count = 0;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!(entity instanceof BlazeServant)) continue;
                BlazeServant servant = (BlazeServant)entity;
                if (this.getTrueOwner() == null || servant.getTrueOwner() != this.getTrueOwner() || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count >= (Integer)SpellConfig.BlazeLimit.get();
    }

    @Override
    public boolean isFuel(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42258_) || itemStack.m_150930_(Items.f_42448_);
    }
}

