/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.crafting;

import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BrewingRecipe
implements Recipe<Container> {
    public static Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    public final Ingredient input;
    private final TagKey<EntityType<?>> entityTypeTag;
    private final EntityType<?> entityType;
    public final MobEffect output;
    public final int soulCost;
    public final int capacityExtra;
    public final int duration;

    public BrewingRecipe(ResourceLocation location, Ingredient ingredient, @Nullable TagKey<EntityType<?>> entityTypeTag, @Nullable EntityType<?> entityType, MobEffect mobEffect, int soulCost, int capacityExtra, int duration) {
        this.id = location;
        this.input = ingredient;
        this.entityTypeTag = entityTypeTag;
        this.entityType = entityType;
        this.output = mobEffect;
        this.soulCost = soulCost;
        this.capacityExtra = capacityExtra;
        this.duration = duration;
    }

    public boolean m_5818_(Container p_44002_, Level p_44003_) {
        return false;
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return false;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Nullable
    public TagKey<EntityType<?>> getEntityTypeTag() {
        return this.entityTypeTag;
    }

    @Nullable
    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public int getSoulCost() {
        return this.soulCost;
    }

    public int getCapacityExtra() {
        return this.capacityExtra;
    }

    public int getDuration() {
        return this.duration;
    }

    public MobEffect getOutput() {
        return this.output;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeSerializer.BREWING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BrewingRecipe> {
        public BrewingRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonObject data2;
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            EntityType entityType = null;
            TagKey entityTag = null;
            if (json.has("entity") && (data2 = json.getAsJsonObject("entity")) != null) {
                if (data2.has("entity_type")) {
                    ResourceLocation resourceLocation = new ResourceLocation(data2.getAsJsonPrimitive("entity_type").getAsString());
                    entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
                } else if (data2.has("tag")) {
                    ResourceLocation resourceLocation = new ResourceLocation(data2.getAsJsonPrimitive("tag").getAsString());
                    entityTag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)resourceLocation);
                }
            }
            return new BrewingRecipe(id, ingredient, entityTag, entityType, (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"effect"))), GsonHelper.m_13927_((JsonObject)json, (String)"soulCost"), GsonHelper.m_13927_((JsonObject)json, (String)"capacityExtra"), GsonHelper.m_13927_((JsonObject)json, (String)"duration"));
        }

        public BrewingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            TagKey entityTag = null;
            EntityType entityType = null;
            if (buf.readBoolean()) {
                ResourceLocation tagRL = buf.m_130281_();
                entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
            }
            if (buf.readBoolean()) {
                entityType = (EntityType)buf.readRegistryId();
            }
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(buf.m_130277_()));
            int soulCost = buf.readInt();
            int capacityExtra = buf.readInt();
            int duration = buf.readInt();
            return new BrewingRecipe(id, ingredient, entityTag, entityType, mobEffect, soulCost, capacityExtra, duration);
        }

        public void toNetwork(FriendlyByteBuf buf, BrewingRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.writeBoolean(recipe.entityTypeTag != null);
            if (recipe.entityTypeTag != null) {
                buf.m_130085_(recipe.entityTypeTag.f_203868_());
            }
            buf.writeBoolean(recipe.entityType != null);
            if (recipe.entityType != null) {
                buf.writeRegistryId(ForgeRegistries.ENTITY_TYPES, recipe.entityType);
            }
            buf.m_130070_(ForgeRegistries.MOB_EFFECTS.getKey((Object)recipe.output).toString());
            buf.writeInt(recipe.soulCost);
            buf.writeInt(recipe.capacityExtra);
            buf.writeInt(recipe.duration);
        }
    }
}

