/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.golem;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.golem.RaiderGolemServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.ScatterMine;
import com.Polarice3.Goety.common.entities.util.CameraShake;
import com.Polarice3.Goety.common.items.block.RedstoneGolemSkullItem;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class RedstoneGolem
extends RaiderGolemServant {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RedstoneGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RedstoneGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String ACTIVATE = "activate";
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String SUMMON = "summon";
    public static String TO_SIT = "to_sit";
    public static String TO_STAND = "to_stand";
    public static String SIT = "sit";
    public static String NOVELTY = "novelty";
    public static String DEATH = "death";
    public static float SUMMON_SECONDS_TIME = 5.15f;
    private int activateTick;
    private int idleTime;
    public int summonTick;
    private int summonCool;
    private int mineCount;
    public int attackTick;
    public int postAttackTick;
    public int isSittingDown;
    public int isStandingUp;
    public float getGlow;
    public float glowAmount = 0.03f;
    public int noveltyTick;
    public int deathTime = 0;
    public float deathRotation = 0.0f;
    public boolean markChanged = true;
    public boolean isNovelty = false;
    public boolean isPostAttack = false;
    public boolean isFlash = false;
    public AnimationState activateAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState noveltyAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState toStandAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public RedstoneGolem(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21342_ = new MobUtil.noSpinControl((Mob)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SummonMinesGoal());
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(1.2));
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<RedstoneGolem>(this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.RedstoneGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.RedstoneGolemArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RedstoneGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.RedstoneGolemFollowRange.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.RedstoneGolemHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.RedstoneGolemArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RedstoneGolemDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.RedstoneGolemFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "activate")) {
            return 1;
        }
        if (Objects.equals(animation, "idle")) {
            return 2;
        }
        if (Objects.equals(animation, "attack")) {
            return 3;
        }
        if (Objects.equals(animation, "summon")) {
            return 4;
        }
        if (Objects.equals(animation, "to_sit")) {
            return 5;
        }
        if (Objects.equals(animation, "to_stand")) {
            return 6;
        }
        if (Objects.equals(animation, "sit")) {
            return 7;
        }
        if (Objects.equals(animation, "novelty")) {
            return 8;
        }
        if (Objects.equals(animation, "death")) {
            return 9;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.activateAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.activateAnimationState);
                    break;
                }
                case 2: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 3: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 4: {
                    this.summonAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.summonAnimationState);
                    break;
                }
                case 5: {
                    this.stopMostAnimation(this.toSitAnimationState);
                    this.toSitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopMostAnimation(this.toStandAnimationState);
                    this.toStandAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.sitAnimationState);
                    break;
                }
                case 8: {
                    this.noveltyAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.noveltyAnimationState);
                    break;
                }
                case 9: {
                    this.deathAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.deathAnimationState);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ActivateTick", this.activateTick);
        pCompound.m_128405_("SummonTick", this.summonTick);
        pCompound.m_128405_("CoolDown", this.summonCool);
        pCompound.m_128405_("MineCount", this.mineCount);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ActivateTick")) {
            this.activateTick = pCompound.m_128451_("ActivateTick");
        }
        if (pCompound.m_128441_("SummonTick")) {
            this.summonTick = pCompound.m_128451_("SummonTick");
        }
        if (pCompound.m_128441_("CoolDown")) {
            this.summonCool = pCompound.m_128451_("CoolDown");
        }
        if (pCompound.m_128441_("MineCount")) {
            this.mineCount = pCompound.m_128451_("MineCount");
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.MOB_SUMMONED) {
            this.m_20124_(Pose.EMERGING);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public boolean canAnimateMove() {
        return super.canAnimateMove() && this.getCurrentAnimation() == this.getAnimationState(IDLE);
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_STEP.get());
        CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 10.0f, 0.01f, 5, 0);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get();
    }

    private boolean getGolemFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setGolemFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getGolemFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setGolemFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSummoning() || this.isActivating();
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.summonTick <= 0 && !this.isActivating() && super.m_142582_(p_149755_);
    }

    public boolean isSummoning() {
        return this.summonTick > 0;
    }

    public boolean isSitting() {
        return this.isStaying() && !this.isMeleeAttacking() && !this.isSummoning() && !this.isMoving();
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.activateAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.noveltyAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.toSitAnimationState);
        animationStates.add(this.toStandAnimationState);
        animationStates.add(this.sitAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    @Override
    public void setStaying(boolean staying) {
        super.setStaying(staying);
        if (staying) {
            this.f_19853_.m_7605_((Entity)this, (byte)12);
        } else if (this.isFollowing()) {
            this.f_19853_.m_7605_((Entity)this, (byte)13);
        }
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= 30) {
            this.m_21373_();
            ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.REDSTONE_GOLEM_SKULL_ITEM.get());
            if (this.getTrueOwner() != null) {
                ItemEntity itemEntity;
                RedstoneGolemSkullItem.setOwner(this.getTrueOwner(), itemStack);
                if (this.m_7770_() != null) {
                    RedstoneGolemSkullItem.setCustomName(this.m_7770_().getString(), itemStack);
                }
                if ((itemEntity = this.m_19983_(itemStack)) != null) {
                    itemEntity.m_32064_();
                }
            } else if (this.f_19853_.f_46441_.m_188501_() <= 0.11f) {
                this.m_19983_(itemStack);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_20916_ = 1;
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.setAnimationState(DEATH);
        this.deathRotation = this.m_146908_();
        super.m_6667_(p_21014_);
    }

    public EntityDimensions m_6972_(Pose p_29531_) {
        if (this.isSitting()) {
            return super.m_6972_(p_29531_).m_20390_(1.0f, 0.85f);
        }
        return super.m_6972_(p_29531_);
    }

    private boolean isActivating() {
        return this.m_217003_(Pose.EMERGING);
    }

    @Override
    public void m_8119_() {
        Object mob;
        super.m_8119_();
        if (this.m_21224_()) {
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        if (this.isSitting() && this.markChanged) {
            this.m_6210_();
            this.markChanged = false;
        } else if (!this.isSitting() && !this.markChanged) {
            this.m_6210_();
            this.markChanged = true;
        }
        if (this.m_217003_(Pose.EMERGING)) {
            ++this.activateTick;
            this.setAnimationState(ACTIVATE);
            if (this.activateTick > 20) {
                this.m_20124_(Pose.STANDING);
            }
        }
        if (this.isHostile() && this.f_19797_ % 10 == 0 && (mob = this.m_21406_((EntityType)ModEntityType.HOSTILE_REDSTONE_GOLEM.get(), false)) != null) {
            mob.m_146926_(this.m_146909_());
            mob.m_146922_(this.m_146908_());
            mob.m_5618_(this.m_146908_());
            mob.m_5616_(this.m_6080_());
        }
        if (this.f_19853_.m_5776_() && this.m_6084_() && !this.isActivating()) {
            if (!this.isSummoning()) {
                this.glow();
            }
            if (this.summonTick > 0) {
                this.isFlash = this.summonTick < 60 && this.summonTick > 55 || this.summonTick < 52 && this.summonTick > 47 || this.summonTick < 45 && this.summonTick > 40 || this.summonTick < 38 && this.summonTick > 20;
                --this.summonTick;
            } else {
                this.isFlash = false;
            }
        }
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            if (!(this.isActivating() || this.isMeleeAttacking() || this.isSummoning())) {
                if (this.isStaying()) {
                    this.isStandingUp = MathHelper.secondsToTicks(1);
                    if (this.isSittingDown > 0) {
                        --this.isSittingDown;
                        this.setAnimationState(TO_SIT);
                    } else {
                        this.setAnimationState(SIT);
                    }
                } else {
                    this.isSittingDown = MathHelper.secondsToTicks(1);
                    if (this.isStandingUp > 0) {
                        --this.isStandingUp;
                        this.setAnimationState(TO_STAND);
                    } else if (!this.isPostAttack && !this.isNovelty) {
                        this.setAnimationState(IDLE);
                    }
                }
            }
            if (this.m_6084_() && !this.isActivating()) {
                if (this.isNovelty) {
                    this.f_20899_ = false;
                    this.f_20900_ = 0.0f;
                    this.f_20902_ = 0.0f;
                    ++this.noveltyTick;
                    if (this.noveltyTick == 8 || this.noveltyTick == 13 || this.noveltyTick == 18 || this.noveltyTick == 23 || this.noveltyTick == 28 || this.noveltyTick == 33) {
                        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_CHEST.get());
                    }
                    if (this.noveltyTick == 42) {
                        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_GROWL.get());
                        this.m_146852_(GameEvent.f_223709_, (Entity)this);
                    }
                    if (this.noveltyTick >= 92 || this.m_5448_() != null || this.f_20916_ > 0) {
                        this.isNovelty = false;
                    }
                } else {
                    this.noveltyTick = 0;
                }
                if (!(this.isMeleeAttacking() || this.isSummoning() || this.isMoving() || this.isStaying())) {
                    ++this.idleTime;
                    if (this.f_19853_.f_46441_.m_188501_() <= 0.05f && this.f_20916_ <= 0 && (this.m_5448_() == null || this.m_5448_().m_21224_()) && !this.isNovelty && this.idleTime >= MathHelper.minutesToTicks(1)) {
                        this.idleTime = 0;
                        this.isNovelty = true;
                        this.setAnimationState(NOVELTY);
                    }
                } else {
                    this.idleTime = 0;
                    this.isNovelty = false;
                }
                if (this.summonTick > 0) {
                    --this.summonTick;
                }
                if (this.summonCool > 0) {
                    --this.summonCool;
                }
                if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                }
                if (this.isPostAttack) {
                    ++this.postAttackTick;
                }
                if (this.postAttackTick >= 15) {
                    if (!this.isSummoning()) {
                        this.setAnimationState(IDLE);
                    }
                    this.postAttackTick = 0;
                    this.isPostAttack = false;
                }
                if (this.isSummoning()) {
                    int time;
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 5; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_ELECTRIC.get()), this.m_20208_(0.5), this.m_20188_() - (double)serverLevel.f_46441_.m_188503_(5), this.m_20262_(0.5), 0, d0, d1, d2, 0.5);
                        }
                    }
                    if (this.summonTick == MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f)) {
                        CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 10.0f, 0.1f, 0, 20);
                    }
                    if (this.summonTick <= MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) && this.mineCount > 0 && this.f_19797_ % (time = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) / 14) == 0 && this.m_20096_()) {
                        BlockPos blockPos = this.m_20183_();
                        blockPos = blockPos.m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                        BlockPos blockPos2 = this.m_20183_().m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                        Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
                        Vec3 vec32 = Vec3.m_82539_((Vec3i)blockPos2);
                        ScatterMine scatterMine = new ScatterMine(this.f_19853_, (LivingEntity)this, vec3);
                        if (!this.f_19853_.m_45976_(ScatterMine.class, new AABB(blockPos)).isEmpty()) {
                            scatterMine.m_6034_(vec32.m_7096_(), vec32.m_7098_(), vec32.m_7094_());
                        }
                        if (this.f_19853_.m_7967_((Entity)scatterMine)) {
                            if (this.f_19853_.f_46441_.m_188499_()) {
                                SoundUtil.playRedstoneMineLoad(scatterMine);
                            }
                            --this.mineCount;
                        }
                    }
                } else if (this.getCurrentAnimation() == this.getAnimationState(SUMMON)) {
                    this.setAnimationState(IDLE);
                }
            }
        }
    }

    private void glow() {
        this.getGlow = Mth.m_14036_((float)(this.getGlow + this.glowAmount), (float)0.0f, (float)1.0f);
        if (this.getGlow == 0.0f || this.getGlow == 1.0f) {
            this.glowAmount *= -1.0f;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_SUMMON.get());
            this.summonTick = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME) + 5;
            this.getGlow = 1.0f;
        } else if (pId == 5) {
            this.attackTick = 0;
        } else if (pId == 6) {
            this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get());
        } else if (pId == 7) {
            this.deathRotation = this.m_146908_();
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get(), 1.0f, 1.0f);
        } else if (pId == 12) {
            this.isSittingDown = MathHelper.secondsToTicks(1);
        } else if (pId == 13) {
            this.isStandingUp = MathHelper.secondsToTicks(1);
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return (double)(this.m_20205_() * 6.0f + enemy.m_20205_()) + 1.0;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_PRE_ATTACK.get(), 1.5f, 1.0f);
            this.setMeleeAttacking(true);
        }
        return true;
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    @Override
    public void m_6710_(@Nullable LivingEntity p_21544_) {
        if (!(p_21544_ instanceof Player) && p_21544_ != null && this.m_5448_() != p_21544_ && this.summonCool <= 0) {
            this.summonCool = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
        }
        super.m_6710_(p_21544_);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (itemstack.m_150930_(((Block)ModBlocks.REINFORCED_REDSTONE_BLOCK.get()).m_5456_()) || itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_REDSTONE) || itemstack.m_204117_(Tags.Items.DUSTS_REDSTONE)) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (itemstack.m_150930_(((Block)ModBlocks.REINFORCED_REDSTONE_BLOCK.get()).m_5456_())) {
                    this.m_5634_(this.m_21233_() / 2.0f);
                    this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.5f);
                } else if (itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_REDSTONE)) {
                    this.m_5634_(this.m_21233_() / 4.0f);
                    this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.25f);
                } else {
                    this.m_5634_(this.m_21233_() / 4.0f / 8.0f);
                    this.m_5496_(SoundEvents.f_12009_, 0.25f, 1.0f);
                }
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public class SummonMinesGoal
    extends Goal {
        public boolean m_8036_() {
            LivingEntity livingentity = RedstoneGolem.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = RedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                return RedstoneGolem.this.summonCool <= 0 && RedstoneGolem.this.m_20096_() && RedstoneGolem.this.targetClose(livingentity, d0);
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            RedstoneGolem.this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_SUMMON.get(), RedstoneGolem.this.m_6121_(), RedstoneGolem.this.m_6100_());
            RedstoneGolem.this.setAnimationState(SUMMON);
            RedstoneGolem.this.summonTick = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
            RedstoneGolem.this.summonCool = MathHelper.secondsToTicks(10.0f + SUMMON_SECONDS_TIME);
            RedstoneGolem.this.mineCount = 14;
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RedstoneGolem.this.m_5448_() != null && RedstoneGolem.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return RedstoneGolem.this.attackTick < 5;
        }

        public void m_8056_() {
            RedstoneGolem.this.setMeleeAttacking(true);
        }

        public void m_8041_() {
            RedstoneGolem.this.setMeleeAttacking(false);
            RedstoneGolem.this.isPostAttack = true;
        }

        public void m_8037_() {
            if (RedstoneGolem.this.m_5448_() != null && RedstoneGolem.this.m_5448_().m_6084_()) {
                LivingEntity livingentity = RedstoneGolem.this.m_5448_();
                double d0 = RedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                RedstoneGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)RedstoneGolem.this.m_8085_(), (float)RedstoneGolem.this.m_8132_());
                if (RedstoneGolem.this.targetClose(livingentity, d0)) {
                    RedstoneGolem.this.m_5618_(RedstoneGolem.this.m_6080_());
                    if (RedstoneGolem.this.attackTick == 1) {
                        RedstoneGolem.this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get());
                        RedstoneGolem.this.setAnimationState(ATTACK);
                    }
                    if (RedstoneGolem.this.attackTick == 3 && RedstoneGolem.this.targetClose(livingentity, d0)) {
                        this.hurtTarget((Entity)livingentity);
                        this.massiveSweep((LivingEntity)RedstoneGolem.this, livingentity, 3.0, 100.0);
                    }
                }
            }
        }

        public void hurtTarget(Entity target) {
            float f = (float)RedstoneGolem.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)RedstoneGolem.this.m_21133_(Attributes.f_22282_);
            boolean flag = target.m_6469_(RedstoneGolem.this.getServantAttack(), f);
            if (flag) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (livingEntity.m_20191_().m_82309_() > RedstoneGolem.this.m_20191_().m_82309_()) {
                        livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(RedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(RedstoneGolem.this.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        MobUtil.forcefulKnockBack(livingEntity, f1 * 0.5f, Mth.m_14031_((float)(RedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(RedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), 0.5);
                    }
                    RedstoneGolem.this.m_20256_(RedstoneGolem.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                RedstoneGolem.this.m_19970_((LivingEntity)RedstoneGolem.this, target);
                RedstoneGolem.this.m_21335_(target);
            }
        }

        public void massiveSweep(LivingEntity source, LivingEntity exempt, double range, double arc) {
            List<LivingEntity> hits = MobUtil.getAttackableLivingEntitiesNearby(source, range, 1.0, range, range);
            for (LivingEntity target : hits) {
                float targetAngle = (float)((Math.atan2(target.m_20189_() - source.m_20189_(), target.m_20185_() - source.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float attackAngle = source.f_20883_ % 360.0f;
                if (targetAngle < 0.0f) {
                    targetAngle += 360.0f;
                }
                if (attackAngle < 0.0f) {
                    attackAngle += 360.0f;
                }
                float relativeAngle = targetAngle - attackAngle;
                float hitDistance = (float)Math.sqrt((target.m_20189_() - source.m_20189_()) * (target.m_20189_() - source.m_20189_()) + (target.m_20185_() - source.m_20185_()) * (target.m_20185_() - source.m_20185_())) - target.m_20205_() / 2.0f;
                if (target == exempt || !((double)hitDistance <= range && (double)relativeAngle <= arc / 2.0 && (double)relativeAngle >= -arc / 2.0 || (double)relativeAngle >= 360.0 - arc / 2.0) && !((double)relativeAngle <= -360.0 + arc / 2.0)) continue;
                this.hurtTarget((Entity)target);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)RedstoneGolem.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return RedstoneGolem.this.m_5448_() != null && RedstoneGolem.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            RedstoneGolem.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            RedstoneGolem.this.m_21573_().m_26573_();
            if (RedstoneGolem.this.m_5448_() == null) {
                RedstoneGolem.this.m_21561_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = RedstoneGolem.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            RedstoneGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)RedstoneGolem.this.m_8085_(), (float)RedstoneGolem.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                RedstoneGolem.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, RedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (RedstoneGolem.this.targetClose(enemy, distToEnemySqr) && !RedstoneGolem.this.isPostAttack) {
                RedstoneGolem.this.m_7327_((Entity)enemy);
            }
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float p_28900_) {
            this.fraction = p_28900_;
        }

        public static Crackiness byFraction(float p_28902_) {
            for (Crackiness irongolem$crackiness : BY_DAMAGE) {
                if (!(p_28902_ < irongolem$crackiness.fraction)) continue;
                return irongolem$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

