/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.skeleton;

import com.Polarice3.Goety.common.entities.ai.CreatureCrossbowAttackGoal;
import com.Polarice3.Goety.common.entities.ai.path.ModWaterPathNavigation;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.projectiles.Harpoon;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CrossbowHelper;
import com.Polarice3.Goety.utils.MobUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SunkenSkeletonServant
extends AbstractSkeletonServant
implements CrossbowAttackMob {
    private final CreatureCrossbowAttackGoal<SunkenSkeletonServant> crossbowAttackGoal = new CreatureCrossbowAttackGoal<SunkenSkeletonServant>(this, 1.0, 8.0f);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(SunkenSkeletonServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean searchingForLand;
    protected final ModWaterPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public SunkenSkeletonServant(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new ModWaterPathNavigation((Mob)this, worldIn);
        this.groundNavigation = new GroundPathNavigation((Mob)this, worldIn);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Summoned.GoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new GoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new SwimUpGoal(this, 1.0, this.f_19853_.m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal(this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SunkenSkeletonServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.SunkenSkeletonServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SunkenSkeletonServantDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SunkenSkeletonServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.SunkenSkeletonServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SunkenSkeletonServantDamage.get());
    }

    @Override
    public double getBaseRangeDamage() {
        return (Double)AttributesConfig.SunkenSkeletonServantRangeDamage.get();
    }

    @Override
    public void reassessWeaponGoal() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.crossbowAttackGoal);
            ItemStack itemstack = this.m_21205_();
            if (itemstack.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(3, this.crossbowAttackGoal);
            } else {
                this.f_21345_.m_25352_(3, (Goal)this.meleeGoal);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? (SoundEvent)ModSounds.SUNKEN_SKELETON_AMBIENT.get() : SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return this.m_20069_() ? (SoundEvent)ModSounds.SUNKEN_SKELETON_HURT.get() : SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? (SoundEvent)ModSounds.SUNKEN_SKELETON_DEATH.get() : SoundEvents.f_12424_;
    }

    @Override
    protected SoundEvent getStepSound() {
        return this.m_20069_() ? (SoundEvent)ModSounds.SUNKEN_SKELETON_STEP.get() : SoundEvents.f_12383_;
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.m_6069_();
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    private boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public boolean m_6067_() {
        return this.m_6069_();
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    protected boolean closeToNextPos() {
        Path path = this.m_21573_().m_26570_();
        if (path != null) {
            BlockPos blockpos = path.m_77406_();
            double d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            return d0 < 4.0;
        }
        return false;
    }

    public void setSearchingForLand(boolean p_204713_1_) {
        this.searchingForLand = p_204713_1_;
    }

    @Override
    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        if (this.canSpawnArmor()) {
            super.m_213945_(p_219059_, p_219060_);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean p_33302_) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)p_33302_);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33272_, float p_33273_) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public void m_32336_(@NotNull LivingEntity shooter, float velocity) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)shooter, item -> item instanceof CrossbowItem);
        ItemStack itemstack = shooter.m_21120_(interactionhand);
        if (shooter.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            SoundEvent soundEvent = this.m_20069_() ? (SoundEvent)ModSounds.SUNKEN_SKELETON_SHOOT.get() : SoundEvents.f_11847_;
            CrossbowHelper.performCustomShooting(shooter.f_19853_, shooter, interactionhand, itemstack, (Projectile)this.getArrow(itemstack, 1.0f), soundEvent, velocity, 14 - shooter.f_19853_.m_46791_().m_19028_() * 4);
        }
        this.m_5847_();
    }

    public void m_5811_(@NotNull LivingEntity target, @NotNull ItemStack itemStack, @NotNull Projectile projectile, float v) {
        this.m_32322_((LivingEntity)this, target, projectile, v, 1.6f);
    }

    public void m_32322_(LivingEntity p_32323_, LivingEntity p_32324_, Projectile p_32325_, float p_32326_, float p_32327_) {
        double d0 = p_32324_.m_20185_() - p_32323_.m_20185_();
        double d1 = p_32324_.m_20189_() - p_32323_.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = p_32324_.m_20227_(0.3333333333333333) - p_32325_.m_20186_() + d2 * (double)0.2f;
        Vector3f vector3f = this.m_252851_(p_32323_, new Vec3(d0, d3, d1), p_32326_);
        p_32325_.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), p_32327_, (float)(14 - p_32323_.m_9236_().m_46791_().m_19028_() * 4));
        SoundEvent soundEvent = this.m_20069_() ? (SoundEvent)ModSounds.SUNKEN_SKELETON_SHOOT.get() : SoundEvents.f_11847_;
        p_32323_.m_5496_(soundEvent, 1.0f, 1.0f / (p_32323_.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public AbstractArrow getArrow(ItemStack pArrowStack, float pDistanceFactor) {
        Harpoon harpoon = new Harpoon(this.f_19853_, (LivingEntity)this);
        harpoon.m_36878_(pArrowStack);
        harpoon.m_36745_((LivingEntity)this, pDistanceFactor);
        harpoon.m_36740_(SoundEvents.f_11840_);
        harpoon.m_36793_(true);
        harpoon.m_36781_(harpoon.m_36789_() + this.getArrowPower() + this.getBaseRangeDamage());
        int i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44961_, (ItemStack)this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof CrossbowItem)));
        if (i > 0) {
            harpoon.m_36767_((byte)i);
        }
        harpoon.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        return harpoon;
    }

    static class MoveHelperController
    extends MoveControl {
        private final SunkenSkeletonServant skeletonServant;

        public MoveHelperController(SunkenSkeletonServant p_i48909_1_) {
            super((Mob)p_i48909_1_);
            this.skeletonServant = p_i48909_1_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.skeletonServant.m_5448_();
            LivingEntity owner = this.skeletonServant.getTrueOwner();
            if (this.skeletonServant.wantsToSwim() && this.skeletonServant.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.skeletonServant.m_20186_() || this.skeletonServant.searchingForLand || owner != null && owner.m_20186_() > this.skeletonServant.m_20186_() && this.skeletonServant.isFollowing()) {
                    this.skeletonServant.m_20256_(this.skeletonServant.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.skeletonServant.m_21573_().m_26571_()) {
                    this.skeletonServant.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.skeletonServant.m_20185_();
                double d1 = this.f_24976_ - this.skeletonServant.m_20186_();
                double d2 = this.f_24977_ - this.skeletonServant.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.skeletonServant.m_146922_(this.m_24991_(this.skeletonServant.m_146908_(), f, 90.0f));
                this.skeletonServant.m_5618_(this.skeletonServant.m_146908_());
                float f1 = (float)(this.f_24978_ * this.skeletonServant.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.skeletonServant.m_6113_(), (float)f1);
                this.skeletonServant.m_7910_(f2);
                this.skeletonServant.m_20256_(this.skeletonServant.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.skeletonServant.m_20096_()) {
                    this.skeletonServant.m_20256_(this.skeletonServant.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final SunkenSkeletonServant skeleton;

        public GoToBeachGoal(SunkenSkeletonServant p_i48911_1_, double p_i48911_2_) {
            super((PathfinderMob)p_i48911_1_, p_i48911_2_, 8, 2);
            this.skeleton = p_i48911_1_;
        }

        public boolean m_8036_() {
            if (this.skeleton.getTrueOwner() != null && this.skeleton.isFollowing()) {
                return false;
            }
            return super.m_8036_() && !this.skeleton.m_9236_().m_46461_() && this.skeleton.m_20069_() && this.skeleton.m_20186_() >= (double)(this.skeleton.m_9236_().m_5736_() - 3);
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockPos blockpos = pPos.m_7494_();
            return pLevel.m_46859_(blockpos) && pLevel.m_46859_(blockpos.m_7494_()) && pLevel.m_8055_(pPos).m_60634_((BlockGetter)pLevel, pPos, (Entity)this.skeleton);
        }

        public void m_8056_() {
            this.skeleton.setSearchingForLand(false);
            this.skeleton.f_21344_ = (PathNavigation)this.skeleton.groundNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final SunkenSkeletonServant skeleton;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(SunkenSkeletonServant p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.skeleton = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean m_8036_() {
            if (this.skeleton.getTrueOwner() != null && this.skeleton.isFollowing()) {
                return false;
            }
            return !this.skeleton.m_9236_().m_46461_() && this.skeleton.m_20069_() && this.skeleton.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.skeleton.m_20186_() < (double)(this.seaLevel - 1) && (this.skeleton.m_21573_().m_26571_() || this.skeleton.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.skeleton, (int)4, (int)8, (Vec3)new Vec3(this.skeleton.m_20185_(), (double)(this.seaLevel - 1), this.skeleton.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.skeleton.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.skeleton.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.skeleton.setSearchingForLand(false);
        }
    }
}

