/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.servants;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.PortalShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.hostile.cultists.Heretic;
import com.Polarice3.Goety.common.entities.hostile.cultists.Maverick;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinBruteServant;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinServant;
import com.Polarice3.Goety.common.entities.util.SummonCircle;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.NetherSpreaderUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class ObsidianMonolith
extends AbstractMonolith
implements Enemy {
    protected static final EntityDataAccessor<Float> DATA_PROGRESS = SynchedEntityData.m_135353_(ObsidianMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DATA_LEVEL = SynchedEntityData.m_135353_(ObsidianMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_LEVELING = SynchedEntityData.m_135353_(ObsidianMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int empowered;
    public int shieldTime;
    public int destroyBlocksTick;
    public boolean shouldSpawnHeretics;
    private final NetherSpreaderUtil netherSpreaderUtil = NetherSpreaderUtil.createLevelSpreader();

    public ObsidianMonolith(EntityType<? extends AbstractMonolith> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ObsidianMonolithHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.ObsidianMonolithArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ObsidianMonolithHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.ObsidianMonolithArmor.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DATA_LEVELING, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag p_31485_) {
        super.m_7380_(p_31485_);
        p_31485_.m_128379_("ShouldSpawnHeretics", this.shouldSpawnHeretics);
        p_31485_.m_128350_("SpreaderProgress", this.getSpreaderProgress());
        p_31485_.m_128405_("SpreaderLevel", this.getSpreaderLevel());
        p_31485_.m_128405_("SpreaderLeveling", this.getSpreaderLeveling());
    }

    @Override
    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        if (p_31474_.m_128441_("ShouldSpawnHeretics")) {
            this.shouldSpawnHeretics = p_31474_.m_128471_("ShouldSpawnHeretics");
        }
        if (p_31474_.m_128441_("SpreaderProgress")) {
            this.setSpreaderProgress(p_31474_.m_128457_("SpreaderProgress"));
        }
        if (p_31474_.m_128441_("SpreaderLevel")) {
            this.setSpreaderLevel(p_31474_.m_128451_("SpreaderLevel"));
        }
        if (p_31474_.m_128441_("SpreaderLeveling")) {
            this.setSpreaderLeveling(p_31474_.m_128451_("SpreaderLeveling"));
        }
    }

    public void setSpreaderProgress(float spreaderProgress) {
        this.f_19804_.m_135381_(DATA_PROGRESS, (Object)Float.valueOf(spreaderProgress));
    }

    public float getSpreaderProgress() {
        return ((Float)this.f_19804_.m_135370_(DATA_PROGRESS)).floatValue();
    }

    public void setSpreaderLevel(int spreaderLevel) {
        this.f_19804_.m_135381_(DATA_LEVEL, (Object)spreaderLevel);
    }

    public int getSpreaderLevel() {
        return (Integer)this.f_19804_.m_135370_(DATA_LEVEL);
    }

    public void setSpreaderLeveling(int spreaderLevel) {
        this.f_19804_.m_135381_(DATA_LEVELING, (Object)spreaderLevel);
    }

    public int getSpreaderLeveling() {
        return (Integer)this.f_19804_.m_135370_(DATA_LEVELING);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason != MobSpawnType.STRUCTURE) {
            if (this.canSpawn((Level)pLevel.m_6018_())) {
                if (pReason != MobSpawnType.MOB_SUMMONED && pReason != MobSpawnType.SPAWN_EGG) {
                    this.shouldSpawnHeretics = this.getTrueOwner() == null;
                }
                this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 10.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12326_, 10.0f, 0.25f);
            }
        } else {
            this.shouldSpawnHeretics = false;
        }
        return pSpawnData;
    }

    public static boolean checkOMSpawnRules(EntityType<? extends Owned> p_217058_, LevelAccessor p_217059_, MobSpawnType p_217060_, BlockPos p_217061_, RandomSource p_217062_) {
        List monoliths = p_217059_.m_45976_(ObsidianMonolith.class, new AABB(p_217061_).m_82377_(32.0, 16.0, 32.0));
        if (!monoliths.isEmpty()) {
            return false;
        }
        if (p_217059_ instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)p_217059_;
            return ObsidianMonolith.checkHostileSpawnRules(p_217058_, serverLevelAccessor, p_217060_, p_217061_, p_217062_);
        }
        return false;
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50080_.m_49966_();
    }

    public boolean m_5789_() {
        return super.m_5789_() && this.empowered <= 0;
    }

    @Override
    public boolean m_21532_() {
        return super.m_21532_() || this.empowered > 0;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        int particles = 5;
        int efficiency = 0;
        boolean damage = false;
        if (!this.f_19853_.f_46443_ && !this.isEmerging()) {
            LivingEntity living;
            LivingEntity livingEntity;
            if (pSource.m_269533_(DamageTypeTags.f_268415_) || pSource.m_269533_(DamageTypeTags.f_268745_)) {
                return false;
            }
            if (this.empowered > 0 && !pSource.m_269533_(DamageTypeTags.f_268738_)) {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
                this.m_5496_(SoundEvents.f_12031_, 1.0f, 0.5f);
                if (pSource.m_276093_(DamageTypes.f_268612_) && this.destroyBlocksTick <= 0) {
                    this.destroyBlocksTick = 20;
                }
                return false;
            }
            if ((pSource.m_276093_(DamageTypes.f_268612_) || pSource.m_276093_(DamageTypes.f_286973_)) && (livingEntity = this.getTrueOwner()) instanceof Apostle) {
                Apostle apostle = (Apostle)livingEntity;
                this.teleportTowards((Entity)apostle);
            }
            if (ModDamageSource.physicalAttacks(pSource) && (livingEntity = pSource.m_7640_()) instanceof LivingEntity && (living = livingEntity).m_21205_().m_41735_(this.getState())) {
                damage = true;
                efficiency += EnchantmentHelper.m_44926_((LivingEntity)living);
            }
            if (damage) {
                pAmount *= 2.0f + (float)efficiency / 2.0f;
                particles = 20;
            }
            if ((livingEntity = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)livingEntity;
                for (int i = 0; i < particles; ++i) {
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, this.getParticles(), (Entity)this);
                }
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void silentDie(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            Apostle apostle;
            Mob mob;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new PortalShockwaveParticleOption(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()), this.getState(), serverLevel);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()).m_7494_(), this.getState(), serverLevel);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()).m_7494_().m_7494_(), Blocks.f_50723_.m_49966_(), serverLevel);
            new SpellExplosion(this.f_19853_, null, this.m_269291_().m_269425_(), this.m_20183_(), 16.0f, 5.0f){

                @Override
                public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                    ZombifiedPiglin piglin;
                    if (target instanceof IOwned) {
                        IOwned owned = (IOwned)target;
                        if (target instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)target;
                            if ((owned.getTrueOwner() == ObsidianMonolith.this.getTrueOwner() || owned.getTrueOwner() == ObsidianMonolith.this) && !(owned instanceof ObsidianMonolith) && living.m_6469_(living.m_269291_().m_269425_(), (float)ObsidianMonolith.this.f_19853_.f_46441_.m_188503_(10) + 5.0f)) {
                                ObsidianMonolith.this.launch((Entity)living, (LivingEntity)ObsidianMonolith.this);
                            }
                        }
                    }
                    if (target instanceof ZombifiedPiglin && (piglin = (ZombifiedPiglin)target).m_6084_()) {
                        piglin.m_21373_();
                        piglin.m_146870_();
                    }
                }
            };
            Entity entity = cause.m_7639_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == this && this.getTrueOwner() != null) {
                mob.m_6710_(this.getTrueOwner());
            }
            if ((entity = this.getTrueOwner()) instanceof Apostle && (apostle = (Apostle)entity).m_6084_()) {
                apostle.setMonolithCoolDown(MathHelper.minutesToTicks(1));
            }
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void m_6667_(DamageSource cause) {
        this.m_5496_((SoundEvent)SoundEvents.f_12377_.get(), 5.0f, 0.5f);
        this.m_5496_(SoundEvents.f_12601_, 5.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        this.silentDie(cause);
    }

    protected void m_6668_(DamageSource p_21192_) {
        LivingEntity living;
        Entity entity;
        if (ModDamageSource.physicalAttacks(p_21192_) && (entity = p_21192_.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41735_(this.getState())) {
            super.m_6668_(p_21192_);
        }
    }

    private void launch(Entity p_213688_1_, LivingEntity livingEntity) {
        double d0 = p_213688_1_.m_20185_() - livingEntity.m_20185_();
        double d1 = p_213688_1_.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        MobUtil.push(p_213688_1_, d0 / d2 * 6.0, 0.4, d1 / d2 * 6.0);
    }

    public int m_8100_() {
        return 100;
    }

    protected SoundEvent m_7515_() {
        if (!this.isEmerging()) {
            return SoundEvents.f_12375_;
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        LivingEntity living;
        Entity entity;
        if (ModDamageSource.physicalAttacks(p_34154_) && (entity = p_34154_.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41735_(this.getState())) {
            return SoundEvents.f_12600_;
        }
        return SoundEvents.f_12198_;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    @Override
    public boolean canSpawn(Level level) {
        return level.m_45772_(this.getInitialBB()) && level.m_183134_((Entity)this, this.getInitialBB()).isEmpty() && !level.m_46855_(this.getInitialBB());
    }

    public boolean m_142038_() {
        return !this.f_19853_.m_5776_() && !this.isEmerging() && this.getTrueOwner() != null || super.m_142038_();
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 6) {
            this.shieldTime = 10;
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public boolean canTarget() {
        return true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.isEmerging()) {
            if (this.f_19853_.f_46443_) {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
                }
                if (this.getCrackiness() != AbstractMonolith.Crackiness.NONE && this.f_19853_.f_46441_.m_188503_(5) == 0) {
                    int j = this.getCrackiness() == AbstractMonolith.Crackiness.LOW ? 1 : (this.getCrackiness() == AbstractMonolith.Crackiness.MEDIUM ? 3 : 5);
                    for (int i = 0; i < j; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123786_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
                    }
                }
                if (this.shieldTime > 0) {
                    --this.shieldTime;
                }
            }
            if (!this.isActivate()) {
                this.m_5496_(SoundEvents.f_12376_, 1.0f, 0.5f);
                if (this.shouldSpawnHeretics) {
                    this.spawnHeretics();
                }
                this.setActivate(true);
            } else {
                if (this.empowered > 0) {
                    --this.empowered;
                    if (this.f_19797_ % MathHelper.secondsToTicks(20) == 0) {
                        this.m_5496_((SoundEvent)ModSounds.SCARY_RECITE.get(), 1.0f, this.m_6100_());
                    }
                }
                if (this.f_19797_ % 50 == 0) {
                    Level i = this.f_19853_;
                    if (i instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)i;
                        ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_RED);
                        serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 5.0f, 0, true), this.m_20185_(), this.m_20188_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                    for (Cultist cultist : this.f_19853_.m_45976_(Cultist.class, this.m_20191_().m_82400_(16.0))) {
                        if (cultist instanceof Apostle || !(cultist.m_21223_() < cultist.m_21233_())) continue;
                        cultist.m_5634_(1.0f);
                    }
                }
            }
            int time = 160;
            switch (this.f_19853_.m_46791_()) {
                case NORMAL: {
                    time = 80;
                    break;
                }
                case HARD: {
                    time = 40;
                }
            }
            LivingEntity livingEntity2 = this.getTrueOwner();
            if (livingEntity2 instanceof Apostle) {
                Apostle apostle = (Apostle)livingEntity2;
                this.m_146915_(true);
                if (apostle.m_21224_()) {
                    this.silentDie(this.m_269291_().m_269064_());
                }
                if (!this.m_142582_((Entity)apostle)) {
                    this.teleportTowards((Entity)apostle);
                }
                apostle.obsidianInvul = 10;
                if (((Boolean)MobsConfig.ApocalypseMode.get()).booleanValue()) {
                    this.spreadNether();
                } else if (!this.netherSpreaderUtil.getCursors().isEmpty()) {
                    this.netherSpreaderUtil.clear();
                }
                if (apostle.m_5448_() != null) {
                    int j;
                    int i = this.f_19853_.m_6443_(Owned.class, this.m_20191_().m_82400_(16.0), apostle.ZOMBIE_MINIONS).size();
                    Integer[] difficulty = this.difficultyIntegerMap().get(this.f_19853_.m_46791_());
                    int n = this.getCrackiness() == AbstractMonolith.Crackiness.NONE ? difficulty[0] : (this.getCrackiness() == AbstractMonolith.Crackiness.LOW ? difficulty[1] : (j = this.getCrackiness() == AbstractMonolith.Crackiness.MEDIUM ? difficulty[2] : 1));
                    if (this.f_19797_ % time == 0 && i < j && this.f_19853_.f_46441_.m_188501_() <= 0.25f && !apostle.isSettingUpSecond() && !this.f_19853_.f_46443_) {
                        ServerLevel ServerLevel2 = (ServerLevel)this.f_19853_;
                        RandomSource r = this.f_19853_.f_46441_;
                        int numbers = apostle.isSecondPhase() ? 4 : 2;
                        for (ZombifiedPiglin zombifiedPiglin : this.f_19853_.m_45976_(ZombifiedPiglin.class, this.m_20191_().m_82400_(16.0))) {
                            if (zombifiedPiglin.m_5448_() == apostle.m_5448_()) continue;
                            zombifiedPiglin.m_6710_(apostle.m_5448_());
                        }
                        for (int p = 0; p < r.m_188503_(numbers) + 1; ++p) {
                            ZPiglinServant summon = this.f_19853_.f_46441_.m_188501_() > 0.25f || !apostle.isSecondPhase() ? new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), this.f_19853_) : new ZPiglinBruteServant((EntityType<? extends ZPiglinServant>)((EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get()), this.f_19853_);
                            BlockPos blockPos = BlockFinder.SummonRadius(this.m_20183_(), (Entity)summon, this.f_19853_);
                            summon.m_20035_(blockPos, 0.0f, 0.0f);
                            summon.setTrueOwner((LivingEntity)apostle);
                            summon.setLimitedLife(MobUtil.getSummonLifespan(this.f_19853_));
                            SummonCircle summonCircle = new SummonCircle(this.f_19853_, blockPos, (Entity)summon, true, true, (LivingEntity)apostle);
                            this.f_19853_.m_7967_((Entity)summonCircle);
                        }
                    }
                }
            } else if (this.getTrueOwner() == null && !this.f_19853_.f_46443_) {
                int heretics = this.f_19853_.m_6443_(Heretic.class, this.m_20191_().m_82377_(32.0, 16.0, 32.0), LivingEntity::m_6084_).size();
                ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                RandomSource random1 = this.f_19853_.f_46441_;
                int spawnChance = 256;
                if (this.empowered > 0) {
                    this.spreadNether();
                    int i = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(24.0, 16.0, 24.0), livingEntity -> livingEntity.m_6084_() && livingEntity instanceof Maverick).size();
                    if (this.f_19797_ % time == 0 && random1.m_188501_() <= 0.25f && i < 8) {
                        Maverick maverick = new Maverick((EntityType<? extends Cultist>)((EntityType)ModEntityType.MAVERICK.get()), this.f_19853_);
                        int i1 = this.m_20183_().m_123341_() + Mth.m_216287_((RandomSource)random1, (int)4, (int)12) * Mth.m_216287_((RandomSource)random1, (int)-1, (int)1);
                        int j1 = this.m_20183_().m_123342_() + Mth.m_216287_((RandomSource)random1, (int)0, (int)3) * Mth.m_216287_((RandomSource)random1, (int)-1, (int)1);
                        int k1 = this.m_20183_().m_123343_() + Mth.m_216287_((RandomSource)random1, (int)4, (int)12) * Mth.m_216287_((RandomSource)random1, (int)-1, (int)1);
                        BlockPos blockPos = BlockFinder.SummonPosition((Entity)maverick, new BlockPos(i1, j1, k1));
                        maverick.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                        if (this.f_19853_.m_45772_(maverick.m_20191_()) && this.f_19853_.m_183134_((Entity)maverick, maverick.m_20191_()).isEmpty() && !this.f_19853_.m_46855_(maverick.m_20191_())) {
                            maverick.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                            maverick.setLeader((Entity)this);
                            if (this.m_5448_() != null) {
                                maverick.m_6710_(this.m_5448_());
                            }
                            maverick.m_21373_();
                            this.f_19853_.m_7967_((Entity)maverick);
                        }
                    }
                    spawnChance = 64;
                } else {
                    this.netherSpreaderUtil.clear();
                }
                if (serverLevel.f_46441_.m_188503_(spawnChance) == 0) {
                    float f1;
                    MobSpawnSettings.SpawnerData spawner;
                    WeightedRandomList<MobSpawnSettings.SpawnerData> spawners;
                    int j = serverLevel.m_45971_(Mob.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(32.0, 16.0, 32.0)).size();
                    if (j < 16 && !(spawners = MobUtil.mobsAt(serverLevel, serverLevel.m_215010_(), serverLevel.m_7726_().m_8481_(), MobCategory.MONSTER, this.m_20183_(), (Holder<Biome>)serverLevel.m_204166_(this.m_20183_()))).m_146337_() && (spawner = (MobSpawnSettings.SpawnerData)spawners.m_216829_(serverLevel.f_46441_).orElse(null)) != null) {
                        Entity entity = spawner.f_48404_.m_20615_((Level)serverLevel);
                        BlockPos blockPos = BlockFinder.SummonRadius(this.m_20183_(), entity, (Level)serverLevel, 24);
                        SpawnPlacements.Type spawnplacements$type = SpawnPlacements.m_21752_((EntityType)spawner.f_48404_);
                        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)spawnplacements$type, (LevelReader)this.f_19853_, (BlockPos)blockPos, (EntityType)spawner.f_48404_) && SpawnPlacements.m_217074_((EntityType)spawner.f_48404_, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockPos, (RandomSource)serverLevel.f_46441_)) {
                            if (entity instanceof Mob) {
                                Mob mob = (Mob)entity;
                                if (!(entity instanceof Ghast || entity instanceof AbstractPiglin || entity instanceof Hoglin)) {
                                    mob.m_6034_((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + 0.5f));
                                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(blockPos), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
                                    if (serverLevel.m_7967_((Entity)mob)) {
                                        ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123744_, (Entity)mob);
                                    }
                                }
                            }
                        } else if (entity != null) {
                            entity.m_146870_();
                        }
                    }
                    float f = this.getCrackiness() == AbstractMonolith.Crackiness.NONE ? 0.125f : (this.getCrackiness() == AbstractMonolith.Crackiness.LOW ? 0.2f : (f1 = this.getCrackiness() == AbstractMonolith.Crackiness.MEDIUM ? 0.25f : 0.3f));
                    if (heretics <= 2 && random1.m_188501_() <= f1) {
                        Heretic heretic = new Heretic((EntityType<? extends Cultist>)((EntityType)ModEntityType.HERETIC.get()), this.f_19853_);
                        int i1 = this.m_20183_().m_123341_() + Mth.m_216287_((RandomSource)random1, (int)4, (int)12) * Mth.m_216287_((RandomSource)random1, (int)-1, (int)1);
                        int j1 = this.m_20183_().m_123342_() + Mth.m_216287_((RandomSource)random1, (int)0, (int)3) * Mth.m_216287_((RandomSource)random1, (int)-1, (int)1);
                        int k1 = this.m_20183_().m_123343_() + Mth.m_216287_((RandomSource)random1, (int)4, (int)12) * Mth.m_216287_((RandomSource)random1, (int)-1, (int)1);
                        BlockPos blockPos = BlockFinder.SummonPosition((Entity)heretic, new BlockPos(i1, j1, k1));
                        heretic.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                        if (this.f_19853_.m_45772_(heretic.m_20191_()) && this.f_19853_.m_183134_((Entity)heretic, heretic.m_20191_()).isEmpty() && !this.f_19853_.m_46855_(heretic.m_20191_())) {
                            heretic.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                            heretic.m_21530_();
                            heretic.setLeader((Entity)this);
                            heretic.setMonolith(this);
                            heretic.m_21373_();
                            this.f_19853_.m_7967_((Entity)heretic);
                        }
                    }
                }
                if (this.destroyBlocksTick > 0) {
                    --this.destroyBlocksTick;
                    if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                        int x = Mth.m_14107_((double)this.m_20185_());
                        int y = Mth.m_14107_((double)this.m_20186_());
                        int z = Mth.m_14107_((double)this.m_20189_());
                        boolean flag = false;
                        for (int x1 = -3; x1 <= 3; ++x1) {
                            for (int y1 = 0; y1 <= 4; ++y1) {
                                for (int z1 = -3; z1 <= 3; ++z1) {
                                    int l2 = x + x1;
                                    int l = y + y1;
                                    int i1 = z + z1;
                                    BlockPos blockpos = new BlockPos(l2, l, i1);
                                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                                    if (blockstate.m_204336_(BlockTags.f_13070_) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                                    flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
                                }
                            }
                        }
                        if (flag) {
                            this.f_19853_.m_5898_(null, 1022, this.m_20183_(), 0);
                        }
                    }
                }
            }
        }
    }

    public void spreadNether() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int activeHeretics = this.f_19853_.m_6443_(Heretic.class, this.m_20191_().m_82400_(10.0), living -> living.m_6084_() && living.isCasting() && living.getMonolith() == this).size();
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && ((Boolean)MobsConfig.ObsidianMonolithSpread.get()).booleanValue() && this.f_19853_.m_46472_() != Level.f_46429_) {
                this.netherSpreaderUtil.updateCursors((LevelAccessor)this.f_19853_, this.m_20183_().m_7495_(), this.f_19796_, true);
                if (this.getSpreaderLeveling() >= 100) {
                    this.setSpreaderLeveling(0);
                    if (this.getSpreaderLevel() < 9) {
                        this.setSpreaderLevel(this.getSpreaderLevel() + 1);
                    }
                }
                if (this.getSpreaderProgress() >= 1.0f) {
                    this.setSpreaderProgress(0.0f);
                    this.setSpreaderLeveling(this.getSpreaderLeveling() + 1);
                    this.netherSpreaderUtil.clear();
                    for (int i = 0; i < 5; ++i) {
                        int range = this.getSpreaderLevel();
                        BlockPos blockPos = this.m_20183_().m_7495_();
                        if (range > 0) {
                            int x = serverLevel.m_213780_().m_216339_(-range, range);
                            int y = serverLevel.m_213780_().m_216339_(-range, range / 2);
                            int z = serverLevel.m_213780_().m_216339_(-range, range);
                            blockPos = this.m_20183_().m_7495_().m_7918_(x, y, z);
                        }
                        this.netherSpreaderUtil.addCursors(blockPos, 10);
                    }
                } else {
                    this.setSpreaderProgress(this.getSpreaderProgress() + 0.005f * (float)(activeHeretics + 1));
                }
            }
        }
    }

    public Map<Difficulty, Integer[]> difficultyIntegerMap() {
        HashMap<Difficulty, Integer[]> difficultyIntegerMap = new HashMap<Difficulty, Integer[]>();
        difficultyIntegerMap.put(Difficulty.PEACEFUL, new Integer[]{0, 0, 0});
        difficultyIntegerMap.put(Difficulty.EASY, new Integer[]{6, 4, 2});
        difficultyIntegerMap.put(Difficulty.NORMAL, new Integer[]{8, 6, 4});
        difficultyIntegerMap.put(Difficulty.HARD, new Integer[]{12, 10, 8});
        return difficultyIntegerMap;
    }

    public boolean m_6783_(double p_31046_) {
        return super.m_6783_(p_31046_) || this.getTrueOwner() != null;
    }

    private void spawnHeretics() {
        for (int i = 0; i < 4; ++i) {
            int x = 2;
            int z = 2;
            switch (i) {
                case 0: {
                    x *= -1;
                    z *= -1;
                    break;
                }
                case 1: {
                    x *= -1;
                    break;
                }
                case 2: {
                    z *= -1;
                }
            }
            Heretic heretic = new Heretic((EntityType<? extends Cultist>)((EntityType)ModEntityType.HERETIC.get()), this.f_19853_);
            BlockPos blockPos = BlockPos.m_274561_((double)(this.m_20185_() + (double)x), (double)(this.m_20186_() - 1.0), (double)(this.m_20189_() + (double)z));
            if (this.f_19853_.m_8055_(blockPos).m_60812_((BlockGetter)this.f_19853_, blockPos).m_83281_()) continue;
            heretic.m_6034_((double)blockPos.m_123341_() + 0.5, this.m_20186_(), (double)blockPos.m_123343_() + 0.5);
            if (!this.f_19853_.m_45772_(heretic.m_20191_()) || !this.f_19853_.m_183134_((Entity)heretic, heretic.m_20191_()).isEmpty() || this.f_19853_.m_46855_(heretic.m_20191_())) continue;
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                heretic.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
            }
            MobUtil.instaLook((Mob)heretic, (Entity)this);
            heretic.m_21530_();
            heretic.m_21373_();
            heretic.setLeader((Entity)this);
            if (!this.f_19853_.m_7967_((Entity)heretic)) continue;
            heretic.setMonolith(this);
        }
    }
}

