/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral.ender;

import com.Polarice3.Goety.api.entities.IHiding;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SRepositionPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.RandomUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public abstract class AbstractEnderling
extends Summoned
implements IHiding {
    private static final EntityDataAccessor<Boolean> DATA_HIDE = SynchedEntityData.m_135353_(AbstractEnderling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int preHidingTime = 0;
    public int hidingTime = 0;
    public int teleportCool;
    public int postTeleportTick;
    public int mobHurtTime;

    public AbstractEnderling(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addBehaviourGoals();
    }

    @Override
    public void targetRetaliateGoal() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this, new Class[]{AbstractEnderling.class}){

            protected void m_5766_(Mob other, LivingEntity target) {
                if (this.f_26135_.m_7307_((Entity)other)) {
                    other.m_6710_(target);
                }
            }
        }.m_26044_(new Class[0]));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerGoal<AbstractEnderling>(this, 1.0, 10.0f, 2.0f){

            @Override
            protected boolean canTeleport() {
                return ((AbstractEnderling)this.summonedEntity).teleportCool <= 0;
            }

            @Override
            protected boolean tryToTeleportToLocation(int x, int y, int z) {
                if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                    return false;
                }
                if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
                    return false;
                }
                ((AbstractEnderling)this.summonedEntity).teleportHits();
                ((AbstractEnderling)this.summonedEntity).m_7678_((double)x + 0.5, y, (double)z + 0.5, ((AbstractEnderling)this.summonedEntity).m_146908_(), ((AbstractEnderling)this.summonedEntity).m_146909_());
                ((AbstractEnderling)this.summonedEntity).teleportCool = MathHelper.secondsToTicks(10);
                this.navigation.m_26573_();
                return true;
            }
        });
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HIDE, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("HidingTime")) {
            this.hidingTime = compound.m_128451_("HidingTime");
        }
        if (compound.m_128441_("TeleportCool")) {
            this.teleportCool = compound.m_128451_("TeleportCool");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("HidingTime", this.hidingTime);
        compound.m_128405_("TeleportCool", this.teleportCool);
    }

    @Override
    public boolean m_7307_(Entity entityIn) {
        if (this.getTrueOwner() == null) {
            if (entityIn instanceof EnderMan) {
                return this.m_5647_() == null && entityIn.m_5647_() == null;
            }
            if (entityIn instanceof AbstractEnderling) {
                AbstractEnderling enderling = (AbstractEnderling)entityIn;
                if (this.m_5647_() == null && entityIn.m_5647_() == null) {
                    return this.isHostile() && enderling.isHostile() || !this.isHostile() && !enderling.isHostile();
                }
            }
        }
        return super.m_7307_(entityIn);
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    public boolean m_6126_() {
        return true;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (this.isHiding()) {
            this.stopHide();
        }
        super.m_6667_(pCause);
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        if (this.isHiding()) {
            return 0.1f;
        }
        return super.m_6431_(p_32517_, p_32518_);
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.isHiding();
    }

    public boolean m_6051_() {
        return !this.isHiding() && super.m_6051_();
    }

    public boolean m_6097_() {
        return super.m_6097_() && !this.isHiding();
    }

    public boolean m_5833_() {
        return super.m_5833_() || this.isHiding();
    }

    public boolean m_6087_() {
        return super.m_6087_() && !this.isHiding();
    }

    @Override
    public boolean m_20177_(Player p_20178_) {
        if (this.isHiding()) {
            return true;
        }
        return super.m_20177_(p_20178_);
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.isHiding();
    }

    public boolean m_6673_(DamageSource p_20122_) {
        return super.m_6673_(p_20122_) || this.isHiding();
    }

    public boolean m_142065_() {
        return super.m_142065_() && !this.isHiding();
    }

    @Override
    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HIDE);
    }

    public void setHide(boolean hide) {
        this.f_19804_.m_135381_(DATA_HIDE, (Object)hide);
    }

    public void m_8032_() {
        if (!this.isHiding()) {
            super.m_8032_();
        }
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        if (!this.isHiding()) {
            this.stepSound();
        }
    }

    public void stepSound() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.teleportCool > 0) {
            --this.teleportCool;
        }
        if (this.postTeleportTick > 0) {
            --this.postTeleportTick;
            this.m_21573_().m_26573_();
        }
        if (this.mobHurtTime > 0) {
            --this.mobHurtTime;
        }
        if (!this.f_19853_.f_46443_) {
            this.hidingTick();
        }
    }

    public void hidingTick() {
        if (!this.isHiding()) {
            this.hidingTime = 0;
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.isGuardingArea() && this.m_20238_(this.vec3BoundPos()) > (double)Mth.m_144944_((int)GUARDING_RANGE)) {
                    Optional optional = RespawnAnchorBlock.m_55839_((EntityType)this.m_6095_(), (CollisionGetter)serverLevel, (BlockPos)this.getBoundPos());
                    optional.ifPresent(this::ownedTeleport);
                }
            }
        } else {
            ++this.hidingTime;
            this.m_21573_().m_26573_();
            this.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.hidingTime >= this.getHidingDuration() || this.shouldStopHiding()) {
                this.stopHide();
                this.teleportAfterHiding();
                this.m_6210_();
            }
        }
    }

    public void startHide() {
        if (!this.isHiding()) {
            this.teleportOut();
        }
        this.setHide(true);
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_6210_();
    }

    public void stopHide() {
        this.setHide(false);
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public int getHidingDuration() {
        return 0;
    }

    public boolean shouldStopHiding() {
        return false;
    }

    public void teleportAfterHiding() {
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        if (this.isHiding()) {
            return EntityDimensions.m_20395_((float)0.1f, (float)0.1f);
        }
        return super.m_6972_(p_21047_);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag;
        boolean flag1;
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7639_() instanceof LivingEntity || source.m_269533_(DamageTypeTags.f_268524_)) {
            this.mobHurtTime = 10;
        }
        boolean bl = flag1 = (flag = source.m_7640_() instanceof ThrownPotion) && this.hurtWithCleanWater(source, (ThrownPotion)source.m_7640_(), amount);
        if (!this.isHiding() && (flag1 || source.m_269533_(DamageTypeTags.f_268581_) || source.m_276093_(DamageTypes.f_268612_)) && this.teleportHurt()) {
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public boolean teleportHurt() {
        if (!this.isStaying() && this.teleportCool <= 0) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                this.teleportCool = MathHelper.secondsToTicks(10);
                return true;
            }
        }
        return false;
    }

    private boolean hurtWithCleanWater(DamageSource p_186273_, ThrownPotion p_186274_, float p_186275_) {
        ItemStack itemstack = p_186274_.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty();
        return flag ? super.m_6469_(p_186273_, p_186275_) : false;
    }

    protected boolean teleport() {
        return this.teleport(64.0);
    }

    protected boolean teleport(double range) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * range;
            double d1 = this.m_20186_() + ((double)RandomUtil.nextInt(this.f_19796_, Mth.m_14107_((double)range)) - range / 2.0);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * range;
            return this.ownedTeleport(d0, d1, d2);
        }
        return false;
    }

    @Override
    public boolean ownedTeleport(double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (flag2) {
                if (!this.f_19853_.f_46443_) {
                    ModNetwork.sendToALL(new SRepositionPacket(this.m_19879_(), this.m_20185_(), this.m_20186_(), this.m_20189_()));
                }
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (this.getHidingDuration() > 0) {
                    this.teleportIn();
                } else {
                    this.teleportHits();
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    public void teleportTowards(Entity entity, double range) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            if (entity == null) {
                this.teleportIn();
                return;
            }
            try {
                for (int i = 0; i < 128; ++i) {
                    double d3;
                    double d2;
                    Vec3 vector3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
                    vector3d = vector3d.m_82541_();
                    double d1 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (range / 2.0) - vector3d.f_82479_ * range;
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)d1, (double)(d2 = this.m_20186_() + ((double)RandomUtil.nextInt(this.m_217043_(), Mth.m_14107_((double)range)) - range / 2.0) - vector3d.f_82480_ * range), (double)(d3 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (range / 2.0) - vector3d.f_82481_ * range));
                    if (event.isCanceled()) {
                        if (this.getHidingDuration() > 0) {
                            this.teleportIn();
                        } else {
                            this.teleportHits();
                        }
                    } else {
                        boolean flag = true;
                        boolean teleport = false;
                        if (this.m_5448_() != null && !BlockFinder.canSeeBlock((Entity)this.m_5448_(), new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ()))) {
                            flag = false;
                        }
                        if (this.isGuardingArea() && this.getSpawnType() == MobSpawnType.SPAWNER && !BlockFinder.canSeeBlock((Entity)this, this.vec3BoundPos())) {
                            flag = false;
                        }
                        if (flag) {
                            teleport = this.ownedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                        }
                        if (teleport) {
                            MobUtil.instaLook((Mob)this, entity);
                        } else {
                            if (i != 127) continue;
                            MobUtil.instaLook((Mob)this, entity);
                            if (this.getHidingDuration() > 0) {
                                this.teleportIn();
                            } else {
                                this.teleportHits();
                            }
                        }
                    }
                    break;
                }
            }
            catch (NullPointerException exception) {
                this.teleportIn();
            }
        }
    }

    protected boolean teleportAway(Entity entity, double range) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            if (entity == null) {
                this.teleportIn();
                return false;
            }
            boolean spawner = false;
            if (this.isGuardingArea() && this.getSpawnType() == MobSpawnType.SPAWNER) {
                spawner = true;
                range /= 2.0;
            }
            try {
                for (int i = 0; i < 128; ++i) {
                    boolean flag;
                    double d2;
                    double d1;
                    double d0 = entity.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * range;
                    Vec3 vec3 = new Vec3(d0, d1 = entity.m_20186_() + ((double)RandomUtil.nextInt(this.f_19796_, Mth.m_14107_((double)range)) - range / 2.0), d2 = entity.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * range);
                    boolean bl = flag = vec3.m_82554_(entity.m_20182_()) >= range;
                    if (this.m_5448_() != null && !BlockFinder.canSeeBlock((Entity)this.m_5448_(), vec3)) {
                        flag = false;
                    }
                    if (spawner && !BlockFinder.canSeeBlock((Entity)this, this.vec3BoundPos())) {
                        Level level;
                        flag = false;
                        if (i >= 120 && (level = this.f_19853_) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            Optional optional = RespawnAnchorBlock.m_55839_((EntityType)this.m_6095_(), (CollisionGetter)serverLevel, (BlockPos)this.getBoundPos());
                            if (optional.isPresent()) {
                                return this.ownedTeleport((Vec3)optional.get());
                            }
                        }
                    }
                    if (!flag && i != 127) continue;
                    return this.ownedTeleport(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
            }
            catch (NullPointerException exception) {
                this.teleportIn();
                return false;
            }
        }
        return false;
    }

    @Override
    public void teleportHits() {
        this.f_19853_.m_7605_((Entity)this, (byte)46);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModSounds.ENDERLING_TELEPORT_OUT.get(), this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.ENDERLING_TELEPORT_IN.get(), 1.0f, 1.0f);
        }
    }

    public void teleportOut() {
        if (!this.m_20067_()) {
            this.m_5496_((SoundEvent)ModSounds.ENDERLING_TELEPORT_OUT.get(), 1.0f, 1.0f);
        }
        this.serverTeleportParticles();
    }

    public void teleportIn() {
        if (!this.m_20067_()) {
            this.m_5496_((SoundEvent)ModSounds.ENDERLING_TELEPORT_IN.get(), 1.0f, 1.0f);
        }
        this.serverTeleportParticles();
    }

    public void serverTeleportParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = 16;
            for (int j = 0; j < i; ++j) {
                ColorUtil colorUtil = new ColorUtil(16175600);
                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SMALL_SPELL_SQUARE.get()), d1, d2, d3, 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
            }
        }
    }

    public void m_7822_(byte pByte) {
        if (pByte == 4) {
            this.setHide(true);
        } else if (pByte == 5) {
            this.setHide(false);
        } else if (pByte == 46) {
            int i = 16;
            for (int j = 0; j < i; ++j) {
                double d0 = (double)j / (double)(i - 1);
                ColorUtil colorUtil = new ColorUtil(16175600);
                double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SMALL_SPELL_SQUARE.get(), d1, d2, d3, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue());
            }
        } else {
            super.m_7822_(pByte);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && item == Items.f_42730_ && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(this.m_7515_() != null ? this.m_7515_() : SoundEvents.f_11912_, 1.0f, 1.25f);
                this.m_5634_(5.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(p_230254_2_);
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(pPlayer, p_230254_2_);
    }
}

