/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral.ender;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.common.entities.projectiles.SnarelingShot;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SRepositionPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AbstractSnareling
extends AbstractEnderling
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> WEB_SHOOTING = SynchedEntityData.m_135353_(AbstractSnareling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(AbstractSnareling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int fleeCool;
    public int fleeTime;
    public int postShootTick;
    public boolean isFleeing;
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String SHOOT = "shoot";
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();

    public AbstractSnareling(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(1.2));
        this.f_21345_.m_25352_(4, new ShootGoal<AbstractSnareling>(this, 1.0, 13.0f));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal<AbstractSnareling>(this, 1.0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !AbstractSnareling.this.isFleeing;
            }

            public boolean m_8045_() {
                return super.m_8045_() && !AbstractSnareling.this.isFleeing;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SnarelingHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.SnarelingArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SnarelingDamage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SnarelingHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.SnarelingArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SnarelingDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WEB_SHOOTING, (Object)false);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("FleeCool")) {
            this.fleeCool = compound.m_128451_("FleeCool");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FleeCool", this.fleeCool);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ANIM_STATE.equals(p_33609_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimations();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                }
            }
        }
        super.m_7350_(p_33609_);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, SHOOT)) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.shootAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    public void setWebShooting(boolean webShooting) {
        this.f_19804_.m_135381_(WEB_SHOOTING, (Object)webShooting);
    }

    public boolean isWebShooting() {
        return (Boolean)this.f_19804_.m_135370_(WEB_SHOOTING);
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractSnareling;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.SnarelingLimit.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SNARELING_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.SNARELING_HURT.get();
    }

    @Override
    public void stepSound() {
        this.m_5496_((SoundEvent)ModSounds.SNARELING_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SNARELING_DEATH.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.getCurrentAnimation() == 0, this.f_19797_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getCurrentAnimation() == this.getAnimationState(ATTACK) && this.f_19797_ % 20 == 0) {
            this.m_5496_((SoundEvent)ModSounds.SNARELING_MELEE.get(), 1.0f, this.m_6100_());
        }
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            if (this.fleeCool > 0) {
                --this.fleeCool;
            }
            if (!this.isWebShooting() && !this.m_5912_()) {
                if (this.fleeCool <= 0 && this.m_5448_() != null) {
                    if ((double)this.m_5448_().m_20270_((Entity)this) <= 3.0) {
                        this.isFleeing = true;
                        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this, (int)16, (int)7, (Vec3)this.m_5448_().m_20182_());
                        if (vec3 != null) {
                            this.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)1.2f);
                        }
                    }
                    if (this.isFleeing) {
                        ++this.fleeTime;
                        if (this.fleeTime >= MathHelper.secondsToTicks(5) || (double)this.m_5448_().m_20270_((Entity)this) > 3.0 && this.m_21573_().m_26571_()) {
                            this.isFleeing = false;
                            this.fleeTime = 0;
                            this.fleeCool = MathHelper.secondsToTicks(5);
                        }
                    }
                }
                if (this.teleportCool <= 0 && !this.isStaying() && this.m_5448_() != null && this.m_5448_().m_20270_((Entity)this) <= 3.5f) {
                    int random = this.m_217043_().m_216332_(8, 12) * 2;
                    if (this.teleportAway((Entity)this.m_5448_(), random)) {
                        this.teleportCool = MathHelper.secondsToTicks(6);
                    }
                }
            }
            if (this.postShootTick > 0) {
                if (this.getCurrentAnimation() == this.getAnimationState(SHOOT)) {
                    --this.postShootTick;
                    if (this.postShootTick <= 1) {
                        this.setAnimationState(IDLE);
                    }
                } else {
                    this.postShootTick = 0;
                }
            }
        }
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        SnarelingShot snowball = new SnarelingShot((LivingEntity)this, this.f_19853_);
        Vec3 vec3 = p_33317_.m_20184_();
        double d0 = p_33317_.m_20185_() + vec3.f_82479_ - this.m_20185_();
        double d1 = p_33317_.m_20186_() + vec3.f_82480_ - this.m_20188_();
        double d2 = p_33317_.m_20189_() + vec3.f_82481_ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        snowball.m_146926_(snowball.m_146909_() - -20.0f);
        snowball.m_6686_(d0, d1 + d3 * 0.2, d2, 0.95f, 8.0f);
        this.f_19853_.m_7967_((Entity)snowball);
    }

    public class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)AbstractSnareling.this, moveSpeed, true);
        }

        public boolean m_8036_() {
            return AbstractSnareling.this.m_5448_() != null && AbstractSnareling.this.m_5448_().m_6084_() && AbstractSnareling.this.m_5448_().m_21023_((MobEffect)GoetyEffects.TANGLED.get());
        }

        public boolean m_8045_() {
            if (AbstractSnareling.this.m_5448_() == null || AbstractSnareling.this.m_5448_().m_21224_() || !AbstractSnareling.this.m_5448_().m_21023_((MobEffect)GoetyEffects.TANGLED.get())) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            super.m_8056_();
            AbstractSnareling.this.m_5496_((SoundEvent)ModSounds.SNARELING_MELEE_VOCAL.get(), 1.0f, AbstractSnareling.this.m_6100_());
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractSnareling.this.setAnimationState(IDLE);
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = AbstractSnareling.this.m_5448_();
            if (target != null) {
                MobUtil.instaLook((Mob)AbstractSnareling.this, (Entity)target);
                this.m_6739_(target, AbstractSnareling.this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()));
            }
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr > d0) {
                Vec3 vec3 = enemy.m_20182_().m_272010_(AbstractSnareling.this.m_217043_(), 2.0f);
                if (AbstractSnareling.this.teleportCool <= 0) {
                    if (AbstractSnareling.this.m_20984_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, true)) {
                        if (!AbstractSnareling.this.f_19853_.f_46443_) {
                            ModNetwork.sendToALL(new SRepositionPacket(AbstractSnareling.this.m_19879_(), AbstractSnareling.this.m_20185_(), AbstractSnareling.this.m_20186_(), AbstractSnareling.this.m_20189_()));
                        }
                        AbstractSnareling.this.teleportCool = MathHelper.secondsToTicks(6);
                    } else {
                        AbstractSnareling.this.m_21573_().m_5624_((Entity)enemy, 1.2);
                    }
                } else {
                    AbstractSnareling.this.m_21573_().m_5624_((Entity)enemy, 1.2);
                }
            } else {
                AbstractSnareling.this.m_21573_().m_26573_();
                AbstractSnareling.this.setAnimationState(ATTACK);
                AbstractSnareling.this.m_7327_((Entity)enemy);
            }
        }

        protected double m_6639_(LivingEntity livingEntity) {
            return this.f_25540_.m_20205_() * 4.0f * this.f_25540_.m_20205_() * 4.0f + livingEntity.m_20205_();
        }
    }

    public static class ShootGoal<T extends AbstractSnareling>
    extends Goal {
        private final T mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = 25;
        private final double speedModifier;
        private final float attackRadius;

        public ShootGoal(T mob, double speed, float attackRadius) {
            this.mob = mob;
            this.speedModifier = speed;
            this.attackRadius = attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && !((AbstractSnareling)this.mob).isFleeing) {
                this.target = livingentity;
                return !livingentity.m_21023_((MobEffect)GoetyEffects.TANGLED.get()) && this.mob.m_20270_((Entity)livingentity) > 3.0f;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21573_().m_26573_();
        }

        public void m_8041_() {
            ((AbstractSnareling)this.mob).setAnimationState(IDLE);
            this.target = null;
            this.attackTime = -1;
            ((AbstractSnareling)this.mob).setWebShooting(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
                if (this.mob.m_20270_((Entity)this.target) <= this.attackRadius) {
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                }
                this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                --this.attackTime;
                if (this.attackTime == MathHelper.secondsToTicks(0.8f)) {
                    ((AbstractSnareling)this.mob).setWebShooting(true);
                    ((AbstractSnareling)this.mob).setAnimationState(SHOOT);
                    ((AbstractSnareling)this.mob).postShootTick = 46;
                    this.mob.m_5496_((SoundEvent)ModSounds.SNARELING_SHOOT.get(), 1.0f, this.mob.m_6100_());
                } else if (this.attackTime == 0) {
                    if (!flag) {
                        return;
                    }
                    float f = (float)Math.sqrt(d0) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    ((AbstractSnareling)this.mob).m_6504_(this.target, f1);
                    this.attackTime = MathHelper.secondsToTicks(6);
                    ((AbstractSnareling)this.mob).setWebShooting(false);
                } else if (this.attackTime < 0) {
                    ((AbstractSnareling)this.mob).setAnimationState(IDLE);
                    this.attackTime = MathHelper.secondsToTicks(6);
                    ((AbstractSnareling)this.mob).setWebShooting(false);
                }
            }
        }
    }
}

