/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.AbstractCyclone;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class UpdraftBlast
extends Entity {
    public LivingEntity owner;
    private UUID ownerUniqueId;
    private float damage = ((Double)SpellConfig.UpdraftBlastDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
    private float areaOfEffect = 0.0f;

    public UpdraftBlast(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19794_ = true;
    }

    public UpdraftBlast(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.UPDRAFT_BLAST.get(), worldIn);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.ownerUniqueId = compound.m_128342_("Owner");
        }
        this.damage = compound.m_128457_("Damage");
        this.areaOfEffect = compound.m_128457_("AreaOfEffect");
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUniqueId != null) {
            compound.m_128362_("Owner", this.ownerUniqueId);
        }
        compound.m_128350_("Damage", this.damage);
        compound.m_128350_("AreaOfEffect", this.areaOfEffect);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setAreaOfEffect(float damage) {
        this.areaOfEffect = damage;
    }

    public float getAreaOfEffect() {
        return this.areaOfEffect;
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float area = this.getAreaOfEffect() / 2.0f;
            float f = 1.5f + area;
            ColorUtil color = new ColorUtil(0xFFFFFF);
            ServerParticleUtil.windParticle(serverLevel, color, f - 1.0f + serverLevel.f_46441_.m_188501_() * 0.5f, 0.0f, this.m_19879_(), this.m_20182_());
            ServerParticleUtil.windParticle(serverLevel, color, f + serverLevel.f_46441_.m_188501_() * 0.5f, 0.0f, this.m_19879_(), this.m_20182_());
            if (this.f_19797_ == 20) {
                ArrayList<Entity> targets = new ArrayList<Entity>();
                float area0 = 1.0f + area;
                AABB aabb = this.m_20191_();
                AABB aabb1 = new AABB(aabb.f_82288_ - (double)area0, aabb.f_82289_ - 1.0, aabb.f_82290_ - (double)area0, aabb.f_82291_ + (double)area0, aabb.f_82292_ + 1.0, aabb.f_82293_ + (double)area0);
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, aabb1)) {
                    if (this.owner != null) {
                        if (entity == this.owner || MobUtil.areAllies(entity, (Entity)this.owner)) continue;
                        targets.add(entity);
                        continue;
                    }
                    targets.add(entity);
                }
                if (!targets.isEmpty()) {
                    for (Entity entity : targets) {
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            livingEntity.m_6469_(ModDamageSource.windBlast(this, (Entity)this.owner), this.damage);
                            MobUtil.push((Entity)livingEntity, 0.0, 1.0, 0.0);
                            continue;
                        }
                        if (!(entity instanceof AbstractCyclone)) continue;
                        AbstractCyclone cyclone = (AbstractCyclone)entity;
                        cyclone.trueRemove();
                    }
                }
            }
        }
        if (this.f_19797_ == 1) {
            this.m_5496_((SoundEvent)ModSounds.UPDRAFT_BLAST.get(), 0.9f, 1.5f);
        }
        if (this.f_19797_ > 20) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.f_19797_ % 30 == 0) {
            this.m_146870_();
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

