/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.AoEParticleOption;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.MagicFire;
import com.Polarice3.Goety.common.entities.util.AbstractTrap;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningBoltPacket;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VoidLightningTrap
extends AbstractTrap {
    public VoidLightningTrap(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setParticle((ParticleOptions)ModParticleTypes.NONE.get());
    }

    public VoidLightningTrap(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.VOID_LIGHTNING_TRAP.get(), worldIn);
        this.m_6034_(x, y, z);
    }

    @Override
    public float radius() {
        return 1.5f;
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19797_ == 1 && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ColorUtil colorUtil = new ColorUtil(ChatFormatting.LIGHT_PURPLE);
            serverLevel.m_8767_((ParticleOptions)new AoEParticleOption(3.0f, 3.0f / (float)this.getDuration(), 0.0f, this.getDuration()), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
        }
        if (this.f_19797_ >= this.getDuration()) {
            Entity entity2;
            List list1 = this.f_19853_.m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), this::canHitEntity);
            for (Entity entity2 : list1) {
                LivingEntity livingEntity;
                if (!(entity2 instanceof LivingEntity) || !EntitySelector.f_20406_.test(livingEntity = (LivingEntity)entity2)) continue;
                boolean flag = false;
                float damage = 12.0f;
                DamageSource damageSource = this.m_269291_().m_269548_();
                if (this.getOwner() != null) {
                    if (!MobUtil.areAllies((Entity)this.getOwner(), (Entity)livingEntity)) {
                        flag = true;
                        damageSource = ModDamageSource.lightning(this, (Entity)this.getOwner());
                    }
                } else {
                    flag = true;
                }
                if (!flag || !livingEntity.m_6469_(damageSource, damage)) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 1, false, true));
            }
            this.m_216990_((SoundEvent)ModSounds.THUNDER_STRIKE_FAST.get());
            entity2 = this.f_19853_;
            if (entity2 instanceof ServerLevel) {
                MagicFire magicFire;
                int i;
                ServerLevel serverLevel = (ServerLevel)entity2;
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                ColorUtil colorUtil2 = new ColorUtil(ChatFormatting.LIGHT_PURPLE);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 3.0f, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 3.0f, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                ModNetwork.sendToALL(new SLightningBoltPacket(new Vec3(this.m_20185_(), this.m_20186_() + 250.0, this.m_20189_()), this.m_20182_(), colorUtil2, 10));
                for (i = 0; i < 8; ++i) {
                    Vec3 vector3d1 = this.m_20182_().m_82520_((double)(this.f_19853_.m_213780_().m_188501_() - 0.5f) * 6.0, 3.0, (double)(this.f_19853_.m_213780_().m_188501_() - 0.5f) * 6.0);
                    serverLevel.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil, vector3d1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
                }
                for (i = 0; i < 16; ++i) {
                    Vec3 vec3 = this.m_20182_().m_82520_(0.0, 1.0, 0.0);
                    int random1 = this.f_19853_.m_213780_().m_216332_(-4, 4);
                    int random2 = this.f_19853_.m_213780_().m_216332_(-4, 4);
                    Vec3 vec31 = vec3.m_82520_(this.f_19853_.m_213780_().m_188500_() * (double)random1, this.f_19853_.m_213780_().m_188500_(), this.f_19853_.m_213780_().m_188500_() * (double)random2);
                    ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, colorUtil2, 12));
                }
                if (this.f_19853_.m_213780_().m_188499_() && this.getOwner() != null && this.f_19853_.m_45772_((magicFire = new MagicFire(this.f_19853_, Vec3.m_82512_((Vec3i)this.m_20183_()), this.getOwner())).m_20191_().m_82406_(0.25)) && this.f_19853_.m_183134_((Entity)magicFire, magicFire.m_20191_().m_82406_(0.25)).isEmpty() && this.f_19853_.m_7967_((Entity)magicFire) && this.f_19853_.m_213780_().m_188501_() <= 0.25f) {
                    for (Direction direction : Direction.values()) {
                        MagicFire magicFire1;
                        if (!direction.m_122434_().m_122479_() || !this.f_19853_.m_45772_((magicFire1 = new MagicFire(this.f_19853_, Vec3.m_82512_((Vec3i)magicFire.m_20183_().m_121945_(direction)), this.getOwner())).m_20191_().m_82406_(0.25)) || !this.f_19853_.m_183134_((Entity)magicFire1, magicFire1.m_20191_().m_82406_(0.25)).isEmpty()) continue;
                        this.f_19853_.m_7967_((Entity)magicFire1);
                    }
                }
            }
            this.m_146870_();
        }
    }

    protected boolean canHitEntity(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return pEntity.m_6084_();
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (this.getOwner() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return pEntity.m_6084_();
    }
}

