/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.NecroBolt;
import com.Polarice3.Goety.common.entities.projectiles.SoulBolt;
import com.Polarice3.Goety.common.entities.projectiles.SpellHurtingProjectile;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoulBoltSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SoulBoltCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SoulBoltDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SoulBoltCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.CAST_SPELL.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster);
        }
        Vec3 vector3d = caster.m_20252_(1.0f);
        SpellHurtingProjectile soulBolt = new SoulBolt(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
        if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
            soulBolt = new NecroBolt(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
            SoundUtil.playNecroBolt(caster);
        } else {
            SoundUtil.playSoulBolt(caster);
        }
        if (soulBolt instanceof SoulBolt) {
            SoulBolt soulBolt1 = soulBolt;
            soulBolt1.setNecro(this.typeStaff(staff, SpellType.NECROMANCY));
        }
        soulBolt.setExtraDamage(potency);
        soulBolt.setBoltSpeed((int)velocity);
        soulBolt.m_5602_((Entity)caster);
        worldIn.m_7967_((Entity)soulBolt);
    }
}

