/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class PrismaBeamSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.PrismaBeamCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.PrismaBeamDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.PrismaBeamCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        return this.getTarget(caster) != null && super.conditionsMet(worldIn, caster);
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        LivingEntity target = this.getTarget(caster);
        if (target != null) {
            MiscCapHelper.setClientTarget(caster, (Entity)target);
            double d5 = (double)castTime / (double)this.castDuration(caster, staff);
            double d0 = target.m_20185_() - caster.m_20185_();
            double d1 = target.m_20227_(0.5) - caster.m_20188_();
            double d2 = target.m_20189_() - caster.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d0 /= d3;
            d1 /= d3;
            d2 /= d3;
            double d4 = worldIn.m_213780_().m_188500_();
            while (d4 < d3) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123795_, caster.m_20185_() + d0 * (d4 += 1.8 - d5 + worldIn.m_213780_().m_188500_() * (1.7 - d5)), caster.m_20188_() + d1 * d4, caster.m_20189_() + d2 * d4, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        super.stopSpell(worldIn, caster, staff, focus, castTime, spellStat);
        MiscCapHelper.setClientTarget(caster, null);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        LivingEntity target;
        float potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        if ((target = this.getTarget(caster)) != null) {
            float damage = ((Double)SpellConfig.PrismaBeamDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            float f = 1.0f;
            if (this.rightStaff(staff)) {
                f += 2.0f;
                damage += 2.0f;
            }
            target.m_6469_(caster.m_269291_().m_269104_((Entity)caster, (Entity)caster), f + potency);
            target.m_6469_(caster.m_269291_().m_269333_(caster), damage + potency);
        }
    }
}

