/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.CryptSlimeServant;
import com.Polarice3.Goety.common.entities.ally.MagmaCubeServant;
import com.Polarice3.Goety.common.entities.ally.SlimeServant;
import com.Polarice3.Goety.common.entities.ally.TropicalSlimeServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class SlimySpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SlimyCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SlimyDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SlimyCoolDown.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.SlimySummonDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof SlimeServant;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.SlimyLimit.get();
    }

    public boolean specialStaffs(ItemStack stack) {
        return this.typeStaff(stack, SpellType.NECROMANCY) || this.typeStaff(stack, SpellType.NETHER) || this.typeStaff(stack, SpellType.ABYSS);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 2 + caster.f_19853_.f_46441_.m_188503_(2);
            } else if (this.specialStaffs(staff)) {
                i = 2;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                SlimeServant slimeServant = new SlimeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.SLIME_SERVANT.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius(caster.m_20183_(), (Entity)slimeServant, (Level)worldIn);
                if (caster.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius(caster, (Level)worldIn);
                }
                if (this.specialStaffs(staff)) {
                    if (this.typeStaff(staff, SpellType.ABYSS)) {
                        slimeServant = new TropicalSlimeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.TROPICAL_SLIME_SERVANT.get()), (Level)worldIn);
                    } else if (this.typeStaff(staff, SpellType.NECROMANCY)) {
                        slimeServant = new CryptSlimeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.CRYPT_SLIME_SERVANT.get()), (Level)worldIn);
                    } else if (this.typeStaff(staff, SpellType.NETHER)) {
                        slimeServant = new MagmaCubeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.MAGMA_CUBE_SERVANT.get()), (Level)worldIn);
                    }
                } else if (worldIn.m_46801_(blockPos)) {
                    slimeServant = new TropicalSlimeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.TROPICAL_SLIME_SERVANT.get()), (Level)worldIn);
                } else if (worldIn.m_46472_() == Level.f_46429_) {
                    slimeServant = new MagmaCubeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.MAGMA_CUBE_SERVANT.get()), (Level)worldIn);
                } else if (BlockFinder.findStructure(worldIn, blockPos, ModTags.Structures.CRYPT)) {
                    slimeServant = new CryptSlimeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.CRYPT_SLIME_SERVANT.get()), (Level)worldIn);
                }
                slimeServant.setTrueOwner(caster);
                slimeServant.m_20035_(blockPos, 0.0f, 0.0f);
                if (slimeServant.m_6095_() != ModEntityType.TROPICAL_SLIME_SERVANT.get()) {
                    MobUtil.moveDownToGround((Entity)slimeServant);
                }
                slimeServant.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                slimeServant.m_21530_();
                slimeServant.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                slimeServant.setSize(2, true);
                this.buffSummon(caster, (LivingEntity)slimeServant, potency);
                this.SummonSap(caster, (LivingEntity)slimeServant);
                this.setTarget(caster, (Mob)slimeServant);
                worldIn.m_7967_((Entity)slimeServant);
                this.summonAdvancement(caster, (LivingEntity)slimeServant);
            }
            this.SummonDown(caster);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SUMMON_SPELL.get());
        }
    }
}

