/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.RazorWind;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class RazorWindSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.RazorWindCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.RazorWindDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.RazorWindCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float radius = (float)spellStat.getRadius();
        float damage = ((Double)SpellConfig.RazorWindDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (this.rightStaff(staff)) {
            radius += 0.5f;
        }
        if (WandUtil.enchantedFocus(caster)) {
            radius += (float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 4.0f;
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        RazorWind razorWind = new RazorWind((Level)worldIn, caster);
        razorWind.m_146884_(caster.m_146892_());
        razorWind.slash(caster.m_20154_(), 2.0);
        razorWind.setRadius(0.3f + radius);
        razorWind.setDamage(damage += (float)spellStat.getPotency());
        razorWind.setMaxLifeSpan(40);
        worldIn.m_7967_((Entity)razorWind);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.WIND.get(), 2.0f, 1.5f);
    }
}

