/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.ally.undead.bound.AbstractBoundIllager;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ArmorItem;

public class BoundIllagerModel<T extends AbstractBoundIllager>
extends HumanoidModel<T> {
    public ModelPart clothes;
    public ModelPart arms;
    public ModelPart all;
    protected final ModelPart nose;

    public BoundIllagerModel(ModelPart p_170677_) {
        super(p_170677_);
        this.all = p_170677_;
        this.f_102809_.f_104207_ = false;
        this.clothes = p_170677_.m_171324_("clothes");
        this.arms = p_170677_.m_171324_("arms");
        this.nose = this.f_102808_.m_171324_("nose");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", new CubeListBuilder().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.f_171404_);
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.05f)), PartPose.f_171404_);
        partdefinition.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.05f)), PartPose.f_171404_);
        partdefinition.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(44, 22).m_171480_().m_171506_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, true).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)BoundIllagerModel.createMesh(), (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.clothes));
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        float f = ageInTicks * 0.0025f;
        this.all.f_104201_ = Mth.m_14031_((float)(f * 40.0f)) + 24.0f;
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        float f4 = Math.min(limbSwingAmount / 0.3f, 1.0f);
        this.f_102810_.f_104203_ = f4 * MathHelper.modelDegrees(40.0f);
        this.f_102810_.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.1f + 0.1f;
        this.clothes.f_104203_ = this.f_102810_.f_104203_;
        this.arms.f_104202_ = -1.0f;
        this.arms.f_104203_ = -0.75f;
        if (this.f_102609_) {
            this.f_102811_.f_104203_ = -0.62831855f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = -0.62831855f;
            this.f_102812_.f_104204_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        } else {
            this.arms.f_104201_ = 3.0f;
            this.f_102811_.f_104201_ = 2.0f;
            this.f_102812_.f_104201_ = 2.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.f_102812_.f_104204_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.f_102813_.f_104204_ = 0.0f;
            this.f_102813_.f_104205_ = 0.0f;
            this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.f_102814_.f_104204_ = 0.0f;
            this.f_102814_.f_104205_ = 0.0f;
        }
        AbstractBoundIllager.BoundArmPose boundArmPose = ((AbstractBoundIllager)entityIn).getArmPose();
        if (boundArmPose == AbstractBoundIllager.BoundArmPose.ATTACKING) {
            if (entityIn.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (float)this.f_102608_, (float)ageInTicks);
            }
        } else if (boundArmPose == AbstractBoundIllager.BoundArmPose.SPELLCASTING) {
            this.f_102811_.f_104202_ = 0.0f;
            this.f_102811_.f_104200_ = -5.0f;
            this.f_102812_.f_104202_ = 0.0f;
            this.f_102812_.f_104200_ = 5.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.f_102811_.f_104205_ = 2.3561945f;
            this.f_102812_.f_104205_ = -2.3561945f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102812_.f_104204_ = 0.0f;
        } else if (boundArmPose == AbstractBoundIllager.BoundArmPose.BOW_AND_ARROW) {
            this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
            this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
            this.f_102812_.f_104203_ = -0.9424779f + this.f_102808_.f_104203_;
            this.f_102812_.f_104204_ = this.f_102808_.f_104204_ - 0.4f;
            this.f_102812_.f_104205_ = 1.5707964f;
        } else if (boundArmPose == AbstractBoundIllager.BoundArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)true);
        } else if (boundArmPose == AbstractBoundIllager.BoundArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (boolean)true);
        } else if (boundArmPose == AbstractBoundIllager.BoundArmPose.CELEBRATING) {
            this.f_102811_.f_104202_ = 0.0f;
            this.f_102811_.f_104200_ = -5.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.f_102811_.f_104205_ = 2.670354f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102812_.f_104202_ = 0.0f;
            this.f_102812_.f_104200_ = 5.0f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.f_102812_.f_104205_ = -2.3561945f;
            this.f_102812_.f_104204_ = 0.0f;
        } else if (boundArmPose == AbstractBoundIllager.BoundArmPose.CROSSED && this.arms.f_104207_) {
            this.f_102811_.f_104203_ = -0.75f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102812_.f_104203_ = -0.75f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102812_.f_104204_ = 0.0f;
        }
        this.arms.f_104207_ = flag = boundArmPose == AbstractBoundIllager.BoundArmPose.CROSSED;
        this.f_102812_.f_104207_ = !flag;
        this.f_102811_.f_104207_ = !flag;
        boolean flag2 = entityIn.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem || entityIn.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
        this.clothes.f_104207_ = !flag2;
    }

    public boolean isAggressive(T entityIn) {
        return entityIn.m_5912_();
    }

    protected ModelPart m_102851_(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.f_102812_ : this.f_102811_;
    }

    public ModelPart m_5585_() {
        return this.f_102808_;
    }

    public void m_6002_(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.m_102851_(p_102925_).m_104299_(p_102926_);
    }
}

