/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.blocks.entities.ArcaBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CursedCageBlockEntity
extends BlockEntity
implements Clearable {
    private ItemStack item = ItemStack.f_41583_;
    private int spinning;

    public CursedCageBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CURSED_CAGE.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag compound) {
        this.readNetwork(compound);
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack stack) {
        this.item = stack;
        this.m_6596_();
    }

    public Player getOwner() {
        if (this.item.m_41720_() == ModItems.SOUL_TRANSFER.get() && this.item.m_41783_() != null && this.item.m_41783_().m_128441_("owner")) {
            UUID owner = this.item.m_41783_().m_128342_("owner");
            return this.f_58857_.m_46003_(owner);
        }
        return null;
    }

    public int getSouls() {
        if (this.f_58857_ != null) {
            Player player = this.getOwner();
            if (player != null && SEHelper.getSEActive(player)) {
                return SEHelper.getSESouls(player);
            }
            if (this.item.m_41720_() instanceof ITotem && this.item.m_41783_() != null) {
                return this.item.m_41783_().m_128451_("Souls");
            }
        }
        return 0;
    }

    public void decreaseSouls(int souls) {
        int Soulcount;
        Player player;
        if (this.item.m_41720_() instanceof ITotem && this.item.m_41783_() != null) {
            int Soulcount2 = this.item.m_41783_().m_128451_("Souls");
            if (!this.item.m_41619_() && Soulcount2 > 0) {
                this.item.m_41783_().m_128405_("Souls", Soulcount2 -= souls);
                this.generateParticles();
            }
        }
        if (this.f_58857_ != null && (player = this.getOwner()) != null && SEHelper.getSEActive(player) && (Soulcount = SEHelper.getSESouls(player)) > 0) {
            SEHelper.decreaseSESouls(player, souls);
            SEHelper.sendSEUpdatePacket(player);
            ArcaBlockEntity arcaTile = (ArcaBlockEntity)this.f_58857_.m_7702_(SEHelper.getArcaBlock(player));
            if (arcaTile != null) {
                arcaTile.generateParticles();
                this.generateParticles();
            }
        }
        this.markUpdated();
    }

    public int getSpinning() {
        return this.spinning;
    }

    public void generateParticles() {
        if (this.getSouls() <= 0) {
            return;
        }
        BlockPos blockpos = this.m_58899_();
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                ServerLevel serverWorld = (ServerLevel)this.f_58857_;
                double d0 = (double)blockpos.m_123341_() + this.f_58857_.f_46441_.m_188500_();
                double d1 = (double)blockpos.m_123342_() + this.f_58857_.f_46441_.m_188500_();
                double d2 = (double)blockpos.m_123343_() + this.f_58857_.f_46441_.m_188500_();
                for (int p = 0; p < 4; ++p) {
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 5.0E-4, 0.0, 5.0E-4);
                }
            }
            this.spinning = 20;
        }
    }

    public void generateManyParticles() {
        BlockPos blockpos = this.m_58899_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            for (int k = 0; k < 20; ++k) {
                double d9 = (double)blockpos.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
                double d13 = (double)blockpos.m_123342_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
                double d19 = (double)blockpos.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d9, d13, d19, 1, 0.0, 0.0, 0.0, 0.0);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d9, d13, d19, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readNetwork(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }

    public void readNetwork(CompoundTag tag) {
        this.item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
    }

    public CompoundTag writeNetwork(CompoundTag tag) {
        tag.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        return tag;
    }

    public void m_6211_() {
        this.setItem(ItemStack.f_41583_);
    }

    public void tick() {
        if (this.spinning > 0) {
            --this.spinning;
        }
    }

    public void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

