/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class Snapper
extends AnimalSummon {
    public Snapper(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SnapperMoveControl((Mob)this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.4f, false));
        this.f_21345_.m_25352_(3, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new TryFindWaterGoal((PathfinderMob)this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(2, (Goal)new Summoned.FollowOwnerWaterGoal(this, 1.0, 10.0f, 2.0f));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(5, new Summoned.NaturalAttackGoal<AbstractFish>(this, AbstractFish.class, false));
        this.f_21346_.m_25352_(6, new Summoned.NaturalAttackGoal<Turtle>(this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, new Summoned.NaturalAttackGoal<AbstractSkeleton>(this, AbstractSkeleton.class, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.7).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SnapperHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.SnapperArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SnapperDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SnapperHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.SnapperArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SnapperDamage.get());
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6914_(LevelReader p_32829_) {
        return p_32829_.m_45784_((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.MOB_SUMMONED && this.getTrueOwner() != null) {
            ServerParticleUtil.addParticlesAroundMiddleSelf(pLevel.m_6018_(), (ParticleOptions)ParticleTypes.f_123755_, (Entity)this);
            ColorUtil color = new ColorUtil(0);
            ServerParticleUtil.windParticle(pLevel.m_6018_(), color, 1.0f, 0.0f, this.m_19879_(), this.m_20182_());
        }
        return pSpawnData;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12327_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    protected SoundEvent m_7975_(DamageSource p_29795_) {
        return SoundEvents.f_12330_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12329_;
    }

    protected void handleAirSupply(int p_30344_) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(p_30344_ - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    @Override
    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    @Override
    public void lifeSpanDamage() {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_146870_();
    }

    @Override
    public boolean isFood(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && p_30440_.getFoodProperties((LivingEntity)this).m_38746_();
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        FoodProperties foodProperties;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && this.isFood(itemstack) && this.m_21223_() < this.m_21233_() && (foodProperties = itemstack.getFoodProperties((LivingEntity)this)) != null) {
            this.m_5634_(foodProperties.m_38744_());
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            this.m_5584_(this.f_19853_, itemstack);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            pPlayer.m_6674_(pHand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        this.m_5496_(SoundEvents.f_11945_, 1.0f, 1.0f);
        return super.m_7327_(entityIn);
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        super.setUpgraded(upgraded);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (health != null && armor != null && attack != null) {
            if (upgraded) {
                health.m_22100_((Double)AttributesConfig.SnapperHealth.get() * 1.5);
                armor.m_22100_((Double)AttributesConfig.SnapperArmor.get() + 1.0);
                attack.m_22100_((Double)AttributesConfig.SnapperDamage.get() + 1.0);
            } else {
                health.m_22100_(((Double)AttributesConfig.SnapperHealth.get()).doubleValue());
                armor.m_22100_(((Double)AttributesConfig.SnapperArmor.get()).doubleValue());
                attack.m_22100_(((Double)AttributesConfig.SnapperDamage.get()).doubleValue());
            }
        }
        this.m_21153_(this.m_21233_());
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_()) {
            double d0 = this.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean flag = this.m_20184_().f_82480_ <= 0.0;
            FluidState fluidstate = this.m_9236_().m_6425_(this.m_20183_());
            if ((this.m_20069_() || this.isInFluidType(fluidstate) && fluidstate.getFluidType() != ForgeMod.LAVA_TYPE.get()) && this.m_6129_() && !this.m_203441_(fluidstate)) {
                if (this.m_20069_() || this.isInFluidType(fluidstate) && !this.moveInFluid(fluidstate, vec3, d0)) {
                    double d9 = this.m_20186_();
                    float f4 = 0.96f;
                    float f5 = 0.02f;
                    float f6 = EnchantmentHelper.m_44922_((LivingEntity)this);
                    if (f6 > 3.0f) {
                        f6 = 3.0f;
                    }
                    if (!this.m_20096_()) {
                        f6 *= 0.5f;
                    }
                    if (f6 > 0.0f) {
                        f5 += (this.m_6113_() - f5) * f6 / 3.0f;
                    }
                    this.m_19920_(f5 *= (float)this.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()), vec3);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    Vec3 vec36 = this.m_20184_();
                    if (this.f_19862_ && this.m_6147_()) {
                        vec36 = new Vec3(vec36.f_82479_, 0.2, vec36.f_82481_);
                    }
                    this.m_20256_(vec36.m_82542_((double)f4, (double)0.8f, (double)f4));
                    Vec3 vec32 = this.m_20994_(d0, flag, this.m_20184_());
                    this.m_20256_(vec32);
                    if (this.f_19862_ && this.m_20229_(vec32.f_82479_, vec32.f_82480_ + (double)0.6f - this.m_20186_() + d9, vec32.f_82481_)) {
                        this.m_20334_(vec32.f_82479_, 0.3f, vec32.f_82481_);
                    }
                } else {
                    super.m_7023_(vec3);
                }
            } else {
                super.m_7023_(vec3);
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    public static class SnapperMoveControl
    extends MoveControl {
        public SnapperMoveControl(Mob p_24983_) {
            super(p_24983_);
        }

        public void m_8126_() {
            if (this.f_24974_.m_20069_()) {
                this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                double dx = this.f_24975_ - this.f_24974_.m_20185_();
                double dy = this.f_24976_ - this.f_24974_.m_20186_();
                double dz = this.f_24977_ - this.f_24974_.m_20189_();
                float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 10.0f));
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                if (this.f_24974_.m_20069_()) {
                    this.f_24974_.m_7910_((float)this.f_24974_.m_21133_(Attributes.f_22279_));
                    float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                    f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, 5.0f));
                    float f3 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    this.f_24974_.m_21564_(f3 * f1);
                    this.f_24974_.m_21567_((float)((double)f1 * dy));
                } else {
                    this.f_24974_.m_7910_(f1 * 0.05f);
                }
            } else {
                this.f_24974_.m_7910_(0.0f);
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }
}

