/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.api.entities.ICharger;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.ChargeGoal;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class TwilightGoat
extends AnimalSummon
implements ICharger {
    public static final EntityDimensions LONG_JUMPING_DIMENSIONS = EntityDimensions.m_20395_((float)0.9f, (float)1.3f).m_20388_(0.7f);
    private static final EntityDataAccessor<Boolean> DATA_IS_SCREAMING_GOAT = SynchedEntityData.m_135353_(TwilightGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_LEFT_HORN = SynchedEntityData.m_135353_(TwilightGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_RIGHT_HORN = SynchedEntityData.m_135353_(TwilightGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING = SynchedEntityData.m_135353_(TwilightGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.m_146622_((int)600, (int)1200);
    private boolean isLoweringHead;
    private int lowerHeadTick;
    private int longJumpCool;

    public TwilightGoat(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalSummon.BreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new GoatChargeGoal((PathfinderMob)this, p_287490_ -> p_287490_.m_6162_() ? 1.0 : 2.5, p_149468_ -> {
            TwilightGoat goat;
            return p_149468_ instanceof TwilightGoat && (goat = (TwilightGoat)p_149468_).isScreamingGoat() ? SoundEvents.f_144150_ : SoundEvents.f_144170_;
        }, p_218772_ -> {
            TwilightGoat goat;
            return p_218772_ instanceof TwilightGoat && (goat = (TwilightGoat)p_218772_).isScreamingGoat() ? SoundEvents.f_215700_ : SoundEvents.f_215698_;
        }));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<TwilightGoat>(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.TwilightGoatHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.TwilightGoatArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.TwilightGoatDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.TwilightGoatHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.TwilightGoatArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.TwilightGoatDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_SCREAMING_GOAT, (Object)false);
        this.f_19804_.m_135372_(DATA_HAS_LEFT_HORN, (Object)true);
        this.f_19804_.m_135372_(DATA_HAS_RIGHT_HORN, (Object)true);
        this.f_19804_.m_135372_(DATA_CHARGING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_149385_) {
        super.m_7380_(p_149385_);
        p_149385_.m_128379_("IsScreamingGoat", this.isScreamingGoat());
        p_149385_.m_128379_("HasLeftHorn", this.hasLeftHorn());
        p_149385_.m_128379_("HasRightHorn", this.hasRightHorn());
    }

    @Override
    public void m_7378_(CompoundTag p_149373_) {
        super.m_7378_(p_149373_);
        this.setScreamingGoat(p_149373_.m_128471_("IsScreamingGoat"));
        this.f_19804_.m_135381_(DATA_HAS_LEFT_HORN, (Object)p_149373_.m_128471_("HasLeftHorn"));
        this.f_19804_.m_135381_(DATA_HAS_RIGHT_HORN, (Object)p_149373_.m_128471_("HasRightHorn"));
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    public boolean hasLeftHorn() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_LEFT_HORN);
    }

    public boolean hasRightHorn() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_RIGHT_HORN);
    }

    public void addHorns() {
        this.f_19804_.m_135381_(DATA_HAS_LEFT_HORN, (Object)true);
        this.f_19804_.m_135381_(DATA_HAS_RIGHT_HORN, (Object)true);
    }

    public void removeHorns() {
        this.f_19804_.m_135381_(DATA_HAS_LEFT_HORN, (Object)false);
        this.f_19804_.m_135381_(DATA_HAS_RIGHT_HORN, (Object)false);
    }

    public boolean isScreamingGoat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SCREAMING_GOAT);
    }

    public void setScreamingGoat(boolean p_149406_) {
        this.f_19804_.m_135381_(DATA_IS_SCREAMING_GOAT, (Object)p_149406_);
    }

    public float getRammingXHeadRot() {
        return (float)this.lowerHeadTick / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    @Override
    protected void ageBoundaryReached() {
        AttributeInstance instance = this.m_21051_(Attributes.f_22281_);
        if (instance != null) {
            if (this.m_6162_()) {
                instance.m_22100_((Double)AttributesConfig.TwilightGoatDamage.get() / 2.0);
                this.removeHorns();
            } else {
                instance.m_22100_(((Double)AttributesConfig.TwilightGoatDamage.get()).doubleValue());
                this.addHorns();
            }
        }
    }

    protected int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 10;
    }

    protected SoundEvent m_7515_() {
        return this.isScreamingGoat() ? SoundEvents.f_144171_ : SoundEvents.f_144163_;
    }

    protected SoundEvent m_7975_(DamageSource p_149387_) {
        return this.isScreamingGoat() ? SoundEvents.f_144146_ : SoundEvents.f_144166_;
    }

    protected SoundEvent m_5592_() {
        return this.isScreamingGoat() ? SoundEvents.f_144172_ : SoundEvents.f_144164_;
    }

    protected void m_7355_(BlockPos p_149382_, BlockState p_149383_) {
        this.m_5496_(SoundEvents.f_144151_, 0.15f, 1.0f);
    }

    protected SoundEvent getMilkingSound() {
        return this.isScreamingGoat() ? SoundEvents.f_144148_ : SoundEvents.f_144168_;
    }

    public int m_8085_() {
        return 15;
    }

    public void m_5616_(float p_149400_) {
        int i = this.m_8085_();
        float f = Mth.m_14118_((float)this.f_20883_, (float)p_149400_);
        float f1 = Mth.m_14036_((float)f, (float)(-i), (float)i);
        super.m_5616_(this.f_20883_ + f1);
    }

    public SoundEvent m_7866_(ItemStack p_149394_) {
        return this.isScreamingGoat() ? SoundEvents.f_144173_ : SoundEvents.f_144165_;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_149365_, DifficultyInstance p_149366_, MobSpawnType p_149367_, @Nullable SpawnGroupData p_149368_, @Nullable CompoundTag p_149369_) {
        RandomSource randomsource = p_149365_.m_213780_();
        this.setScreamingGoat(randomsource.m_188500_() < 0.02);
        this.ageBoundaryReached();
        if (!this.m_6162_() && (double)randomsource.m_188501_() < (double)0.1f) {
            EntityDataAccessor<Boolean> entitydataaccessor = randomsource.m_188499_() ? DATA_HAS_LEFT_HORN : DATA_HAS_RIGHT_HORN;
            this.f_19804_.m_135381_(entitydataaccessor, (Object)false);
        }
        return super.m_6518_(p_149365_, p_149366_, p_149367_, p_149368_, p_149369_);
    }

    public float m_6134_() {
        return this.isUpgraded() ? 1.25f : super.m_6134_();
    }

    public EntityDimensions m_6972_(Pose p_149361_) {
        return p_149361_ == Pose.LONG_JUMPING ? LONG_JUMPING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(p_149361_);
    }

    @Override
    public void m_7822_(byte p_149356_) {
        if (p_149356_ == 58) {
            this.isLoweringHead = true;
        } else if (p_149356_ == 59) {
            this.isLoweringHead = false;
        } else {
            super.m_7822_(p_149356_);
        }
    }

    @Override
    public void m_8107_() {
        this.lowerHeadTick = this.isLoweringHead ? ++this.lowerHeadTick : (this.lowerHeadTick -= 2);
        this.lowerHeadTick = Mth.m_14045_((int)this.lowerHeadTick, (int)0, (int)20);
        super.m_8107_();
        if (this.longJumpCool > 0) {
            --this.longJumpCool;
        }
    }

    public boolean dropHorn() {
        boolean flag = this.hasLeftHorn();
        boolean flag1 = this.hasRightHorn();
        if (!flag && !flag1) {
            return false;
        }
        EntityDataAccessor<Boolean> entitydataaccessor = !flag ? DATA_HAS_RIGHT_HORN : (!flag1 ? DATA_HAS_LEFT_HORN : (this.f_19796_.m_188499_() ? DATA_HAS_LEFT_HORN : DATA_HAS_RIGHT_HORN));
        this.f_19804_.m_135381_(entitydataaccessor, (Object)false);
        return true;
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING);
    }

    @Override
    public void setCharging(boolean flag) {
        this.f_19804_.m_135381_(DATA_CHARGING, (Object)flag);
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        super.setUpgraded(upgraded);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (health != null && armor != null && attack != null) {
            if (upgraded) {
                health.m_22100_((Double)AttributesConfig.TwilightGoatHealth.get() * 1.5);
                armor.m_22100_((Double)AttributesConfig.TwilightGoatArmor.get() + 1.0);
                attack.m_22100_((Double)AttributesConfig.TwilightGoatDamage.get() + 1.0);
            } else {
                health.m_22100_(((Double)AttributesConfig.TwilightGoatHealth.get()).doubleValue());
                armor.m_22100_(((Double)AttributesConfig.TwilightGoatArmor.get()).doubleValue());
                attack.m_22100_(((Double)AttributesConfig.TwilightGoatDamage.get()).doubleValue());
            }
        }
        this.m_21153_(this.m_21233_());
        this.m_6210_();
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (itemstack.m_41614_() && itemstack.getFoodProperties((LivingEntity)this) != null && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                this.m_5584_(this.f_19853_, itemstack);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(pHand);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_150930_(Items.f_42446_) && !this.m_6162_() && !this.limitedLifespan && this.limitedLifeTicks <= 0) {
                pPlayer.m_5496_(this.getMilkingSound(), 1.0f, 1.0f);
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)Items.f_42455_.m_7968_());
                pPlayer.m_21008_(pHand, itemstack1);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public static class GoatChargeGoal
    extends ChargeGoal {
        private Vec3 ramDirection;
        private final ToDoubleFunction<PathfinderMob> getKnockbackForce;
        private final Function<PathfinderMob, SoundEvent> getImpactSound;
        private final Function<PathfinderMob, SoundEvent> getHornBreakSound;
        private static final TargetingConditions RAM_TARGET_CONDITIONS = TargetingConditions.m_148352_().m_26888_(p_289449_ -> p_289449_.f_19853_.m_6857_().m_61935_(p_289449_.m_20191_()));
        private static final UniformInt TIME_BETWEEN_RAMS = UniformInt.m_146622_((int)100, (int)300);

        public GoatChargeGoal(PathfinderMob mob, ToDoubleFunction<PathfinderMob> p_217345_, Function<PathfinderMob, SoundEvent> p_217346_, Function<PathfinderMob, SoundEvent> p_217347_) {
            super(mob, 3.0f, 4.0, 7.0, 1, TIME_BETWEEN_RAMS.m_214085_(mob.m_217043_()));
            this.getKnockbackForce = p_217345_;
            this.getImpactSound = p_217346_;
            this.getHornBreakSound = p_217347_;
        }

        public boolean m_183429_() {
            return true;
        }

        @Override
        public boolean m_8045_() {
            return this.windup > -20 || !this.charger.m_21573_().m_26571_();
        }

        @Override
        public void m_8056_() {
            this.windup = MathHelper.secondsToTicks(1) + this.charger.m_217043_().m_188503_(MathHelper.secondsToTicks(1));
            this.charger.f_19853_.m_7605_((Entity)this.charger, (byte)58);
            BlockPos blockpos = this.charger.m_20183_();
            if (this.chargePos != null) {
                this.ramDirection = new Vec3((double)blockpos.m_123341_() - this.chargePos.m_7096_(), 0.0, (double)blockpos.m_123343_() - this.chargePos.m_7094_()).m_82541_();
            }
        }

        @Override
        public void m_8037_() {
            this.charger.m_21563_().m_24950_(this.chargePos.m_7096_(), this.chargePos.m_7098_() - 1.0, this.chargePos.m_7094_(), 10.0f, (float)this.charger.m_8132_());
            --this.windup;
            if (this.windup == 0) {
                PathNavigation pathnavigation = this.charger.m_21573_();
                Path path = pathnavigation.m_7864_(BlockPos.m_274446_((Position)this.chargePos), 0);
                if (path != null && path.m_77403_()) {
                    pathnavigation.m_26536_(path, (double)this.speed);
                } else {
                    pathnavigation.m_26519_(this.chargePos.m_7096_(), this.chargePos.m_7098_(), this.chargePos.m_7094_(), (double)this.speed);
                }
            }
            if (this.windup <= 0) {
                List list = this.charger.f_19853_.m_45971_(LivingEntity.class, RAM_TARGET_CONDITIONS, (LivingEntity)this.charger, this.charger.m_20191_());
                list.removeIf(livingEntity -> MobUtil.areAllies((Entity)this.charger, (Entity)livingEntity));
                if (!list.isEmpty()) {
                    float f2;
                    IOwned owned;
                    LivingEntity livingentity = (LivingEntity)list.get(0);
                    PathfinderMob pathfinderMob = this.charger;
                    DamageSource damageSource = pathfinderMob instanceof IOwned && (owned = (IOwned)pathfinderMob).getTrueOwner() != null ? ModDamageSource.summonAttack((LivingEntity)this.charger, owned.getTrueOwner()) : this.charger.m_269291_().m_269333_((LivingEntity)this.charger);
                    livingentity.m_6469_(damageSource, (float)this.charger.m_21133_(Attributes.f_22281_));
                    int i = this.charger.m_21023_(MobEffects.f_19596_) ? this.charger.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
                    int j = this.charger.m_21023_(MobEffects.f_19597_) ? this.charger.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
                    float f = 0.25f * (float)(i - j);
                    float f1 = Mth.m_14036_((float)(this.charger.m_6113_() * 1.65f), (float)0.2f, (float)3.0f) + f;
                    float f3 = f2 = livingentity.m_21275_(damageSource) ? 0.5f : 1.0f;
                    if (this.ramDirection != null) {
                        livingentity.m_147240_((double)(f2 * f1) * this.getKnockbackForce.applyAsDouble(this.charger), this.ramDirection.m_7096_(), this.ramDirection.m_7094_());
                    }
                    this.m_8041_();
                    this.charger.f_19853_.m_6269_((Player)null, (Entity)this.charger, this.getImpactSound.apply(this.charger), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else if (this.hasRammedHornBreakingBlock()) {
                    TwilightGoat goat;
                    boolean flag;
                    this.charger.f_19853_.m_6269_((Player)null, (Entity)this.charger, this.getImpactSound.apply(this.charger), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    PathfinderMob pathfinderMob = this.charger;
                    boolean bl = flag = pathfinderMob instanceof TwilightGoat && (goat = (TwilightGoat)pathfinderMob).dropHorn();
                    if (flag) {
                        this.charger.f_19853_.m_6269_((Player)null, (Entity)this.charger, this.getHornBreakSound.apply(this.charger), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    this.m_8041_();
                } else {
                    boolean flag1;
                    boolean bl = flag1 = this.chargePos == null || this.chargePos.m_82509_((Position)this.charger.m_20182_(), 0.25);
                    if (flag1) {
                        this.m_8041_();
                    }
                }
            } else {
                PathfinderMob pathfinderMob = this.charger;
                if (pathfinderMob instanceof ICharger) {
                    ICharger chargeMob = (ICharger)pathfinderMob;
                    chargeMob.setCharging(true);
                }
            }
        }

        private boolean hasRammedHornBreakingBlock() {
            Vec3 vec3 = this.charger.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
            BlockPos blockpos = BlockPos.m_274446_((Position)this.charger.m_20182_().m_82549_(vec3));
            return this.charger.f_19853_.m_8055_(blockpos).m_204336_(BlockTags.f_215832_) || this.charger.f_19853_.m_8055_(blockpos.m_7494_()).m_204336_(BlockTags.f_215832_);
        }

        @Override
        public void m_8041_() {
            this.charger.f_19853_.m_7605_((Entity)this.charger, (byte)59);
            this.charger.m_21573_().m_26573_();
            this.windup = 0;
            this.chargeTarget = null;
            this.coolDown = this.charger.f_19797_ + this.coolDownTotal;
            PathfinderMob pathfinderMob = this.charger;
            if (pathfinderMob instanceof ICharger) {
                ICharger chargeMob = (ICharger)pathfinderMob;
                chargeMob.setCharging(false);
            }
        }
    }
}

