/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieVindicatorServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class VindicatorServant
extends AbstractIllagerServant {
    private static final String TAG_JOHNNY = "Johnny";
    static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34082_ -> p_34082_ == Difficulty.NORMAL || p_34082_ == Difficulty.HARD;
    boolean isJohnny;

    public VindicatorServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new VindicatorBreakDoorGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new VindicatorMeleeAttackGoal(this));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(4, (Goal)new VindicatorJohnnyAttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.VindicatorServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.VindicatorServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.VindicatorServantDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.VindicatorServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.VindicatorServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.VindicatorServantDamage.get());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(TAG_JOHNNY, 99)) {
            this.isJohnny = compound.m_128471_(TAG_JOHNNY);
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.isJohnny) {
            compound.m_128379_(TAG_JOHNNY, true);
        }
    }

    @Override
    public boolean canOpenDoors() {
        return true;
    }

    @Override
    public AbstractIllagerServant.IllagerServantArmPose getArmPose() {
        if (this.m_5912_()) {
            return AbstractIllagerServant.IllagerServantArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllagerServant.IllagerServantArmPose.CELEBRATING : AbstractIllagerServant.IllagerServantArmPose.CROSSED;
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_12577_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        this.m_213946_(randomsource, p_34089_);
        return spawngroupdata;
    }

    @Override
    protected void m_213945_(RandomSource p_219149_, DifficultyInstance p_219150_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public void m_6593_(@Nullable Component p_34096_) {
        super.m_6593_(p_34096_);
        if (!this.isJohnny && p_34096_ != null && p_34096_.getString().equals(TAG_JOHNNY)) {
            this.isJohnny = true;
        }
    }

    @Override
    @Nullable
    public LivingEntity getTrueOwner() {
        if (this.isJohnny) {
            return null;
        }
        return super.getTrueOwner();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_34103_) {
        return SoundEvents.f_12579_;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        ZombieVindicatorServant servant;
        if (!this.f_19853_.f_46443_ && this.getIdol() == null && this.getTrueOwner() != null && CuriosFinder.hasNamelessSet(this.getTrueOwner()) && (servant = (ZombieVindicatorServant)this.m_21406_((EntityType)ModEntityType.ZOMBIE_VINDICATOR_SERVANT.get(), true)) != null) {
            servant.setTrueOwner(this.getTrueOwner());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)servant);
            if (!this.m_20067_()) {
                this.f_19853_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && !(pPlayer.m_21206_().m_41720_() instanceof IWand) && (item instanceof AxeItem || itemstack.m_204117_(ItemTags.f_271207_) || itemstack.m_204117_(ModTags.Items.VINDICATOR_WEAPONS))) {
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
            this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
            this.m_21508_(EquipmentSlot.MAINHAND);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class VindicatorBreakDoorGoal
    extends BreakDoorGoal {
        public VindicatorBreakDoorGoal(Mob p_34112_) {
            super(p_34112_, 6, DOOR_BREAKING_PREDICATE);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            VindicatorServant vindicator = (VindicatorServant)this.f_25189_;
            return vindicator.isRaiding() && super.m_8045_();
        }

        public boolean m_8036_() {
            VindicatorServant vindicator = (VindicatorServant)this.f_25189_;
            return vindicator.isRaiding() && vindicator.f_19796_.m_188503_(VindicatorBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }
    }

    static class VindicatorMeleeAttackGoal
    extends ModMeleeAttackGoal {
        public VindicatorMeleeAttackGoal(VindicatorServant p_34123_) {
            super(p_34123_, 1.0, false);
        }
    }

    static class VindicatorJohnnyAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public VindicatorJohnnyAttackGoal(VindicatorServant p_34117_) {
            super((Mob)p_34117_, LivingEntity.class, 0, true, true, LivingEntity::m_5789_);
        }

        public boolean m_8036_() {
            return ((VindicatorServant)this.f_26135_).isJohnny && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_26135_.m_21310_(0);
        }
    }
}

