/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic;

import com.Polarice3.Goety.common.entities.util.ModFallingBlock;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Tremor
extends BlockPos {
    private final boolean first;
    private final boolean playEffects;

    public Tremor(int x, int y, int z, boolean first, boolean playEffects, Level level, LivingEntity livingEntity, int extraDamage) {
        super(x, y, z);
        this.first = first;
        this.playEffects = playEffects;
        this.affectBlocks(level, livingEntity, extraDamage);
    }

    public Tremor(int x, int y, int z, boolean first, Level level, LivingEntity livingEntity, int extraDamage) {
        this(x, y, z, first, true, level, livingEntity, extraDamage);
    }

    public boolean isFirst() {
        return this.first;
    }

    public static void createTremors(Level level, LivingEntity livingEntity, List<Tremor> tremors, int extraDamage, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        int firstY = Tremor.getSuitableGround(level, x1, y, z1, 3);
        Tremor wave = new Tremor(x1, y, z1, true, level, livingEntity, extraDamage);
        if (firstY != -1) {
            wave = new Tremor(x1, firstY, z1, true, level, livingEntity, extraDamage);
        }
        tremors.add(wave);
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                Tremor.addTremor(level, livingEntity, tremors, x, y, z, extraDamage);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                Tremor.addTremor(level, livingEntity, tremors, x, y, z, extraDamage);
            }
        }
    }

    public static void quake(Level level, LivingEntity source, List<Tremor> tremors, int extraDamage, int y) {
        int maxDistance = 8;
        float f5 = (float)Math.PI * (float)maxDistance * (float)maxDistance;
        int k1 = 0;
        while ((float)k1 < f5) {
            float f6 = level.f_46441_.m_188501_() * ((float)Math.PI * 2);
            float f7 = Mth.m_14116_((float)level.f_46441_.m_188501_()) * (float)maxDistance;
            float f8 = Mth.m_14089_((float)f6) * f7;
            float f9 = Mth.m_14031_((float)f6) * f7;
            Tremor.addTremor(level, source, false, tremors, (int)(source.m_20185_() + (double)f8), y, (int)(source.m_20189_() + (double)f9), extraDamage);
            ++k1;
        }
    }

    public static void addTremor(Level level, LivingEntity livingEntity, boolean playEffects, List<Tremor> list, int extraDamage, int x, int y, int z) {
        if ((y = Tremor.getSuitableGround(level, x, y, z, 3)) != -1) {
            list.add(new Tremor(x, y, z, false, playEffects, level, livingEntity, extraDamage));
        }
        if (level.f_46441_.m_188503_(2) == 0) {
            list.add(new Tremor(x, y + 1, z, false, playEffects, level, livingEntity, extraDamage));
        }
    }

    public static void addTremor(Level level, LivingEntity livingEntity, List<Tremor> list, int x, int y, int z, int extraDamage) {
        Tremor.addTremor(level, livingEntity, true, list, x, y, z, extraDamage);
    }

    public void affectBlocks(Level level, LivingEntity source, int extraDamage) {
        Player playerEntity;
        BlockPos posAbove = this.m_7494_();
        BlockState blockstate = level.m_8055_((BlockPos)this);
        Block block = blockstate.m_60734_();
        Player player = playerEntity = source instanceof Player ? (Player)source : null;
        if (block instanceof DoorBlock) {
            if (DoorBlock.m_52817_((BlockState)blockstate)) {
                level.m_46796_(1019, (BlockPos)this, 0);
            } else {
                level.m_46796_(1020, (BlockPos)this, 0);
            }
        }
        if (block instanceof BellBlock) {
            ((BellBlock)block).m_49701_(level, blockstate, new BlockHitResult(Vec3.m_82528_((Vec3i)this), source.m_6350_(), (BlockPos)this, false), playerEntity, true);
        }
        if (blockstate.m_60713_(Blocks.f_50173_)) {
            block.m_141947_(level, (BlockPos)this, blockstate, (Entity)source);
        }
        if (blockstate.m_60819_().m_76178_()) {
            if (this.playEffects) {
                level.m_46796_(2001, posAbove, Block.m_49956_((BlockState)blockstate));
            }
            ModFallingBlock fallingBlock = new ModFallingBlock(level, blockstate, 0.3f);
            fallingBlock.m_6034_((double)this.m_123341_() + 0.5, (double)this.m_123342_() + 1.0, (double)this.m_123343_() + 0.5);
            level.m_7967_((Entity)fallingBlock);
        }
        AABB box = new AABB((double)this.m_123341_(), (double)this.m_123342_() + 1.0, (double)this.m_123343_(), (double)this.m_123341_() + 1.0, (double)this.m_123342_() + 2.0, (double)this.m_123343_() + 1.0);
        for (LivingEntity livingEntity : source.f_19853_.m_45976_(LivingEntity.class, box)) {
            if (livingEntity == source || source.m_20202_() == livingEntity) continue;
            float damage = 4.0f;
            if (this.isFirst()) {
                damage = 6.0f;
            }
            if (!livingEntity.m_6469_(source.m_269291_().m_269333_(source), damage += (float)extraDamage)) continue;
            MobUtil.knockBack((Entity)livingEntity, (Entity)source, 0.5, 0.2, 0.5);
        }
    }

    public static int getSuitableGround(Level world, int x, int y, int z, int range) {
        int i = y;
        while (true) {
            if (Math.abs(y - i) > range) {
                return -1;
            }
            BlockPos startPos = new BlockPos(x, i, z);
            BlockPos posUp = startPos.m_7494_();
            BlockState blockState = world.m_8055_(startPos);
            if (blockState.m_204336_(BlockTags.f_13076_)) {
                return -1;
            }
            if (world.m_6425_(startPos).m_205070_(FluidTags.f_13132_) && !world.m_6425_(startPos).m_76178_()) break;
            if (world.m_46859_(startPos)) {
                --i;
                continue;
            }
            if (!world.m_46859_(startPos) && world.m_46859_(posUp) && blockState.m_60812_((BlockGetter)world, startPos).m_83281_()) {
                --i;
                break;
            }
            if (world.m_46859_(startPos) || world.m_46859_(posUp) || world.m_8055_(posUp).m_60812_((BlockGetter)world, posUp).m_83281_()) break;
            ++i;
        }
        return i;
    }
}

