/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.neutral.InsectSwarm;
import com.Polarice3.Goety.common.magic.BreathingSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SwarmSpell
extends BreathingSpell {
    public float damage = ((Double)SpellConfig.SwarmDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();

    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(1).setRange(8);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SwarmCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.SwarmChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.SwarmDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SwarmCoolDown.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        float damage = this.damage + (float)potency;
        if (!worldIn.f_46443_) {
            for (Entity target : this.getBreathTarget(caster, range)) {
                if (target == null || !target.m_6469_(ModDamageSource.swarm((Entity)caster, (Entity)caster), damage)) continue;
                if (this.rightStaff(staff) && target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    MobEffect mobEffect = MobEffects.f_19614_;
                    if (CuriosFinder.hasWildRobe(caster)) {
                        mobEffect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                    }
                    livingTarget.m_7292_(new MobEffectInstance(mobEffect, MathHelper.secondsToTicks(5) * duration));
                }
                if (target.m_6084_()) continue;
                InsectSwarm insectSwarm = new InsectSwarm((Level)worldIn, caster, target.m_20182_());
                insectSwarm.setLimitedLife(200 * duration);
                if (potency > 0) {
                    insectSwarm.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), potency - 1, false, false));
                }
                worldIn.m_7967_((Entity)insectSwarm);
            }
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.INSECT_SWARM.get(), worldIn.f_46441_.m_188501_() * 0.5f, worldIn.f_46441_.m_188501_() * 0.5f);
    }

    @Override
    public void showWandBreath(LivingEntity entityLiving, SpellStat spellStat) {
        Player player;
        int range = 0;
        if (entityLiving instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)entityLiving))) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
        }
        this.breathAttack((ParticleOptions)ModParticleTypes.FLY.get(), entityLiving, true, (double)0.3f + (double)range / 10.0, 5.0);
    }
}

