/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class WhirlwindSpell
extends EverChargeSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.WhirlwindCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.WhirlwindChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.WhirlwindDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.WhirlwindCoolDown.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WIND.get();
    }

    @Override
    public SoundEvent loopSound(LivingEntity caster) {
        return (SoundEvent)ModSounds.WHIRLWIND.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int fireTicks;
        Vec3 vec3 = caster.m_20184_();
        double y = 0.04;
        float radius = (float)spellStat.getRadius();
        if (this.rightStaff(staff)) {
            radius += 1.0f;
        }
        if (WandUtil.enchantedFocus(caster)) {
            y += (double)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 100.0;
            radius += (float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        if (vec3.f_82480_ < 0.0) {
            y = 0.2;
        }
        if ((fireTicks = caster.m_20094_()) > 0) {
            int amount = this.rightStaff(staff) ? 4 : 1;
            caster.m_7311_(Math.max(fireTicks - amount, 0));
        }
        MobUtil.forcePush((Entity)caster, 0.0, y, 0.0);
        for (Entity entity : worldIn.m_45976_(Entity.class, caster.m_20191_().m_82400_((double)radius))) {
            AbstractArrow arrow;
            AbstractArrow arrow2;
            boolean flag;
            if (entity == caster || caster.m_20202_() != null && caster.m_20202_() == entity || !(flag = entity instanceof LivingEntity || entity instanceof AbstractArrow && ((arrow2 = (AbstractArrow)entity).m_19749_() == null || !arrow2.m_19749_().m_6095_().m_204039_(Tags.EntityTypes.BOSSES)))) continue;
            Vec3 vec31 = new Vec3(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
            Vec3 vec32 = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            double distance = vec31.m_82554_(vec32) + 0.1;
            Vec3 vec33 = new Vec3(vec32.f_82479_ - vec31.f_82479_, vec32.f_82480_ - vec31.f_82480_, vec32.f_82481_ - vec31.f_82481_);
            MobUtil.push(entity, vec33.f_82479_ / (double)radius / distance, vec33.f_82480_ / (double)radius / distance, vec33.f_82481_ / (double)radius / distance);
            if (!this.rightStaff(staff) || !(entity instanceof AbstractArrow) || (arrow = (AbstractArrow)entity).m_20096_()) continue;
            double d0 = arrow.m_20185_() - caster.m_20185_();
            double d1 = arrow.m_20186_() - caster.m_20186_();
            double d2 = arrow.m_20189_() - caster.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.0f, 10.0f);
        }
        ColorUtil color = new ColorUtil(0xFFFFFF);
        ServerParticleUtil.windParticle(worldIn, color, radius - 1.0f, -0.5f, caster.m_19879_(), caster.m_20182_());
        ServerParticleUtil.windParticle(worldIn, color, radius - 1.0f, 1.0f, caster.m_19879_(), caster.m_20182_());
        ServerParticleUtil.windParticle(worldIn, color, radius, 0.5f, caster.m_19879_(), caster.m_20182_());
    }
}

