/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.blocks.entities;

import com.Polarice3.Goety.api.entities.ITrainable;
import com.Polarice3.Goety.utils.BlockFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface IBarrack {
    @Nullable
    public EntityType<? extends Mob> getTrainedMob(Level var1, BlockPos var2);

    default public String getCurrentMob() {
        return "None";
    }

    default public int getRange() {
        return 8;
    }

    default public int trainLimit() {
        return 8;
    }

    default public Predicate<Mob> trainingRequirements(Level level, BlockPos blockPos) {
        return mob -> false;
    }

    default public List<Mob> getMobsInRange(Level level, BlockPos blockPos) {
        List list = level.m_6443_(Mob.class, new AABB(blockPos).m_82400_((double)this.getRange()), this.trainingRequirements(level, blockPos).and(mob -> {
            if (!(mob instanceof ITrainable)) return false;
            ITrainable trainable = (ITrainable)mob;
            if (this.getTrainedMob(level, blockPos) == null) return false;
            if (!trainable.canTrain(level, blockPos, this.getTrainedMob(level, blockPos))) return false;
            return true;
        }));
        ArrayList<Mob> mobList = new ArrayList<Mob>(this.trainLimit());
        for (Mob mob2 : list) {
            if (mobList.size() >= this.trainLimit()) continue;
            mobList.add(mob2);
        }
        return mobList;
    }

    default public boolean checkEligibility(Mob mob, Level level, BlockPos blockPos) {
        return this.trainingRequirements(level, blockPos).and(mob1 -> {
            if (!(mob1 instanceof ITrainable)) return false;
            ITrainable trainable = (ITrainable)mob1;
            if (this.getTrainedMob(level, blockPos) == null) return false;
            if (!(mob1.m_20238_(Vec3.m_82539_((Vec3i)blockPos)) <= (double)Mth.m_144944_((int)(this.getRange() + 2)))) return false;
            if (!trainable.canTrain(level, blockPos, this.getTrainedMob(level, blockPos))) return false;
            return true;
        }).test(mob);
    }

    default public List<Mob> getTrainableList(Level level, BlockPos blockPos) {
        return this.getMobsInRange(level, blockPos);
    }

    default public void addTrainable(Mob mob, Level level, BlockPos blockPos) {
        if (this.checkEligibility(mob, level, blockPos)) {
            this.addTrainable(mob);
        }
    }

    default public void addTrainable(Mob mob) {
    }

    default public int getCurrentAmount() {
        return 0;
    }

    default public int amountTraining(Level level, BlockPos blockPos) {
        return this.getTrainableList(level, blockPos).size();
    }

    default public boolean capacityAvailable(Level level, BlockPos blockPos) {
        return this.amountTraining(level, blockPos) <= this.trainLimit();
    }

    default public void trainMobs(Level level, BlockPos blockPos) {
        if (!this.getTrainableList(level, blockPos).isEmpty()) {
            for (Mob mob : this.getTrainableList(level, blockPos)) {
                this.trainMob(mob, level, blockPos);
            }
        }
    }

    default public void trainMob(Mob trainMob, Level level, BlockPos blockPos) {
        ITrainable trainable;
        EntityType<? extends Mob> trainedMob = this.getTrainedMob(level, blockPos);
        if (trainedMob != null && trainMob instanceof ITrainable && (trainable = (ITrainable)trainMob).canTrain(level, blockPos, trainedMob)) {
            if (trainable.getTrainPos().isEmpty() && this.capacityAvailable(level, blockPos)) {
                trainable.setTrainPos(blockPos);
            } else if (trainable.getTrainPos().isPresent() && BlockFinder.samePos(trainable.getTrainPos().get(), blockPos)) {
                trainable.train(trainedMob);
            }
        }
    }
}

