/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.GroundCircleParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class GroundAuraParticle
extends GroundCircleParticle {
    private final float rotSpeed;
    public final int ownerId;
    public final Vec3 origin;

    protected GroundAuraParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet spriteSet, int ownerId, float size) {
        super(level, x, y, z);
        this.ownerId = ownerId;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.origin = new Vec3(x, y, z);
        this.f_107219_ = false;
        this.f_107663_ = size;
        this.f_107225_ = 20;
        this.m_108339_(spriteSet);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
    }

    public Vec3 getPosition() {
        Entity owner = this.getEntity();
        return owner != null ? new Vec3(owner.m_20185_(), owner.m_20186_() + 0.25, owner.m_20189_()) : this.origin;
    }

    public Entity getEntity() {
        return this.ownerId == -1 ? null : this.f_107208_.m_6815_(this.ownerId);
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        Vec3 vec3 = this.getPosition();
        this.m_107264_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        if (++this.f_107224_ >= this.f_107225_ || this.getEntity() == null) {
            this.m_107274_();
        }
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Option
    implements ParticleOptions {
        public static final Codec<Option> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("ownerId").forGetter(d -> d.ownerId), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue))).apply((Applicative)instance, Option::new));
        public static final ParticleOptions.Deserializer<Option> DESERIALIZER = new ParticleOptions.Deserializer<Option>(){

            public Option fromCommand(ParticleType<Option> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int ownerId = reader.readInt();
                reader.expect(' ');
                float size = reader.readFloat();
                reader.expect(' ');
                float red = reader.readFloat();
                reader.expect(' ');
                float green = reader.readFloat();
                reader.expect(' ');
                float blue = reader.readFloat();
                return new Option(ownerId, size, red, green, blue);
            }

            public Option fromNetwork(ParticleType<Option> particleTypeIn, FriendlyByteBuf buffer) {
                return new Option(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
        private final int ownerId;
        private final float size;
        private final float red;
        private final float green;
        private final float blue;

        public Option(int ownerId, float size, ColorUtil color) {
            this.ownerId = ownerId;
            this.size = size;
            this.red = color.red;
            this.green = color.green;
            this.blue = color.blue;
        }

        public Option(int ownerId, float size, float red, float green, float blue) {
            this.ownerId = ownerId;
            this.size = size;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.ownerId);
            buffer.writeFloat(this.size);
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %f %f %f %f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.ownerId, Float.valueOf(this.size), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
        }

        public ParticleType<Option> m_6012_() {
            return (ParticleType)ModParticleTypes.GROUND_AURA.get();
        }

        public int getOwnerId() {
            return this.ownerId;
        }

        public float getSize() {
            return this.size;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }
    }

    public static class Provider
    implements ParticleProvider<Option> {
        private final SpriteSet sprites;

        public Provider(SpriteSet p_i50607_1_) {
            this.sprites = p_i50607_1_;
        }

        public Particle createParticle(Option pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new GroundAuraParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprites, pType.getOwnerId(), pType.getSize());
        }
    }
}

