/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.block;

import com.Polarice3.Goety.common.blocks.entities.VoidVaultBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultClientData;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VoidVaultRenderer
implements BlockEntityRenderer<VoidVaultBlockEntity> {
    private final ItemRenderer itemRenderer;

    public VoidVaultRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(VoidVaultBlockEntity pBlockEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        ItemStack itemStack;
        Level level;
        if (VoidVaultBlockEntity.Client.hasDisplayItem(pBlockEntity.getSharedData()) && (level = pBlockEntity.m_58904_()) != null && !(itemStack = pBlockEntity.getSharedData().getDisplayItem()).m_41619_()) {
            VoidVaultClientData vaultClientData = pBlockEntity.getClientData();
            VoidVaultRenderer.renderDisplayItem(pPartialTicks, level, pMatrixStack, pBuffer, pCombinedLight, itemStack.m_255036_(1), this.itemRenderer, vaultClientData.getPreviousDisplayRotation(), vaultClientData.getDisplayRotation(), level.m_213780_());
        }
    }

    @VisibleForTesting
    static int getRenderedAmount(int stackSize) {
        if (stackSize <= 1) {
            return 1;
        }
        if (stackSize <= 16) {
            return 2;
        }
        if (stackSize <= 32) {
            return 3;
        }
        return stackSize <= 48 ? 4 : 5;
    }

    public static void renderDisplayItem(float pPartialTicks, Level level, PoseStack poseStack, MultiBufferSource pBuffer, int light, ItemStack stack, ItemRenderer itemRenderer, float prevRotation, float rotation, RandomSource random) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.4f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(MathHelper.lerpAngleDegrees(pPartialTicks, prevRotation, rotation)));
        VoidVaultRenderer.renderStack(itemRenderer, poseStack, pBuffer, light, stack, random, level);
        poseStack.m_85849_();
    }

    public static void renderStack(ItemRenderer itemRenderer, PoseStack poseStack, MultiBufferSource pBuffer, int light, ItemStack stack, RandomSource random, Level world) {
        BakedModel bakedModel = itemRenderer.m_174264_(stack, world, null, 0);
        VoidVaultRenderer.renderStack(itemRenderer, poseStack, pBuffer, light, stack, bakedModel, bakedModel.m_7539_(), random);
    }

    public static void renderStack(ItemRenderer itemRenderer, PoseStack poseStack, MultiBufferSource pBuffer, int light, ItemStack stack, BakedModel model, boolean depth, RandomSource random) {
        float l;
        float k;
        int i = VoidVaultRenderer.getRenderedAmount(stack.m_41613_());
        float f = model.m_7442_().f_111793_.f_111757_.x();
        float g = model.m_7442_().f_111793_.f_111757_.y();
        float h = model.m_7442_().f_111793_.f_111757_.z();
        if (!depth) {
            float j = -0.0f * (float)(i - 1) * 0.5f * f;
            k = -0.0f * (float)(i - 1) * 0.5f * g;
            l = -0.09375f * (float)(i - 1) * 0.5f * h;
            poseStack.m_252880_(j, k, l);
        }
        for (int m = 0; m < i; ++m) {
            poseStack.m_85836_();
            if (m > 0) {
                if (depth) {
                    k = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                    l = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                    float n = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                    poseStack.m_252880_(k, l, n);
                } else {
                    k = (random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    l = (random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    poseStack.m_252880_(k, l, 0.0f);
                }
            }
            itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, false, poseStack, pBuffer, light, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
            if (depth) continue;
            poseStack.m_252880_(0.0f * f, 0.0f * g, 0.09375f * h);
        }
    }
}

