/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.RedstoneGolemAnimations;
import com.Polarice3.Goety.common.entities.ally.golem.RedstoneGolem;
import com.Polarice3.Goety.common.entities.hostile.illagers.HostileRedstoneGolem;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class RedstoneGolemModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart golem;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart chest;
    private final ModelPart pelvis;
    private final ModelPart core;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart lowerRight;
    private final ModelPart lowerLeft;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final List<ModelPart> glowParts;

    public RedstoneGolemModel(ModelPart root) {
        this.root = root;
        this.golem = root.m_171324_("golem");
        this.body = this.golem.m_171324_("body");
        this.chest = this.body.m_171324_("chest");
        this.pelvis = this.body.m_171324_("pelvis");
        this.core = this.chest.m_171324_("core");
        this.head = this.chest.m_171324_("head");
        this.rightArm = this.chest.m_171324_("right_arm");
        this.leftArm = this.chest.m_171324_("left_arm");
        this.lowerRight = this.rightArm.m_171324_("lower_right");
        this.lowerLeft = this.leftArm.m_171324_("lower_left");
        this.rightLeg = this.golem.m_171324_("right_leg");
        this.leftLeg = this.golem.m_171324_("left_leg");
        this.glowParts = ImmutableList.of((Object)this.body, (Object)this.chest, (Object)this.pelvis, (Object)this.core, (Object)this.head, (Object)this.rightArm, (Object)this.leftArm, (Object)this.lowerRight, (Object)this.lowerLeft, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition golem = partdefinition.m_171599_("golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = golem.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-19.0f, (float)2.0f));
        PartDefinition chest = body.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-20.0f, -41.0f, -10.0f, 40.0f, 32.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = chest.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-14.0f, -8.0f, -6.0f, 14.0f, 24.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-20.0f, (float)-31.0f, (float)0.0f));
        PartDefinition lower_right = right_arm.m_171599_("lower_right", CubeListBuilder.m_171558_().m_171514_(3, 88).m_171488_(-5.25f, 4.0f, -5.25f, 11.0f, 22.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-10.75f, (float)12.0f, (float)-0.75f));
        PartDefinition right_hand = lower_right.m_171599_("right_hand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.75f, (float)26.0f, (float)-1.25f));
        PartDefinition front_finger_R = right_hand.m_171599_("front_finger_R", CubeListBuilder.m_171558_().m_171514_(97, 55).m_171488_(-1.5f, -3.0f, -2.5f, 3.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)-1.0f));
        PartDefinition back_finger_R = right_hand.m_171599_("back_finger_R", CubeListBuilder.m_171558_().m_171514_(97, 55).m_171488_(-1.5f, -3.0f, -2.5f, 3.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)5.0f));
        PartDefinition thumb_R = right_hand.m_171599_("thumb_R", CubeListBuilder.m_171558_().m_171514_(81, 57).m_171488_(-1.5f, -2.0f, -2.5f, 3.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)-1.0f));
        PartDefinition left_arm = chest.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171480_().m_171488_(0.0f, -8.0f, -6.0f, 14.0f, 24.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)20.0f, (float)-31.0f, (float)0.0f));
        PartDefinition lower_left = left_arm.m_171599_("lower_left", CubeListBuilder.m_171558_().m_171514_(3, 88).m_171480_().m_171488_(-6.5f, 4.0f, -5.25f, 11.0f, 22.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)11.5f, (float)12.0f, (float)-0.75f));
        PartDefinition left_hand = lower_left.m_171599_("left_hand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)26.0f, (float)-0.25f));
        PartDefinition front_finger_L = left_hand.m_171599_("front_finger_L", CubeListBuilder.m_171558_().m_171514_(97, 55).m_171480_().m_171488_(-1.5f, -3.0f, -2.5f, 3.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)-2.0f));
        PartDefinition back_finger_L = left_hand.m_171599_("back_finger_L", CubeListBuilder.m_171558_().m_171514_(97, 55).m_171480_().m_171488_(-1.5f, -3.0f, -2.5f, 3.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)4.0f));
        PartDefinition thumb_L = left_hand.m_171599_("thumb_L", CubeListBuilder.m_171558_().m_171514_(81, 57).m_171480_().m_171488_(-1.5f, -2.0f, -2.5f, 3.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)-2.0f));
        PartDefinition core = chest.m_171599_("core", CubeListBuilder.m_171558_().m_171514_(49, 90).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-21.0f, (float)6.0f));
        PartDefinition head = chest.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(124, 8).m_171488_(-8.0f, -8.0f, -12.0f, 16.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-33.0f, (float)-10.0f));
        PartDefinition pelvis = body.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(120, 36).m_171488_(-11.0f, -9.0f, -7.0f, 22.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = golem.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(113, 58).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-14.0f, (float)-20.0f, (float)2.0f));
        PartDefinition left_leg = golem.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(161, 58).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)14.0f, (float)-20.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity instanceof RedstoneGolem) {
            RedstoneGolem redstoneGolem = (RedstoneGolem)entity;
            if (!redstoneGolem.isSummoning() && !redstoneGolem.m_21224_()) {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
            }
            this.m_233381_(redstoneGolem.activateAnimationState, RedstoneGolemAnimations.ACTIVATE, ageInTicks);
            this.m_233381_(redstoneGolem.noveltyAnimationState, RedstoneGolemAnimations.NOVELTY, ageInTicks);
            this.m_267799_(RedstoneGolemAnimations.WALK_FEET, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            if (redstoneGolem.isMoving() && redstoneGolem.canAnimateMove()) {
                this.m_267799_(RedstoneGolemAnimations.WALK_BODY, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            } else {
                this.m_233381_(redstoneGolem.idleAnimationState, RedstoneGolemAnimations.IDLE, ageInTicks);
            }
            this.m_233381_(redstoneGolem.attackAnimationState, RedstoneGolemAnimations.ATTACK, ageInTicks);
            this.m_233381_(redstoneGolem.summonAnimationState, RedstoneGolemAnimations.SUMMON, ageInTicks);
            this.m_233381_(redstoneGolem.sitAnimationState, RedstoneGolemAnimations.SIT, ageInTicks);
            this.m_233381_(redstoneGolem.toSitAnimationState, RedstoneGolemAnimations.TO_SIT, ageInTicks);
            this.m_233381_(redstoneGolem.toStandAnimationState, RedstoneGolemAnimations.TO_STAND, ageInTicks);
            this.m_233381_(redstoneGolem.deathAnimationState, RedstoneGolemAnimations.DEATH, ageInTicks);
        } else if (entity instanceof HostileRedstoneGolem) {
            HostileRedstoneGolem redstoneGolem = (HostileRedstoneGolem)entity;
            if (!redstoneGolem.isSummoning() && !redstoneGolem.m_21224_()) {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
            }
            this.m_233381_(redstoneGolem.idleAnimationState, RedstoneGolemAnimations.IDLE, ageInTicks);
            this.m_233381_(redstoneGolem.noveltyAnimationState, RedstoneGolemAnimations.NOVELTY, ageInTicks);
            this.m_267799_(RedstoneGolemAnimations.WALK_FEET, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            if (redstoneGolem.isMoving() && redstoneGolem.canAnimateMove()) {
                this.m_267799_(RedstoneGolemAnimations.WALK_BODY, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            } else {
                this.m_233381_(redstoneGolem.idleAnimationState, RedstoneGolemAnimations.IDLE, ageInTicks);
            }
            this.m_233381_(redstoneGolem.attackAnimationState, RedstoneGolemAnimations.ATTACK, ageInTicks);
            this.m_233381_(redstoneGolem.summonAnimationState, RedstoneGolemAnimations.SUMMON, ageInTicks);
            this.m_233381_(redstoneGolem.deathAnimationState, RedstoneGolemAnimations.DEATH, ageInTicks);
        }
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public List<ModelPart> getGlowParts() {
        return this.glowParts;
    }
}

