/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.ally.illager.AllyTrampler;
import com.Polarice3.Goety.common.entities.hostile.illagers.Trampler;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class TramplerModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart trampler;
    protected final ModelPart body;
    protected final ModelPart headParts;
    protected final ModelPart mouth;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public TramplerModel(ModelPart root) {
        this.root = root;
        this.trampler = root.m_171324_("trampler");
        this.body = this.trampler.m_171324_("body");
        this.headParts = this.body.m_171324_("neck");
        this.mouth = this.headParts.m_171324_("head").m_171324_("mouth");
        this.rightFrontLeg = this.body.m_171324_("right_front_leg");
        this.leftFrontLeg = this.body.m_171324_("left_front_leg");
        this.rightHindLeg = this.trampler.m_171324_("right_back_leg");
        this.leftHindLeg = this.trampler.m_171324_("left_back_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition trampler = partdefinition.m_171599_("trampler", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = trampler.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -19.0f, 8.0f, 10.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)9.0f));
        PartDefinition saddle = body.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, 1.0f, -5.5f, 8.0f, 7.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-7.0f));
        PartDefinition left_front_leg = body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171480_().m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 8).m_171480_().m_171488_(-0.5f, 10.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 0).m_171480_().m_171488_(-1.0f, 16.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)-7.0f, (float)-18.0f));
        PartDefinition right_front_leg = body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 8).m_171480_().m_171488_(-2.5f, 10.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 0).m_171480_().m_171488_(-3.0f, 16.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-7.0f, (float)-18.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-17.0f));
        PartDefinition Neck_r1 = neck.m_171599_("Neck_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.6506f, (float)-2.7679f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -7.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(0, 14).m_171488_(-1.0f, 0.5f, -10.75f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-4.0f));
        PartDefinition Head_r1 = head.m_171599_("Head_r1", CubeListBuilder.m_171558_().m_171514_(32, 50).m_171488_(-1.0f, -8.0f, -1.0f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.5f)).m_171514_(32, 50).m_171488_(10.0f, -8.0f, -1.0f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)-5.0f, (float)-3.0f, (float)-4.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(26, 41).m_171488_(-5.0f, 1.0f, -8.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)0.0f));
        PartDefinition left_back_leg = trampler.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(76, 14).m_171480_().m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(60, 22).m_171480_().m_171488_(-0.5f, 10.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(60, 14).m_171480_().m_171488_(-1.0f, 16.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)-20.0f, (float)9.0f));
        PartDefinition right_back_leg = trampler.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(76, 14).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(60, 22).m_171480_().m_171488_(-2.5f, 10.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(60, 14).m_171480_().m_171488_(-3.0f, 16.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-20.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.headParts);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void m_6839_(T p_102780_, float p_102781_, float p_102782_, float p_102783_) {
        super.m_6839_(p_102780_, p_102781_, p_102782_, p_102783_);
        float yBodyRotO = 0.0f;
        float yBodyRot = 0.0f;
        float yHeadRotO = 0.0f;
        float yHeadRot = 0.0f;
        float standingScale = 0.0f;
        float mouthAnim = 0.0f;
        if (p_102780_ instanceof Trampler) {
            Trampler trampler1 = (Trampler)p_102780_;
            yBodyRotO = trampler1.f_20884_;
            yBodyRot = trampler1.f_20883_;
            yHeadRotO = trampler1.f_20886_;
            yHeadRot = trampler1.f_20885_;
            standingScale = trampler1.getStandingAnimationScale(p_102783_);
            mouthAnim = trampler1.getMouthAnim(p_102783_);
        } else if (p_102780_ instanceof AllyTrampler) {
            AllyTrampler trampler1 = (AllyTrampler)p_102780_;
            yBodyRotO = trampler1.f_20884_;
            yBodyRot = trampler1.f_20883_;
            yHeadRotO = trampler1.f_20886_;
            yHeadRot = trampler1.f_20885_;
            standingScale = trampler1.getStandingAnimationScale(p_102783_);
            mouthAnim = trampler1.getMouthAnim(p_102783_);
        }
        float f = Mth.m_14189_((float)p_102783_, (float)yBodyRotO, (float)yBodyRot);
        float f1 = Mth.m_14189_((float)p_102783_, (float)yHeadRotO, (float)yHeadRot);
        float f2 = Mth.m_14179_((float)p_102783_, (float)((Entity)p_102780_).f_19860_, (float)p_102780_.m_146909_());
        float f3 = f1 - f;
        float f4 = f2 * ((float)Math.PI / 180);
        if (f3 > 20.0f) {
            f3 = 20.0f;
        }
        if (f3 < -20.0f) {
            f3 = -20.0f;
        }
        if (p_102782_ > 0.2f) {
            f4 += Mth.m_14089_((float)(p_102781_ * 0.4f)) * 0.15f * p_102782_;
        }
        float f5 = 0.0f;
        float f6 = standingScale;
        float f7 = 1.0f - f6;
        float f8 = mouthAnim;
        float f9 = (float)((Entity)p_102780_).f_19797_ + p_102783_;
        this.body.f_104203_ = 0.0f;
        this.headParts.f_104203_ = f4;
        this.headParts.f_104204_ = f3 * ((float)Math.PI / 180);
        float f10 = p_102780_.m_20069_() ? 0.2f : 1.0f;
        float f11 = Mth.m_14089_((float)(f10 * p_102781_ * 0.6662f + (float)Math.PI));
        float f12 = f11 * 0.8f * p_102782_;
        float f13 = (1.0f - Math.max(f6, f5)) * (f4 + f8 * Mth.m_14031_((float)f9) * 0.05f);
        this.headParts.f_104203_ = f6 * (0.2617994f + f4) + f5 * (2.1816616f + Mth.m_14031_((float)f9) * 0.05f) + f13;
        this.mouth.f_104203_ = f8 * 0.5f;
        this.headParts.f_104204_ = f6 * f3 * ((float)Math.PI / 180) + (1.0f - Math.max(f6, f5)) * this.headParts.f_104204_;
        this.body.f_104203_ = f6 * -0.7853982f + f7 * this.body.f_104203_;
        float f14 = 0.2617994f * f6;
        float f15 = Mth.m_14089_((float)(f9 * 0.6f + (float)Math.PI));
        float f16 = (-1.0471976f + f15) * f6 + f12 * f7;
        float f17 = (-1.0471976f - f15) * f6 - f12 * f7;
        this.leftHindLeg.f_104203_ = f14 - f11 * 0.5f * p_102782_ * f7;
        this.rightHindLeg.f_104203_ = f14 + f11 * 0.5f * p_102782_ * f7;
        this.leftFrontLeg.f_104203_ = f16;
        this.rightFrontLeg.f_104203_ = f17;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

