/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.ITrainingBlock;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.blocks.entities.OwnedBlockEntity;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class TrainingBlockEntity
extends OwnedBlockEntity
implements ITrainingBlock,
WorldlyContainer,
GameEventListener {
    public static int RANGE = 4;
    private final BlockPositionSource blockPosSource;
    public int trainTime;
    public int trainTimeTotal;
    public int trainAmount;
    public int updateVariant;
    public boolean showArea;
    public boolean sensorSensitive;
    public boolean guarding;
    public boolean grounding;
    public boolean reachedLimit;
    public ItemStack itemStack;
    public CompoundTag entityToSpawn;

    public TrainingBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.blockPosSource = new BlockPositionSource(this.f_58858_);
        this.trainTime = 0;
        this.trainTimeTotal = 100;
        this.guarding = true;
        this.itemStack = ItemStack.f_41583_;
        this.entityToSpawn = new CompoundTag();
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        blockEntity.tick(level, blockPos, blockState, blockEntity);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        blockEntity.tick(level, blockPos, blockState, blockEntity);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        if (level != null) {
            if (level instanceof ServerLevel && blockEntity.reachedLimit != blockEntity.summonLimit()) {
                blockEntity.reachedLimit = blockEntity.summonLimit();
                blockEntity.markUpdated();
            }
            if (blockEntity.updateVariant > 0) {
                --blockEntity.updateVariant;
                blockEntity.setVariant(blockEntity.itemStack, level, blockPos);
            }
            if (blockEntity.trainAmount > 0) {
                if (blockEntity.trainTime < blockEntity.getMaxTrainTime()) {
                    ++blockEntity.trainTime;
                } else {
                    boolean flag = blockEntity.isSensorSensitive() ? this.hasNearbyTarget() : true;
                    if (blockEntity.reachedLimit) {
                        flag = false;
                    }
                    if (flag) {
                        --blockEntity.trainAmount;
                        blockEntity.trainTime = 0;
                        blockEntity.itemStack = ItemStack.f_41583_;
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            for (int i = 0; i < 64; ++i) {
                                LivingEntity livingEntity;
                                Entity entity;
                                RandomSource randomsource = level.m_213780_();
                                double d0 = (double)blockPos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 4.0 + 0.5;
                                double d1 = blockPos.m_123342_() + randomsource.m_188503_(3) - 1;
                                double d2 = (double)blockPos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 4.0 + 0.5;
                                BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)d1, (double)d2);
                                if (!serverLevel.m_45772_(blockEntity.getTrainMob().m_20585_(d0, d1, d2)) || (entity = blockEntity.getTrainMob().m_20615_((Level)serverLevel)) == null) continue;
                                entity.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, Mth.m_14177_((float)(serverLevel.f_46441_.m_188501_() * 360.0f)), 0.0f);
                                level.m_142346_(entity, GameEvent.f_157810_, blockpos);
                                if (entity instanceof IOwned) {
                                    IOwned owned = (IOwned)entity;
                                    if (blockEntity.getTrueOwner() != null) {
                                        owned.setTrueOwner(blockEntity.getTrueOwner());
                                        if (owned instanceof LivingEntity) {
                                            LivingEntity livingEntity2;
                                            LivingEntity living = (LivingEntity)owned;
                                            if (blockEntity.isGrounding() && (livingEntity2 = blockEntity.getTrueOwner()) instanceof Player) {
                                                Player player = (Player)livingEntity2;
                                                SEHelper.addGroundedEntity(player, living);
                                            }
                                        }
                                    }
                                }
                                if (entity instanceof Mob) {
                                    Mob mob = (Mob)entity;
                                    mob.f_20885_ = mob.m_146908_();
                                    mob.f_20883_ = mob.m_146908_();
                                    mob.m_21373_();
                                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(blockPos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                                }
                                if (entity instanceof IServant) {
                                    IServant servant = (IServant)entity;
                                    if (this.isGuarding()) {
                                        servant.setBoundPos(blockPos);
                                    } else {
                                        servant.setBoundPos(null);
                                    }
                                    servant.setWandering(false);
                                    servant.setStaying(false);
                                }
                                if ((livingEntity = this.getTrueOwner()) instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, entity);
                                }
                                blockEntity.playSpawnSound();
                                serverLevel.m_47205_(entity);
                                break;
                            }
                        }
                    }
                }
                blockEntity.markUpdated();
            } else if (blockEntity.trainTime > 0) {
                blockEntity.trainTime = 0;
                blockEntity.markUpdated();
            }
            if (blockState.m_61138_((Property)BlockStateProperties.f_61448_)) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(blockEntity.isTraining())), 3);
            }
        }
    }

    public boolean hasNearbyTarget() {
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.f_58858_.m_7918_(-RANGE, -RANGE, -RANGE);
            BlockPos blockPos1 = this.f_58858_.m_7918_(RANGE, RANGE, RANGE);
            AABB aabb = new AABB(blockPos, blockPos1);
            List list = this.f_58857_.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity livingEntity : list) {
                if (!EntitySelector.f_20408_.test(livingEntity) || !EntitySelector.f_20403_.test(livingEntity)) continue;
                if (this.getTrueOwner() != null) {
                    return this.predicate().test(livingEntity);
                }
                return true;
            }
        }
        return false;
    }

    public Predicate<LivingEntity> predicate() {
        IOwned owned;
        LivingEntity livingEntity;
        if (this.getTrueOwner() instanceof Enemy || (livingEntity = this.getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).isHostile()) {
            return target -> {
                Player player;
                return target instanceof Player && EntitySelector.f_20406_.test(player = (Player)target);
            };
        }
        return target -> {
            Player player;
            LivingEntity patt11877$temp;
            IOwned owned;
            return !((!(target instanceof Enemy) || (target.m_6336_() == MobType.f_21641_ || target.m_6095_().m_204039_(ModTags.EntityTypes.LICH_NEUTRAL)) && this.getTrueOwner() != null && LichdomHelper.isLich((Entity)this.getTrueOwner()) && (Boolean)MainConfig.LichUndeadFriends.get() != false || (target.m_6336_() == MobType.f_21641_ || target.m_6095_().m_204039_(ModTags.EntityTypes.NECRO_SET_NEUTRAL)) && this.getTrueOwner() != null && CuriosFinder.hasUndeadSet(this.getTrueOwner()) && (Boolean)MobsConfig.NecroRobeUndead.get() != false || MobUtil.isWitchType((Entity)target) && this.getTrueOwner() != null && CuriosFinder.isWitchFriendly(this.getTrueOwner()) || CuriosFinder.validFrostMob(target) && this.getTrueOwner() != null && CuriosFinder.neutralFrostSet(this.getTrueOwner()) || CuriosFinder.validWildMob(target) && this.getTrueOwner() != null && CuriosFinder.neutralWildSet(this.getTrueOwner()) || CuriosFinder.validVoidMob(target) && this.getTrueOwner() != null && CuriosFinder.neutralVoidSet(this.getTrueOwner()) || CuriosFinder.validNetherMob(target) && this.getTrueOwner() != null && CuriosFinder.neutralNetherSet(this.getTrueOwner()) || target.m_6336_() == MobType.f_21642_ && this.getTrueOwner() != null && CuriosFinder.hasWarlockRobe(this.getTrueOwner()) || target instanceof Creeper && target.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && (Boolean)MobsConfig.ServantsAttackCreepers.get() != false || target instanceof NeutralMob && this.getTrueOwner() != null && ((NeutralMob)target).m_5448_() != this.getTrueOwner() || target instanceof IOwned && this.getTrueOwner() != null && ((IOwned)target).getTrueOwner() == this.getTrueOwner()) && (!(target instanceof IOwned) || !(owned = (IOwned)target).isHostile()) && (!((patt11877$temp = this.getTrueOwner()) instanceof Player) || (SEHelper.getGrudgeEntities(player = (Player)patt11877$temp).isEmpty() || !SEHelper.getGrudgeEntities(player).contains(target)) && (SEHelper.getGrudgeEntityTypes(player).isEmpty() || !SEHelper.getGrudgeEntityTypes(player).contains(target.m_6095_()))));
        };
    }

    public void setEntityType(EntityType<?> p_45463_) {
        ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey(p_45463_);
        this.entityToSpawn.m_128359_("id", location != null ? location.toString() : "minecraft:pig");
    }

    public void setEntityType(CompoundTag tag) {
        ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)tag.m_128461_("id"));
        this.entityToSpawn.m_128359_("id", resourcelocation != null ? resourcelocation.toString() : "minecraft:pig");
    }

    public CompoundTag getEntityToSpawn() {
        return this.entityToSpawn;
    }

    public void setVariant(ItemStack itemStack, Level level, BlockPos blockPos) {
    }

    @Override
    public EntityType<?> getTrainMob() {
        if (EntityType.m_20637_((CompoundTag)this.getEntityToSpawn()).isPresent()) {
            return (EntityType)EntityType.m_20637_((CompoundTag)this.getEntityToSpawn()).get();
        }
        return EntityType.f_20510_;
    }

    public void startTraining(int amount, ItemStack itemStack) {
        this.setVariant(itemStack, this.f_58857_, this.m_58899_());
        this.trainAmount = Math.min(this.trainAmount + amount, this.maxTrainAmount());
    }

    public void playSpawnSound() {
    }

    @Override
    public int getTrainingTime() {
        return this.trainTime;
    }

    @Override
    public int amountTrainLeft() {
        return this.trainAmount;
    }

    @Override
    public int getMaxTrainTime() {
        return this.trainTimeTotal;
    }

    public boolean isTraining() {
        return this.amountTrainLeft() > 0;
    }

    public boolean isFuel(ItemStack itemStack) {
        return true;
    }

    public boolean placeItem(ItemStack pStack) {
        if (this.f_58857_ != null && this.isFuel(pStack) && this.trainAmount < this.maxTrainAmount()) {
            this.itemStack = pStack;
            this.startTraining(1, pStack);
            if (pStack.hasCraftingRemainingItem()) {
                ItemHelper.addItemEntity(this.f_58857_, this.m_58899_().m_7494_(), pStack.getCraftingRemainingItem());
            }
            pStack.m_41774_(1);
            this.markUpdated();
            return true;
        }
        return false;
    }

    public static boolean getStructures(Level pLevel, BlockPos pPos, Predicate<BlockState> pPredicate, int totalCount) {
        int currentCount = 0;
        for (int i = -RANGE; i <= RANGE; ++i) {
            for (int j = -RANGE; j <= RANGE; ++j) {
                for (int k = -RANGE; k <= RANGE; ++k) {
                    BlockPos blockpos1 = pPos.m_7918_(i, j, k);
                    BlockState blockstate = pLevel.m_8055_(blockpos1);
                    if (!pPredicate.test(blockstate)) continue;
                    ++currentCount;
                }
            }
        }
        return currentCount >= totalCount;
    }

    public boolean getBlocks(Predicate<BlockState> pPredicate, int totalCount) {
        return TrainingBlockEntity.getStructures(this.f_58857_, this.f_58858_, pPredicate, totalCount);
    }

    @Override
    public boolean reachedLimit() {
        return this.reachedLimit;
    }

    public boolean summonLimit() {
        return false;
    }

    public PositionSource m_142460_() {
        return this.blockPosSource;
    }

    public GameEventListener.DeliveryMode m_247514_() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    public int m_142078_() {
        return RANGE;
    }

    public boolean m_214068_(ServerLevel p_222777_, GameEvent p_282184_, GameEvent.Context p_283014_, Vec3 p_282350_) {
        if (!this.m_58901_() && p_282184_.m_204528_(ModTags.GameEvents.BLOCK_EVENTS)) {
            this.updateVariant = 5;
            return true;
        }
        return false;
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        super.readNetwork(tag);
        if (tag.m_128441_("TrainTime")) {
            this.trainTime = tag.m_128451_("TrainTime");
        }
        if (tag.m_128441_("TrainTimeTotal")) {
            this.trainTimeTotal = tag.m_128451_("TrainTimeTotal");
        }
        if (tag.m_128441_("TrainAmount")) {
            this.trainAmount = tag.m_128451_("TrainAmount");
        }
        if (tag.m_128441_("Item")) {
            this.itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        }
        if (tag.m_128441_("EntityToSpawn")) {
            this.entityToSpawn = tag.m_128469_("EntityToSpawn");
        }
        if (tag.m_128441_("showArea")) {
            this.showArea = tag.m_128471_("showArea");
        }
        if (tag.m_128441_("sensorSensitive")) {
            this.sensorSensitive = tag.m_128471_("sensorSensitive");
        }
        if (tag.m_128441_("guardArea") || tag.m_128441_("patrolling")) {
            this.guarding = tag.m_128471_("guardArea");
        }
        if (tag.m_128441_("grounding") || tag.m_128441_("guarding")) {
            this.grounding = tag.m_128471_("grounding");
        }
        if (tag.m_128441_("reachedLimit")) {
            this.reachedLimit = tag.m_128471_("reachedLimit");
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        CompoundTag tag1 = super.writeNetwork(tag);
        tag1.m_128405_("TrainTime", this.trainTime);
        tag1.m_128405_("TrainTimeTotal", this.trainTimeTotal);
        tag1.m_128405_("TrainAmount", this.trainAmount);
        tag1.m_128365_("Item", (Tag)this.itemStack.m_41739_(new CompoundTag()));
        tag1.m_128365_("EntityToSpawn", (Tag)this.entityToSpawn);
        tag1.m_128379_("showArea", this.showArea);
        tag1.m_128379_("sensorSensitive", this.sensorSensitive);
        tag1.m_128379_("guardArea", this.guarding);
        tag1.m_128379_("grounding", this.grounding);
        tag1.m_128379_("reachedLimit", this.reachedLimit);
        return tag1;
    }

    public boolean isShowArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
        this.markUpdated();
    }

    @Override
    public boolean isSensorSensitive() {
        return this.sensorSensitive;
    }

    public void setSensorSensitive(boolean sensorSensitive) {
        this.sensorSensitive = sensorSensitive;
        this.markUpdated();
    }

    @Override
    public boolean isGuarding() {
        return this.guarding;
    }

    public void setGuarding(boolean guarding) {
        this.guarding = guarding;
        this.markUpdated();
    }

    @Override
    public boolean isGrounding() {
        return this.grounding;
    }

    public void setGrounding(boolean guarding) {
        this.grounding = guarding;
        this.markUpdated();
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int[] m_7071_(Direction p_19238_) {
        return new int[]{0};
    }

    public boolean m_7155_(int p_19235_, ItemStack pItemStack, @Nullable Direction p_19237_) {
        return this.f_58857_ != null && !this.f_58857_.f_46443_ && this.placeItem(pItemStack);
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int p_18941_) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int p_18951_) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
        this.placeItem(p_18945_);
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
    }
}

