/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities.void_spawner;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.client.particles.MagicAshSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerConfig;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerData;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerState;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.PlayerDetector;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class VoidSpawner {
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.m_144944_((int)47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final VoidSpawnerConfig config;
    private final VoidSpawnerData data;
    private final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;

    public Codec<VoidSpawner> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)VoidSpawnerConfig.MAP_CODEC.forGetter(VoidSpawner::getConfig), (App)VoidSpawnerData.MAP_CODEC.forGetter(VoidSpawner::getData)).apply((Applicative)instance, (trialSpawnerConfig, trialSpawnerData) -> new VoidSpawner((VoidSpawnerConfig)trialSpawnerConfig, (VoidSpawnerData)trialSpawnerData, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public VoidSpawner(StateAccessor stateAccessor, PlayerDetector playerDetector, PlayerDetector.EntitySelector entitySelector) {
        this(VoidSpawnerConfig.DEFAULT, new VoidSpawnerData(), stateAccessor, playerDetector, entitySelector);
    }

    public VoidSpawner(VoidSpawnerConfig trialSpawnerConfig, VoidSpawnerData trialSpawnerData, StateAccessor stateAccessor, PlayerDetector playerDetector, PlayerDetector.EntitySelector entitySelector) {
        this.config = trialSpawnerConfig;
        this.data = trialSpawnerData;
        this.data.setSpawnPotentialsFromConfig(trialSpawnerConfig);
        this.stateAccessor = stateAccessor;
        this.playerDetector = playerDetector;
        this.entitySelector = entitySelector;
    }

    public VoidSpawnerConfig getConfig() {
        return this.config;
    }

    public int getTargetCooldownLength() {
        return this.config.targetCooldownLength();
    }

    public int getRequiredPlayerRange() {
        return this.config.requiredPlayerRange();
    }

    public VoidSpawnerData getData() {
        return this.data;
    }

    public VoidSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(Level level, VoidSpawnerState trialSpawnerState) {
        this.stateAccessor.setState(level, trialSpawnerState);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(Level level) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        return level.m_46791_() != Difficulty.PEACEFUL;
    }

    public Optional<UUID> spawnMob(ServerLevel serverLevel, BlockPos blockPos) {
        double f;
        RandomSource randomSource = serverLevel.m_213780_();
        SpawnData spawnData = this.data.getOrCreateNextSpawnData(this, serverLevel.m_213780_());
        CompoundTag compoundTag = spawnData.f_186561_();
        ListTag listTag = compoundTag.m_128437_("Pos", 6);
        Optional optional = EntityType.m_20637_((CompoundTag)compoundTag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i = listTag.size();
        double d = i >= 1 ? listTag.m_128772_(0) : (double)blockPos.m_123341_() + (randomSource.m_188500_() - randomSource.m_188500_()) * (double)this.config.spawnRange() + 0.5;
        double e = i >= 2 ? listTag.m_128772_(1) : (double)(blockPos.m_123342_() + randomSource.m_188503_(3) - 1);
        double d2 = f = i >= 3 ? listTag.m_128772_(2) : (double)blockPos.m_123343_() + (randomSource.m_188500_() - randomSource.m_188500_()) * (double)this.config.spawnRange() + 0.5;
        if (!serverLevel.m_45772_(((EntityType)optional.get()).m_20585_(d, e, f))) {
            return Optional.empty();
        }
        Vec3 vec3 = new Vec3(d, e, f);
        if (!VoidSpawner.inLineOfSight((Level)serverLevel, blockPos.m_252807_(), vec3)) {
            return Optional.empty();
        }
        BlockPos blockPos2 = BlockPos.m_274446_((Position)vec3);
        Entity entity = EntityType.m_20645_((CompoundTag)compoundTag, (Level)serverLevel, entityx -> {
            entityx.m_7678_(d, e, f, randomSource.m_188501_() * 360.0f, 0.0f);
            return entityx;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.m_6914_((LevelReader)serverLevel)) {
                return Optional.empty();
            }
            if (spawnData.m_186567_().m_128440_() == 1 && spawnData.m_186567_().m_128425_("id", 8)) {
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(mob.m_20183_()), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
                mob.m_21530_();
                if (mob instanceof IServant) {
                    IServant servant = (IServant)mob;
                    servant.setBoundPos(blockPos);
                }
                mob.m_21446_(blockPos, ((Integer)MobsConfig.ServantGuardingRange.get()).intValue());
            }
        }
        if (!serverLevel.m_8860_(entity)) {
            return Optional.empty();
        }
        VoidSpawner.addSpawnParticles(serverLevel, blockPos, serverLevel.m_213780_());
        serverLevel.m_5594_(null, blockPos2, (SoundEvent)ModSounds.SUMMON_SPELL_FIERY.get(), SoundSource.BLOCKS, 1.0f, (serverLevel.m_213780_().m_188501_() - serverLevel.m_213780_().m_188501_()) * 0.2f + 1.0f);
        VoidSpawner.addSpawnParticles(serverLevel, blockPos2, serverLevel.m_213780_());
        serverLevel.m_142346_(entity, GameEvent.f_157810_, blockPos2);
        return Optional.of(entity.m_20148_());
    }

    public void ejectReward(ServerLevel serverLevel, BlockPos blockPos, ResourceLocation resourceLocation) {
        LootParams lootParams;
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(resourceLocation);
        ObjectArrayList objectArrayList = lootTable.m_287195_(lootParams = new LootParams.Builder(serverLevel).m_287235_(LootContextParamSets.f_81410_));
        if (!objectArrayList.isEmpty()) {
            for (ItemStack itemStack : objectArrayList) {
                DefaultDispenseItemBehavior.m_123378_((Level)serverLevel, (ItemStack)itemStack, (int)2, (Direction)Direction.UP, (Position)Vec3.m_82539_((Vec3i)blockPos).m_231075_(Direction.UP, 1.2));
            }
            serverLevel.m_5594_(null, blockPos, (SoundEvent)ModSounds.VOID_SPAWNER_EJECT_ITEM.get(), SoundSource.BLOCKS, 1.0f, (serverLevel.m_213780_().m_188501_() - serverLevel.m_213780_().m_188501_()) * 0.2f + 1.0f);
            VoidSpawner.addEjectItemParticles(serverLevel, blockPos, serverLevel.m_213780_());
        }
    }

    public void tickClient(Level level, BlockPos blockPos) {
        if (!this.canSpawnInLevel(level)) {
            this.data.oSpin = this.data.spin;
        } else {
            RandomSource randomSource;
            VoidSpawnerState trialSpawnerState = this.getState();
            trialSpawnerState.emitParticles(level, blockPos);
            if (trialSpawnerState.hasSpinningMob()) {
                double d = Math.max(0L, this.data.nextMobSpawnsAt - level.m_46467_());
                this.data.oSpin = this.data.spin;
                this.data.spin = (this.data.spin + trialSpawnerState.spinningMobSpeed() / (d + 200.0)) % 360.0;
            }
            if (trialSpawnerState.isCapableOfSpawning() && (randomSource = level.m_213780_()).m_188501_() <= 0.02f) {
                level.m_245747_(blockPos, (SoundEvent)ModSounds.VOID_SPAWNER_AMBIENT.get(), SoundSource.BLOCKS, randomSource.m_188501_() * 0.25f + 0.75f, randomSource.m_188501_() + 0.5f, false);
            }
        }
    }

    public void tickServer(ServerLevel serverLevel, BlockPos blockPos) {
        VoidSpawnerState trialSpawnerState = this.getState();
        if (!this.canSpawnInLevel((Level)serverLevel)) {
            if (trialSpawnerState.isCapableOfSpawning()) {
                this.data.reset();
                this.setState((Level)serverLevel, VoidSpawnerState.INACTIVE);
            }
        } else {
            VoidSpawnerState trialSpawnerState2;
            if (this.data.currentMobs.removeIf(uUID -> VoidSpawner.shouldMobBeUntracked(serverLevel, blockPos, uUID))) {
                this.data.nextMobSpawnsAt = serverLevel.m_46467_() + (long)this.config.ticksBetweenSpawn();
            }
            if ((trialSpawnerState2 = trialSpawnerState.tickAndGetNext(blockPos, this, serverLevel)) != trialSpawnerState) {
                this.setState((Level)serverLevel, trialSpawnerState2);
            }
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel serverLevel, BlockPos blockPos, UUID uUID) {
        Entity entity = serverLevel.m_8791_(uUID);
        return entity == null || !entity.m_6084_() || !entity.m_9236_().m_46472_().equals(serverLevel.m_46472_()) || entity.m_20183_().m_123331_((Vec3i)blockPos) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level level, Vec3 vec3, Vec3 vec32) {
        BlockHitResult blockHitResult = level.m_45547_(new ClipContext(vec32, vec3, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        return blockHitResult.m_82425_().equals((Object)BlockPos.m_274446_((Position)vec3)) || blockHitResult.m_6662_() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)blockPos.m_123341_() + 0.5 + (randomSource.m_188500_() - 0.5) * 2.0;
            double e = (double)blockPos.m_123342_() + 0.5 + (randomSource.m_188500_() - 0.5) * 2.0;
            double f = (double)blockPos.m_123343_() + 0.5 + (randomSource.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)new MagicAshSmokeParticle.Option(3802679, 6886773), d, e, f, 1, 0.0, 0.0, 0.0, 0.0);
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.END_FIRE.get()), d, e, f, 1, 0.0, 0.0, 0.0, 0.0);
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.END_FIRE_DROP.get()), d, e, f, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void addDetectPlayerParticles(ServerLevel level, BlockPos blockPos, RandomSource randomSource, int i) {
        for (int j = 0; j < 30 + Math.min(i, 10) * 5; ++j) {
            double d = (double)(2.0f * randomSource.m_188501_() - 1.0f) * 0.65;
            double e = (double)(2.0f * randomSource.m_188501_() - 1.0f) * 0.65;
            double f = (double)blockPos.m_123341_() + 0.5 + d;
            double g = (double)blockPos.m_123342_() + 0.1 + (double)randomSource.m_188501_() * 0.8;
            double h = (double)blockPos.m_123343_() + 0.5 + e;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.VOID_SPAWNER_DETECTION.get()), f, g, h, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)blockPos.m_123341_() + 0.4 + randomSource.m_188500_() * 0.2;
            double e = (double)blockPos.m_123342_() + 0.4 + randomSource.m_188500_() * 0.2;
            double f = (double)blockPos.m_123343_() + 0.4 + randomSource.m_188500_() * 0.2;
            double g = randomSource.m_188583_() * 0.02;
            double h = randomSource.m_188583_() * 0.02;
            double j = randomSource.m_188583_() * 0.02;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SMALL_END_FIRE.get()), d, e, f, 0, g, h, j * 0.25, 0.5);
            level.m_8767_((ParticleOptions)new MagicAshSmokeParticle.Option(3802679, 6886773), d, e, f, 0, g, h, j, 0.5);
        }
    }

    public static interface StateAccessor {
        public void setState(Level var1, VoidSpawnerState var2);

        public VoidSpawnerState getState();

        public void markUpdated();
    }
}

