/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.crafting;

import com.Polarice3.Goety.common.crafting.CursedInfuserRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class CursedInfuserRecipeSerializer<T extends CursedInfuserRecipes>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final IFactory<T> factory;

    public CursedInfuserRecipeSerializer(IFactory<T> pFactory, int pDefaultCookingTime) {
        this.defaultCookingTime = pDefaultCookingTime;
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        ItemStack itemstack;
        String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
        JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
        boolean grim = false;
        if (pJson.has("grim")) {
            grim = GsonHelper.m_13912_((JsonObject)pJson, (String)"grim");
        }
        if (!pJson.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (pJson.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
        } else {
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        int i = GsonHelper.m_13824_((JsonObject)pJson, (String)"cookingTime", (int)this.defaultCookingTime);
        return this.factory.create(pRecipeId, s, ingredient, itemstack, 0.0f, i, grim);
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String s = pBuffer.m_130136_(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
        ItemStack itemstack = pBuffer.m_130267_();
        int i = pBuffer.m_130242_();
        boolean grim = pBuffer.readBoolean();
        return this.factory.create(pRecipeId, s, ingredient, itemstack, 0.0f, i, grim);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(((CursedInfuserRecipes)pRecipe).group);
        ((CursedInfuserRecipes)pRecipe).ingredient.m_43923_(pBuffer);
        pBuffer.m_130055_(((CursedInfuserRecipes)pRecipe).result);
        pBuffer.m_130130_(((CursedInfuserRecipes)pRecipe).cookingTime);
        pBuffer.writeBoolean(((CursedInfuserRecipes)pRecipe).grim);
    }

    static interface IFactory<T extends CursedInfuserRecipes> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6, boolean var7);
    }
}

