/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.AbstractVine;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class QuickGrowingVine
extends AbstractVine {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(QuickGrowingVine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IDLE_TYPE = SynchedEntityData.m_135353_(QuickGrowingVine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState burstAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();
    public AnimationState holdAnimationState = new AnimationState();

    public QuickGrowingVine(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.QuickGrowingVineHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.QuickGrowingVineArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.QuickGrowingVineHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.QuickGrowingVineArmor.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(IDLE_TYPE, (Object)true);
    }

    @Override
    public void m_7380_(CompoundTag p_31485_) {
        super.m_7380_(p_31485_);
        p_31485_.m_128405_("Animation", this.getCurrentAnimation());
    }

    @Override
    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        if (p_31474_.m_128441_("Animation")) {
            this.setAnimationState(p_31474_.m_128451_("Animation"));
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "burst")) {
            return 2;
        }
        if (Objects.equals(animation, "burrow")) {
            return 3;
        }
        if (Objects.equals(animation, "hold")) {
            return 4;
        }
        if (Objects.equals(animation, "idle2")) {
            return 5;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.burstAnimationState);
        list.add(this.burrowAnimationState);
        list.add(this.holdAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.burstAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.burstAnimationState);
                    break;
                }
                case 3: {
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burrowAnimationState);
                    break;
                }
                case 4: {
                    this.holdAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.holdAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason != MobSpawnType.MOB_SUMMONED) {
            this.setPerpetual(true);
        }
        this.setAnimationState("hold");
        return pSpawnData;
    }

    @Override
    public void initRotate() {
        switch (this.m_217043_().m_188503_(4)) {
            case 1: {
                this.m_146922_(90.0f);
                this.m_5618_(90.0f);
                this.m_5616_(90.0f);
                break;
            }
            case 2: {
                this.m_146922_(180.0f);
                this.m_5618_(180.0f);
                this.m_5616_(180.0f);
                break;
            }
            case 3: {
                this.m_146922_(270.0f);
                this.m_5618_(270.0f);
                this.m_5616_(270.0f);
                break;
            }
            default: {
                this.m_146922_(0.0f);
                this.m_5618_(0.0f);
                this.m_5616_(0.0f);
            }
        }
    }

    @Override
    @Nullable
    public EntityType<?> getVariant(@Nullable Player player, Level level, BlockPos blockPos) {
        if (level.m_46801_(blockPos) || level.m_46801_(blockPos.m_7494_())) {
            return (EntityType)ModEntityType.QUICK_GROWING_KELP.get();
        }
        return super.getVariant(player, level, blockPos);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.QUICK_GROWING_VINE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.QUICK_GROWING_VINE_DEATH.get();
    }

    @Override
    protected SoundEvent getBurstSound() {
        return (SoundEvent)ModSounds.QUICK_GROWING_VINE_BURST.get();
    }

    @Override
    protected SoundEvent getBurrowSound() {
        return (SoundEvent)ModSounds.QUICK_GROWING_VINE_BURROW.get();
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50191_.m_49966_();
    }

    @Override
    public int getAgeSpeed() {
        if (!this.isActivate()) {
            return 5;
        }
        return 3;
    }

    @Override
    public void burst() {
        super.burst();
        if (this.activeTick < 15 && this.getCurrentAnimation() != this.getAnimationState("burst")) {
            this.setAnimationState("burst");
            this.m_5496_(this.getBurstSound(), 2.0f, 1.0f);
        } else if (this.getCurrentAnimation() < 2 && this.getCurrentAnimation() != this.getAnimationState("hold") || this.activeTick == 15) {
            this.setAnimationState("idle");
        }
    }

    @Override
    public void burrow() {
        super.burrow();
        this.setAnimationState("burrow");
        this.m_5496_(this.getBurrowSound(), 2.0f, 1.0f);
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack((ItemLike)ModItems.QUICK_GROWING_SEED.get());
    }
}

