/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class SpellLightningBolt
extends LightningBolt {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(SpellLightningBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(SpellLightningBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int START_LIFE = 2;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    public int life = 2;
    public long seed;
    public int flashes;
    public boolean visualOnly;
    public boolean setFire;
    public final Set<Entity> hitEntities = Sets.newHashSet();
    public int blocksSetOnFire;
    public float damage = 5.0f;

    public SpellLightningBolt(EntityType<? extends LightningBolt> p_20865_, Level p_20866_) {
        super(p_20865_, p_20866_);
        this.seed = this.f_19796_.m_188505_();
        this.flashes = this.f_19796_.m_188503_(3) + 1;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.setOwnerId(compound.m_128342_("Owner"));
        }
        if (compound.m_128441_("OwnerClient")) {
            this.setOwnerClientId(compound.m_128451_("OwnerClient"));
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        if (compound.m_128441_("VisualOnly")) {
            this.m_20874_(compound.m_128471_("VisualOnly"));
        }
        if (compound.m_128441_("SetFire")) {
            this.setFire(compound.m_128471_("SetFire"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getOwnerClientId() > -1) {
            compound.m_128405_("OwnerClient", this.getOwnerClientId());
        }
        compound.m_128350_("Damage", this.getTrueDamage());
        compound.m_128379_("VisualOnly", this.isVisualOnly());
        compound.m_128379_("SetFire", this.isSetFire());
    }

    @Nullable
    public LivingEntity getOwner() {
        LivingEntity living;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        int id = this.getOwnerClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getOwnerClientId())) instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.getOwnerId();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    public void m_20874_(boolean p_20875_) {
        this.visualOnly = p_20875_;
    }

    public boolean isVisualOnly() {
        return this.visualOnly;
    }

    public void setFire(boolean fire) {
        this.setFire = fire;
    }

    public boolean isSetFire() {
        return this.setFire;
    }

    @Nullable
    public ServerPlayer m_147158_() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            return serverPlayer;
        }
        return null;
    }

    public void m_20879_(@Nullable ServerPlayer p_20880_) {
        this.setOwner((LivingEntity)p_20880_);
    }

    public void setOwner(LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
            this.setOwnerClientId(livingEntity.m_19879_());
        }
    }

    private void m_147161_() {
        BlockPos blockpos = this.m_147162_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            ((LightningRodBlock)blockstate.m_60734_()).m_153760_(blockstate, this.f_19853_, blockpos);
        }
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getTrueDamage() {
        return this.damage;
    }

    public float getDamage() {
        return 0.0f;
    }

    public void m_8119_() {
        this.m_6075_();
        if (this.life == 2) {
            if (this.f_19853_.m_5776_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
            } else {
                Difficulty difficulty = this.f_19853_.m_46791_();
                if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                    this.m_20870_(4);
                }
                this.m_147161_();
                SpellLightningBolt.m_147150_(this.f_19853_, this.m_147162_());
                this.m_146850_(GameEvent.f_157772_);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    List list = this.f_19853_.m_6249_((Entity)this, new AABB(this.m_20185_() - 15.0, this.m_20186_() - 15.0, this.m_20189_() - 15.0, this.m_20185_() + 15.0, this.m_20186_() + 6.0 + 15.0, this.m_20189_() + 15.0), p_147140_ -> p_147140_.m_6084_() && !this.hitEntities.contains(p_147140_));
                    for (ServerPlayer serverplayer : serverLevel.m_8795_(p_147157_ -> p_147157_.m_20270_((Entity)this) < 256.0f)) {
                        CriteriaTriggers.f_145089_.m_153391_(serverplayer, (LightningBolt)this, list);
                    }
                }
                this.m_146870_();
            } else if (this.life < -this.f_19796_.m_188503_(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.f_19796_.m_188505_();
                this.m_20870_(0);
            }
        }
        if (this.life >= 0) {
            if (!(this.f_19853_ instanceof ServerLevel)) {
                this.f_19853_.m_6580_(2);
            } else if (!this.isVisualOnly()) {
                List list1 = this.f_19853_.m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), this::canHitEntity);
                for (Entity entity : list1) {
                    LivingEntity livingEntity;
                    if (!ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBolt)this)) {
                        entity.m_8038_((ServerLevel)this.f_19853_, (LightningBolt)this);
                    }
                    if (!(entity instanceof LivingEntity) || !EntitySelector.f_20406_.test(livingEntity = (LivingEntity)entity)) continue;
                    boolean flag = false;
                    DamageSource damageSource = this.m_269291_().m_269548_();
                    if (this.getOwner() != null) {
                        if (!MobUtil.areAllies((Entity)this.getOwner(), (Entity)livingEntity)) {
                            flag = true;
                            damageSource = ModDamageSource.lightning((Entity)this, (Entity)this.getOwner());
                        }
                    } else {
                        flag = true;
                    }
                    if (!flag) continue;
                    livingEntity.m_6469_(damageSource, this.getTrueDamage());
                }
                this.hitEntities.addAll(list1);
                if (this.m_147158_() != null) {
                    CriteriaTriggers.f_10554_.m_21721_(this.m_147158_(), (Collection)list1);
                }
            }
        }
    }

    private BlockPos m_147162_() {
        Vec3 vec3 = this.m_20182_();
        return BlockPos.m_274561_((double)vec3.f_82479_, (double)(vec3.f_82480_ - 1.0E-6), (double)vec3.f_82481_);
    }

    private void m_20870_(int p_20871_) {
        if (!this.isVisualOnly() && !this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46131_) && this.isSetFire()) {
            BlockPos blockpos = this.m_20183_();
            BlockState blockstate = BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos);
            if (this.f_19853_.m_8055_(blockpos).m_60795_() && blockstate.m_60710_((LevelReader)this.f_19853_, blockpos)) {
                this.f_19853_.m_46597_(blockpos, blockstate);
                ++this.blocksSetOnFire;
            }
            for (int i = 0; i < p_20871_; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
                blockstate = BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos1);
                if (!this.f_19853_.m_8055_(blockpos1).m_60795_() || !blockstate.m_60710_((LevelReader)this.f_19853_, blockpos1)) continue;
                this.f_19853_.m_46597_(blockpos1, blockstate);
                ++this.blocksSetOnFire;
            }
        }
    }

    private static void m_147150_(Level p_147151_, BlockPos p_147152_) {
        BlockState blockstate1;
        BlockPos blockpos;
        BlockState blockstate = p_147151_.m_8055_(p_147152_);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            blockpos = p_147152_.m_121945_(((Direction)blockstate.m_61143_((Property)LightningRodBlock.f_52588_)).m_122424_());
            blockstate1 = p_147151_.m_8055_(blockpos);
        } else {
            blockpos = p_147152_;
            blockstate1 = blockstate;
        }
        if (blockstate1.m_60734_() instanceof WeatheringCopper) {
            p_147151_.m_46597_(blockpos, WeatheringCopper.m_154906_((BlockState)p_147151_.m_8055_(blockpos)));
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_147152_.m_122032_();
            int i = p_147151_.f_46441_.m_188503_(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = p_147151_.f_46441_.m_188503_(8) + 1;
                SpellLightningBolt.m_147145_(p_147151_, blockpos, blockpos$mutableblockpos, k);
            }
        }
    }

    private static void m_147145_(Level p_147146_, BlockPos p_147147_, BlockPos.MutableBlockPos p_147148_, int p_147149_) {
        Optional<BlockPos> optional;
        p_147148_.m_122190_((Vec3i)p_147147_);
        for (int i = 0; i < p_147149_ && !(optional = SpellLightningBolt.m_147153_(p_147146_, (BlockPos)p_147148_)).isEmpty(); ++i) {
            p_147148_.m_122190_((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> m_147153_(Level p_147154_, BlockPos p_147155_) {
        for (BlockPos blockpos : BlockPos.m_235650_((RandomSource)p_147154_.f_46441_, (int)10, (BlockPos)p_147155_, (int)1)) {
            BlockState blockstate = p_147154_.m_8055_(blockpos);
            if (!(blockstate.m_60734_() instanceof WeatheringCopper)) continue;
            WeatheringCopper.m_154899_((BlockState)blockstate).ifPresent(p_147144_ -> p_147154_.m_46597_(blockpos, p_147144_));
            p_147154_.m_46796_(3002, blockpos, -1);
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }

    public int m_147159_() {
        return this.blocksSetOnFire;
    }

    @NotNull
    public Stream<Entity> m_147160_() {
        return this.hitEntities.stream().filter(Entity::m_6084_);
    }

    protected boolean canHitEntity(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return pEntity.m_6084_();
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (this.getOwner() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return pEntity.m_6084_();
    }
}

