/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.MobUtil;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.network.NetworkHooks;

public class DragonBreathCloud
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(DragonBreathCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.m_135353_(DragonBreathCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float damage = 12.0f;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public DragonBreathCloud(EntityType<? extends DragonBreathCloud> p_19704_, Level p_19705_) {
        super(p_19704_, p_19705_);
        this.f_19794_ = true;
    }

    public DragonBreathCloud(Level p_19707_, double p_19708_, double p_19709_, double p_19710_) {
        this((EntityType<? extends DragonBreathCloud>)((EntityType)ModEntityType.DRAGON_BREATH_CLOUD.get()), p_19707_);
        this.m_6034_(p_19708_, p_19709_, p_19710_);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        this.m_20088_().m_135372_(DATA_WAITING, (Object)false);
    }

    protected void m_7378_(CompoundTag p_19727_) {
        this.f_19797_ = p_19727_.m_128451_("Age");
        this.duration = p_19727_.m_128451_("Duration");
        this.waitTime = p_19727_.m_128451_("WaitTime");
        this.reapplicationDelay = p_19727_.m_128451_("ReapplicationDelay");
        this.durationOnUse = p_19727_.m_128451_("DurationOnUse");
        this.damage = p_19727_.m_128457_("Damage");
        this.radiusOnUse = p_19727_.m_128457_("RadiusOnUse");
        this.radiusPerTick = p_19727_.m_128457_("RadiusPerTick");
        this.setRadius(p_19727_.m_128457_("Radius"));
        if (p_19727_.m_128403_("Owner")) {
            this.ownerUUID = p_19727_.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag p_19737_) {
        p_19737_.m_128405_("Age", this.f_19797_);
        p_19737_.m_128405_("Duration", this.duration);
        p_19737_.m_128405_("WaitTime", this.waitTime);
        p_19737_.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        p_19737_.m_128405_("DurationOnUse", this.durationOnUse);
        p_19737_.m_128350_("Damage", this.damage);
        p_19737_.m_128350_("RadiusOnUse", this.radiusOnUse);
        p_19737_.m_128350_("RadiusPerTick", this.radiusPerTick);
        p_19737_.m_128350_("Radius", this.getRadius());
        if (this.ownerUUID != null) {
            p_19737_.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public void setRadius(float p_19713_) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)p_19713_, (float)0.0f, (float)32.0f)));
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    protected void setWaiting(boolean p_19731_) {
        this.m_20088_().m_135381_(DATA_WAITING, (Object)p_19731_);
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_19735_) {
        this.duration = p_19735_;
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float p_19733_) {
        this.radiusOnUse = p_19733_;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float p_19739_) {
        this.radiusPerTick = p_19739_;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float p_19739_) {
        this.damage = p_19739_;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int p_146786_) {
        this.durationOnUse = p_146786_;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int p_19741_) {
        this.waitTime = p_19741_;
    }

    public void setOwner(@Nullable LivingEntity p_19719_) {
        this.owner = p_19719_;
        this.ownerUUID = p_19719_ == null ? null : p_19719_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        block16: {
            boolean flag1;
            float f;
            boolean flag;
            block15: {
                float f1;
                int i;
                super.m_8119_();
                flag = this.isWaiting();
                f = this.getRadius();
                if (!this.f_19853_.f_46443_) break block15;
                if (flag && this.f_19796_.m_188499_()) {
                    return;
                }
                if (flag) {
                    i = 2;
                    f1 = 0.2f;
                } else {
                    i = Mth.m_14167_((float)((float)Math.PI * f * f));
                    f1 = f;
                }
                for (int j = 0; j < i; ++j) {
                    double d7;
                    double d6;
                    double d5;
                    float f2 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f3 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f1;
                    double d0 = this.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
                    double d2 = this.m_20186_();
                    double d4 = this.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
                    if (flag) {
                        d5 = 0.0;
                        d6 = 0.0;
                        d7 = 0.0;
                    } else {
                        d5 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                        d6 = 0.01f;
                        d7 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                    }
                    this.f_19853_.m_7107_((ParticleOptions)ParticleTypes.f_123799_, d0, d2, d4, d5, d6, d7);
                }
                break block16;
            }
            if (this.f_19797_ >= this.waitTime + this.duration) {
                this.m_146870_();
                return;
            }
            boolean bl = flag1 = this.f_19797_ < this.waitTime;
            if (flag != flag1) {
                this.setWaiting(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.m_146870_();
                    return;
                }
                this.setRadius(f);
            }
            if (this.f_19797_ % 5 != 0) break block16;
            this.victims.entrySet().removeIf(p_287380_ -> this.f_19797_ >= (Integer)p_287380_.getValue());
            List list1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
            if (!list1.isEmpty()) {
                for (LivingEntity livingentity : list1) {
                    double d1;
                    double d8;
                    double d3;
                    if (this.victims.containsKey(livingentity) || MobUtil.areAllies((Entity)livingentity, (Entity)this.getOwner()) || !((d3 = (d8 = livingentity.m_20185_() - this.m_20185_()) * d8 + (d1 = livingentity.m_20189_() - this.m_20189_()) * d1) <= (double)(f * f))) continue;
                    this.victims.put((Entity)livingentity, this.f_19797_ + this.reapplicationDelay);
                    livingentity.m_6469_(this.m_269291_().m_269254_(), this.getDamage());
                    if (this.radiusOnUse != 0.0f) {
                        if ((f += this.radiusOnUse) < 0.5f) {
                            this.m_146870_();
                            return;
                        }
                        this.setRadius(f);
                    }
                    if (this.durationOnUse == 0) continue;
                    this.duration += this.durationOnUse;
                    if (this.duration > 0) continue;
                    this.m_146870_();
                    return;
                }
            }
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

