/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.client.particles.LichShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.compat.iron.IronAttributes;
import com.Polarice3.Goety.compat.iron.IronLoaded;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LichEvents {
    @SubscribeEvent
    public static void onPlayerLichdom(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level world = player.f_19853_;
        if (LichdomHelper.isLich(player)) {
            boolean burn;
            player.m_36324_().m_38705_(17);
            player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
            boolean bl = burn = MobUtil.isInSunlight((LivingEntity)player) && !world.m_46471_();
            if (!player.f_19853_.f_46443_ && burn) {
                ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
                if (!helmet.m_41619_()) {
                    if (!player.m_7500_() && !MobUtil.isFireImmune((LivingEntity)player) && ((Boolean)MainConfig.LichDamageHelmet.get()).booleanValue() && helmet.m_41763_()) {
                        ItemHelper.hurtAndBreak(helmet, world.f_46441_.m_188503_(2), player);
                    }
                    burn = false;
                }
                if (burn && !MobUtil.isFireImmune((LivingEntity)player)) {
                    player.m_20254_(8);
                }
            }
            player.m_21220_().removeIf(effectInstance -> !EffectsUtil.canAffectLich(effectInstance, world));
            if (player.m_21023_((MobEffect)GoetyEffects.SOUL_HUNGER.get()) && SEHelper.getSoulsAmount(player, (Integer)MainConfig.MaxSouls.get())) {
                player.m_21195_((MobEffect)GoetyEffects.SOUL_HUNGER.get());
            }
            if (((Boolean)MainConfig.LichSoulHeal.get()).booleanValue() && (!player.m_6060_() || MobUtil.isFireImmune((LivingEntity)player)) && LichdomHelper.smited(player) <= 0 && player.m_21223_() < player.m_21233_() && player.f_19797_ % (MathHelper.secondsToTicks((Integer)MainConfig.LichHealSeconds.get()) + 1) == 0 && SEHelper.getSoulsAmount(player, (Integer)MainConfig.LichHealCost.get())) {
                player.m_5634_(((Double)MainConfig.LichHealAmount.get()).floatValue());
                Vec3 vector3d = player.m_20184_();
                if (!player.f_19853_.f_46443_) {
                    ServerLevel serverWorld = (ServerLevel)player.f_19853_;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_235898_, player.m_20208_(0.5), player.m_20187_(), player.m_20262_(0.5), 0, vector3d.f_82479_ * -0.2, 0.1, vector3d.f_82481_ * -0.2, 0.5);
                }
                SEHelper.decreaseSouls(player, (Integer)MainConfig.LichHealCost.get());
            }
            if (((Boolean)MainConfig.LichVillagerHate.get()).booleanValue() && player.f_19797_ % 20 == 0) {
                for (Villager villager : player.f_19853_.m_45976_(Villager.class, player.m_20191_().m_82400_(16.0))) {
                    if (villager.m_35532_(player) <= -200 || villager.m_35532_(player) >= 100) continue;
                    villager.m_35517_().m_26191_(player.m_20148_(), GossipType.MAJOR_NEGATIVE, 25);
                }
                for (IronGolem ironGolem : player.f_19853_.m_45976_(IronGolem.class, player.m_20191_().m_82400_(16.0))) {
                    if (ironGolem.m_28876_() || ironGolem.m_5448_() == player || !TargetingConditions.m_148352_().m_26883_(16.0).m_26885_((LivingEntity)ironGolem, (LivingEntity)player)) continue;
                    ironGolem.m_6710_((LivingEntity)player);
                }
            }
            if (LichdomHelper.isInLichMode(player)) {
                if (player.f_19797_ % 5 == 0 && world.f_46443_) {
                    world.m_7106_((ParticleOptions)ModParticleTypes.LICH.get(), player.m_20208_(0.5), player.m_20186_(), player.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
                if (((Boolean)MainConfig.LichModeSounds.get()).booleanValue() && event.phase == TickEvent.Phase.END && player.m_6084_()) {
                    MiscCapHelper.doAmbientSoundTime((LivingEntity)player);
                    if (MiscCapHelper.getAmbientSoundTime((LivingEntity)player) > player.m_217043_().m_188503_(1000)) {
                        MiscCapHelper.setAmbientSoundTime((LivingEntity)player, -MathHelper.secondsToTicks(4));
                        player.m_5496_((SoundEvent)ModSounds.LICH_AMBIENT.get(), 1.0f, player.m_6100_());
                    }
                }
            }
            if (player.m_6084_() && !player.f_19853_.f_46443_) {
                if (LichdomHelper.nightVision(player) && ((Boolean)MainConfig.LichNightVision.get()).booleanValue()) {
                    if (!player.m_21023_(MobEffects.f_19611_)) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, -1, 0, false, false, false));
                    }
                } else if (player.m_21023_(MobEffects.f_19611_)) {
                    player.m_21195_(MobEffects.f_19611_);
                }
            }
            if (LichdomHelper.smited(player) > 0) {
                LichdomHelper.setSmited(player, LichdomHelper.smited(player) - 1);
            }
        } else {
            if (LichdomHelper.isInLichMode(player)) {
                LichdomHelper.setLichMode(player, false);
            }
            if (LichdomHelper.nightVision(player)) {
                LichdomHelper.setNightVision(player, false);
            }
        }
        if (IronLoaded.IRON_SPELLBOOKS.isLoaded()) {
            AttributeInstance bloodResist = player.m_21051_(IronAttributes.BLOOD_MAGIC_RESIST);
            AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString("1d0bd7da-03e8-4b25-be6d-014d73689417"), "Lich Blood Resistance", 0.5, AttributeModifier.Operation.ADDITION);
            if (bloodResist != null) {
                if (LichdomHelper.isLich(player)) {
                    if (!bloodResist.m_22109_(attributemodifier)) {
                        bloodResist.m_22125_(attributemodifier);
                    }
                } else if (bloodResist.m_22109_(attributemodifier)) {
                    bloodResist.m_22130_(attributemodifier);
                }
            }
            AttributeInstance holyResist = player.m_21051_(IronAttributes.HOLY_MAGIC_RESIST);
            AttributeModifier attributemodifier1 = new AttributeModifier(UUID.fromString("5290681e-7020-4de5-bba2-a659242d45a9"), "Lich Holy Weakness", -0.5, AttributeModifier.Operation.ADDITION);
            if (holyResist != null) {
                if (LichdomHelper.isLich(player)) {
                    if (!holyResist.m_22109_(attributemodifier1)) {
                        holyResist.m_22125_(attributemodifier1);
                    }
                } else if (holyResist.m_22109_(attributemodifier1)) {
                    holyResist.m_22130_(attributemodifier1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void SpecialPotionEffects(MobEffectEvent.Applicable event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && LichdomHelper.isLich(player = (Player)livingEntity) && !EffectsUtil.canAffectLich(event.getEffectInstance(), player.f_19853_)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void UndeadFriendly(LivingChangeTargetEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (((Boolean)MainConfig.LichUndeadFriends.get()).booleanValue() && event.getEntity() instanceof Enemy && (event.getEntity().m_6336_() == MobType.f_21641_ || event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.LICH_NEUTRAL)) && event.getOriginalTarget() != null && (livingEntity = event.getOriginalTarget()) instanceof Player && LichdomHelper.isLich(player = (Player)livingEntity)) {
            if (((Boolean)MainConfig.LichPowerfulFoes.get()).booleanValue()) {
                if ((double)event.getEntity().m_21233_() <= (Double)MainConfig.LichPowerfulFoesHealth.get()) {
                    if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                        event.setNewTarget(null);
                        if (event.getEntity() instanceof NeutralMob) {
                            event.setNewTarget(null);
                        }
                    } else {
                        event.setCanceled(true);
                    }
                }
            } else if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                event.setNewTarget(null);
                if (event.getEntity() instanceof NeutralMob) {
                    event.setNewTarget(null);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void HurtEvent(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && LichdomHelper.isLich(player = (Player)livingEntity)) {
            Object object;
            if (((Boolean)MainConfig.LichMagicResist.get()).booleanValue() && event.getSource().m_269533_(DamageTypeTags.f_268731_)) {
                event.setAmount(event.getAmount() * 0.15f);
            }
            if (ModDamageSource.freezeAttacks(event.getSource()) || event.getSource().m_269533_(DamageTypeTags.f_268419_)) {
                event.setAmount(event.getAmount() / 2.0f);
            }
            if (((Boolean)MainConfig.LichUndeadFriends.get()).booleanValue() && CuriosFinder.hasUndeadSet((LivingEntity)player) && event.getSource().m_7639_() != null && (object = event.getSource().m_7639_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)object;
                for (Mob undead : player.f_19853_.m_45976_(Mob.class, player.m_20191_().m_82400_(16.0))) {
                    if (undead == attacker || undead.m_6336_() != MobType.f_21641_ || undead.m_5448_() == player) continue;
                    if (((Boolean)MainConfig.LichPowerfulFoes.get()).booleanValue()) {
                        if (!((double)undead.m_21233_() <= (Double)MainConfig.LichPowerfulFoesHealth.get())) continue;
                        undead.m_6710_(attacker);
                        continue;
                    }
                    undead.m_6710_(attacker);
                }
            }
            if (LichdomHelper.isInLichMode(player) && ((Boolean)MainConfig.LichModeSounds.get()).booleanValue() && player.m_6084_() && event.getAmount() > 0.0f && !player.f_19853_.f_46443_) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.LICH_HURT.get(), player.m_5720_(), 1.0f, player.m_6100_());
                MiscCapHelper.setAmbientSoundTime((LivingEntity)player, -MathHelper.secondsToTicks(4));
            }
        }
        if ((livingEntity = event.getSource().m_7640_()) instanceof Player && LichdomHelper.isLich(player = (Player)livingEntity) && ((Boolean)MainConfig.LichTouch.get()).booleanValue() && ModDamageSource.physicalAttacks(event.getSource()) && event.getEntity() != player) {
            if (player.m_21205_().m_41619_()) {
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), 900));
            }
            if (event.getEntity().m_6336_() != MobType.f_21641_ && player.m_21205_().m_204117_(ModTags.Items.LICH_WITHER_ITEMS)) {
                event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, MathHelper.secondsToTicks(5)));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (LichdomHelper.isLich((Entity)livingEntity) && LichdomHelper.isInLichMode(livingEntity) && !event.isCanceled()) {
            Level level;
            if (((Boolean)MainConfig.LichModeSounds.get()).booleanValue()) {
                Vec3 vec3 = livingEntity.m_20182_();
                livingEntity.f_19853_.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ModSounds.LICH_DEATH.get(), livingEntity.m_5720_(), 1.0f, livingEntity.m_6100_());
            }
            if ((level = livingEntity.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ColorUtil colorUtil = new ColorUtil(3597334);
                serverLevel.m_8767_((ParticleOptions)new LichShockwaveParticleOption(colorUtil, 40.0f, 20.0f, 1, 100), livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
            }
        }
    }
}

