/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.curios;

import com.Polarice3.Goety.common.items.curios.SingleStackItem;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;

public class SeaAmuletItem
extends SingleStackItem {
    private static final String CONDUIT_CHARGES = "Conduit Charges";
    private static final int MAX_POWER = (Integer)ItemConfig.SeaAmuletMax.get();

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            boolean flag = true;
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
                stack.m_41784_().m_128405_(CONDUIT_CHARGES, 0);
            } else {
                if (this.getConduitChargesAmount(stack) > MAX_POWER) {
                    this.setConduitCharges(stack, MAX_POWER);
                } else if (this.getConduitChargesAmount(stack) < 0) {
                    this.setConduitCharges(stack, 0);
                }
                if (CuriosFinder.hasCurio((LivingEntity)player, this) && player.m_5842_()) {
                    ConduitBlockEntity blockEntity1;
                    BlockEntity blockEntity = BlockFinder.findBlockEntity(BlockEntityType.f_58941_, worldIn, player.m_20183_(), 8);
                    if (blockEntity instanceof ConduitBlockEntity && (blockEntity1 = (ConduitBlockEntity)blockEntity).m_59216_()) {
                        if (this.getConduitChargesAmount(stack) < MAX_POWER) {
                            if (worldIn instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)worldIn;
                                ServerParticleUtil.gatheringParticles((ParticleOptions)ParticleTypes.f_123775_, (Entity)player, serverLevel);
                            }
                            this.increaseConduitCharges(stack);
                        }
                        flag = false;
                    }
                    int duration = MathHelper.secondsToTicks(5);
                    if (player.m_21023_(MobEffects.f_19592_)) {
                        MobEffectInstance mobEffectInstance = player.m_21124_(MobEffects.f_19592_);
                        boolean bl = flag = mobEffectInstance != null && mobEffectInstance.m_19557_() < duration;
                    }
                    if (flag && this.getConduitChargesAmount(stack) > 0 && MobUtil.playerValidity(player, true)) {
                        this.decreaseConduitCharges(stack);
                        if (!worldIn.f_46443_ && player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ModNetwork.sendToClient(serverPlayer, new SPlayPlayerSoundPacket(SoundEvents.f_11773_, 1.0f, 1.0f));
                        }
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, duration * 2, 0, false, false));
                    }
                }
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compound = pStack.m_41784_();
        compound.m_128405_(CONDUIT_CHARGES, 0);
    }

    public void increaseConduitCharges(ItemStack stack) {
        if (stack.m_41783_() != null && this.getConduitChargesAmount(stack) < MAX_POWER) {
            stack.m_41783_().m_128405_(CONDUIT_CHARGES, Math.min(MAX_POWER, this.getConduitChargesAmount(stack) + (Integer)ItemConfig.SeaAmuletChargeConsume.get()));
        }
    }

    public void decreaseConduitCharges(ItemStack stack) {
        if (stack.m_41783_() != null && this.getConduitChargesAmount(stack) > 0) {
            stack.m_41783_().m_128405_(CONDUIT_CHARGES, Math.max(0, this.getConduitChargesAmount(stack) - (Integer)ItemConfig.SeaAmuletChargeConsume.get()));
        }
    }

    public void setConduitCharges(ItemStack stack, int charges) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128405_(CONDUIT_CHARGES, charges);
        }
    }

    public int getConduitChargesAmount(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_(CONDUIT_CHARGES);
        }
        return 0;
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)(1.0 - this.amountColor(stack)) / 2.0f);
        return Mth.m_14169_((float)f, (float)1.0f, (float)f);
    }

    public double amountColor(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int i = stack.m_41783_().m_128451_(CONDUIT_CHARGES);
            return 1.0 - (double)i / (double)MAX_POWER;
        }
        return 1.0;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_() != null;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int power = stack.m_41783_().m_128451_(CONDUIT_CHARGES);
            return Math.round((float)power * 13.0f / (float)MAX_POWER);
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41783_() != null) {
            int conduit = stack.m_41783_().m_128451_(CONDUIT_CHARGES);
            tooltip.add((Component)Component.m_237110_((String)"info.goety.sea_amulet.amount", (Object[])new Object[]{conduit}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.sea_amulet.amount", (Object[])new Object[]{0}));
        }
    }
}

