/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.construct;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.golem.SquallGolem;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SquallGolemMold
implements IMold {
    private static final List<BlockPos> HIGHROCK_LOCATIONS = ImmutableList.of((Object)new BlockPos(2, 0, 0), (Object)new BlockPos(2, 0, 1), (Object)new BlockPos(2, 0, -1), (Object)new BlockPos(-2, 0, 0), (Object)new BlockPos(-2, 0, 1), (Object)new BlockPos(-2, 0, -1), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(-1, 0, 2), (Object)new BlockPos(0, 0, -2), (Object)new BlockPos(1, 0, -2), (Object)new BlockPos(-1, 0, -2), (Object[])new BlockPos[0]);
    private static final List<BlockPos> GRATE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(1, -1, 1), (Object)new BlockPos(1, -1, -1), (Object)new BlockPos(-1, -1, 1), (Object)new BlockPos(-1, -1, -1));
    private static final List<BlockPos> STONE_BRICKS_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, 0, 1), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(-1, 0, -1));
    private static final List<BlockPos> INDENTED_GOLD_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 1), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(-1, 0, 0));
    private static final BlockPos JADE = new BlockPos(0, 0, 0);

    private static List<BlockPos> checkHighrock(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : HIGHROCK_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)ModBlocks.POLISHED_HIGHROCK_BLOCK.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkGrates(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : GRATE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)ModBlocks.RUSTY_IRON_GRATE.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkStoneBricks(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : STONE_BRICKS_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(BlockTags.f_13091_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkIndentedGold(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : INDENTED_GOLD_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(ModTags.Blocks.INDENTED_GOLD_BLOCKS)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public static boolean checkBlocks(Level level, BlockPos blockPos) {
        return SquallGolemMold.checkHighrock(level, blockPos).isEmpty() && SquallGolemMold.checkGrates(level, blockPos).isEmpty() && SquallGolemMold.checkStoneBricks(level, blockPos).isEmpty() && SquallGolemMold.checkIndentedGold(level, blockPos).isEmpty();
    }

    @Override
    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60713_((Block)ModBlocks.JADE_BLOCK.get())) {
            if (SquallGolemMold.checkBlocks(level, blockPos)) {
                if (SEHelper.hasResearch(player, ResearchList.MISTRAL)) {
                    SquallGolem squallGolem = (SquallGolem)((EntityType)ModEntityType.SQUALL_GOLEM.get()).m_20615_(level);
                    if (squallGolem != null) {
                        squallGolem.setTrueOwner((LivingEntity)player);
                        squallGolem.m_6518_((ServerLevelAccessor)level, level.m_6436_(squallGolem.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        squallGolem.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                        if (level.m_7967_((Entity)squallGolem)) {
                            SquallGolemMold.removeBlocks(level, blockPos);
                            stack.m_41774_(1);
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)squallGolem);
                            }
                            return true;
                        }
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.research.fail"), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.block.fail"), true);
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            BlockPos blockPos2;
            for (BlockPos blockPos1 : STONE_BRICKS_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_204336_(BlockTags.f_13091_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : INDENTED_GOLD_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_204336_(ModTags.Blocks.INDENTED_GOLD_BLOCKS)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            BlockPos blockPos22 = blockPos.m_121955_((Vec3i)JADE);
            if (level.m_8055_(blockPos22).m_60713_((Block)ModBlocks.JADE_BLOCK.get())) {
                level.m_46796_(2001, blockPos22, Block.m_49956_((BlockState)level.m_8055_(blockPos22)));
                level.m_46597_(blockPos22, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

