/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.ViciousTooth;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TeethSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TeethCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.TeethDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11867_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.TeethCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        double radius = spellStat.getRadius();
        float potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, radius);
        BlockPos blockPos = caster.m_20183_();
        if (this.rightStaff(staff)) {
            if (this.isShifting(caster)) {
                this.surroundTeeth(caster, blockPos, potency, true);
            } else {
                LivingEntity target = this.getTarget(caster, range);
                if (target != null) {
                    blockPos = target.m_20183_();
                } else if (rayTraceResult instanceof BlockHitResult) {
                    blockPos = ((BlockHitResult)rayTraceResult).m_82425_().m_7494_();
                }
                for (int length = 0; length < 16; ++length) {
                    blockPos = blockPos.m_7918_(-2 + caster.m_217043_().m_188503_(4), 0, -2 + caster.m_217043_().m_188503_(4));
                    BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                    while ((double)blockpos$mutable.m_123342_() < (double)blockPos.m_123342_() + 8.0 && !worldIn.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                        blockpos$mutable.m_122173_(Direction.UP);
                    }
                    if (!worldIn.m_45772_(new AABB((BlockPos)blockpos$mutable))) continue;
                    ViciousTooth viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), (Level)worldIn);
                    viciousTooth.m_146884_(Vec3.m_82512_((Vec3i)blockpos$mutable));
                    viciousTooth.setOwner(caster);
                    viciousTooth.setExtraDamage(potency);
                    if (!worldIn.m_7967_((Entity)viciousTooth)) continue;
                    viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
                }
            }
        } else {
            if (this.isShifting(caster)) {
                blockPos = caster.m_20183_();
            } else if (rayTraceResult instanceof EntityHitResult) {
                Entity target = ((EntityHitResult)rayTraceResult).m_82443_();
                blockPos = target.m_20183_();
            } else if (rayTraceResult instanceof BlockHitResult) {
                blockPos = ((BlockHitResult)rayTraceResult).m_82425_().m_7494_();
            }
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            while ((double)blockpos$mutable.m_123342_() < (double)blockPos.m_123342_() + 8.0 && !worldIn.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                blockpos$mutable.m_122173_(Direction.UP);
            }
            if (worldIn.m_45772_(new AABB((BlockPos)blockpos$mutable))) {
                ViciousTooth viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), (Level)worldIn);
                viciousTooth.m_146884_(Vec3.m_82512_((Vec3i)blockpos$mutable));
                viciousTooth.setOwner(caster);
                viciousTooth.setExtraDamage(potency);
                if (worldIn.m_7967_((Entity)viciousTooth)) {
                    viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
                }
            }
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11862_);
    }

    public void surroundTeeth(LivingEntity livingEntity, BlockPos blockPos, float damage, boolean isStaff) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        while ((double)blockpos$mutable.m_123342_() < (double)blockPos.m_123342_() + 8.0 && !livingEntity.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
            blockpos$mutable.m_122173_(Direction.UP);
        }
        if (isStaff) {
            ViciousTooth viciousTooth;
            for (int i = 0; i < 5; ++i) {
                float f1 = (float)i * (float)Math.PI * 0.4f;
                viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), livingEntity.f_19853_);
                viciousTooth.m_6034_((double)blockPos.m_123341_() + (double)Mth.m_14089_((float)f1) * 1.5, blockpos$mutable.m_123342_(), (double)blockPos.m_123343_() + (double)Mth.m_14089_((float)f1) * 1.5);
                viciousTooth.setOwner(livingEntity);
                if (!livingEntity.f_19853_.m_7967_((Entity)viciousTooth)) continue;
                viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
            }
            for (int k = 0; k < 8; ++k) {
                float f2 = (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), livingEntity.f_19853_);
                viciousTooth.m_6034_((double)blockPos.m_123341_() + (double)Mth.m_14089_((float)f2) * 2.5, blockpos$mutable.m_123342_(), (double)blockPos.m_123343_() + (double)Mth.m_14031_((float)f2) * 2.5);
                viciousTooth.setOwner(livingEntity);
                viciousTooth.setExtraDamage(damage);
                if (!livingEntity.f_19853_.m_7967_((Entity)viciousTooth)) continue;
                viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
            }
        }
    }
}

