/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.RandomUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FrostNovaSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return new SpellStat(0, 1, 0, 2.5, 0, 0.0f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FrostNovaCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.FrostNovaDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.FROST_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FrostNovaCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, final LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float potency = spellStat.getPotency();
        float radius = (float)spellStat.getRadius();
        int duration = spellStat.getDuration();
        float damage = ((Double)SpellConfig.FrostNovaDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        float maxDamage = ((Double)SpellConfig.FrostNovaMaxDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(caster)) {
            radius += (float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0f;
        }
        damage += potency;
        maxDamage += potency;
        LivingEntity spellTarget = caster;
        LivingEntity target = this.getTarget(caster);
        if (this.isShifting(caster) && target != null) {
            spellTarget = target;
        }
        this.createParticleBall(worldIn, spellTarget, (int)radius);
        worldIn.m_8767_((ParticleOptions)new ShockwaveParticleOption(0.0f, radius * 2.0f, 1), spellTarget.m_20185_(), spellTarget.m_20186_() + 0.5, spellTarget.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        float trueDamage = Mth.m_14036_((float)(damage + (float)RandomUtil.nextInt(worldIn.m_213780_(), (int)(maxDamage - damage))), (float)damage, (float)maxDamage);
        final int finalDuration = duration;
        int amp = 0;
        if (this.rightStaff(staff)) {
            ++amp;
            radius += 0.5f;
        }
        final int finalAmp = amp;
        new SpellExplosion((Level)worldIn, (Entity)caster, ModDamageSource.directFreeze(caster), spellTarget.m_20183_(), radius, trueDamage){

            @Override
            public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                LivingEntity target1;
                if (target instanceof LivingEntity && !MobUtil.areAllies((Entity)caster, (Entity)(target1 = (LivingEntity)target)) && EntitySelector.f_20406_.test(target1)) {
                    super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                    target1.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(5) * finalDuration, finalAmp));
                }
            }
        };
        this.playSound(worldIn, (Entity)spellTarget, (SoundEvent)ModSounds.ICE_CHUNK_HIT.get(), 1.0f, 0.5f);
    }

    private void createParticleBall(ServerLevel serverLevel, LivingEntity livingEntity, int radius) {
        double d0 = livingEntity.m_20185_();
        double d1 = livingEntity.m_20186_();
        double d2 = livingEntity.m_20189_();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    double d3 = (double)j + (livingEntity.m_217043_().m_188500_() - livingEntity.m_217043_().m_188500_()) * 0.5;
                    double d4 = (double)i + (livingEntity.m_217043_().m_188500_() - livingEntity.m_217043_().m_188500_()) * 0.5;
                    double d5 = (double)k + (livingEntity.m_217043_().m_188500_() - livingEntity.m_217043_().m_188500_()) * 0.5;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5) / 0.5 + livingEntity.m_217043_().m_188583_() * 0.05;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FROST_NOVA.get()), d0, d1, d2, 0, d3 / d6, d4 / d6, d5 / d6, 0.5);
                    if (i == -radius || i == radius || j == -radius || j == radius) continue;
                    k += radius * 2 - 1;
                }
            }
        }
    }
}

