/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.MossySkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonPillagerServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.StrayServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SunkenSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.WitherSkeletonServant;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class SkeletonSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SkeletonCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SkeletonDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.SkeletonSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SkeletonCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof AbstractSkeletonServant;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.SkeletonLimit.get();
    }

    public boolean specialStaffs(ItemStack stack) {
        return this.typeStaff(stack, SpellType.FROST) || this.typeStaff(stack, SpellType.WILD) || this.typeStaff(stack, SpellType.NETHER) || this.typeStaff(stack, SpellType.ABYSS) || stack.m_150930_((Item)ModItems.OMINOUS_STAFF.get());
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        int i = 1;
        if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
            i = 7;
        } else if (this.rightStaff(staff)) {
            i = 2 + caster.f_19853_.f_46441_.m_188503_(4);
        } else if (this.specialStaffs(staff)) {
            i = 2;
        }
        if (!this.isShifting(caster)) {
            for (int i1 = 0; i1 < i; ++i1) {
                AbstractSkeletonServant summonedentity = new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_SERVANT.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, (Level)worldIn);
                if (caster.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius(caster, (Level)worldIn);
                }
                if (this.specialStaffs(staff)) {
                    if (this.typeStaff(staff, SpellType.FROST)) {
                        summonedentity = new StrayServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.STRAY_SERVANT.get()), (Level)worldIn);
                    } else if (this.typeStaff(staff, SpellType.WILD)) {
                        summonedentity = new MossySkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.MOSSY_SKELETON_SERVANT.get()), (Level)worldIn);
                    } else if (this.typeStaff(staff, SpellType.NETHER)) {
                        summonedentity = new WitherSkeletonServant((EntityType<? extends WitherSkeletonServant>)((EntityType)ModEntityType.WITHER_SKELETON_SERVANT.get()), (Level)worldIn);
                    } else if (this.typeStaff(staff, SpellType.ABYSS)) {
                        summonedentity = new SunkenSkeletonServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.SUNKEN_SKELETON_SERVANT.get()), (Level)worldIn);
                    } else if (staff.m_150930_((Item)ModItems.OMINOUS_STAFF.get())) {
                        summonedentity = new SkeletonPillagerServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_PILLAGER_SERVANT.get()), (Level)worldIn);
                    }
                } else {
                    Entity entity;
                    EntityType<?> entityType;
                    Player player = null;
                    if (caster instanceof Player) {
                        Player player1;
                        player = player1 = (Player)caster;
                    }
                    if ((entityType = summonedentity.getVariant(player, (Level)worldIn, blockPos)) != null && (entity = entityType.m_20615_((Level)worldIn)) instanceof AbstractSkeletonServant) {
                        AbstractSkeletonServant summoned;
                        summonedentity = summoned = (AbstractSkeletonServant)entity;
                    }
                }
                summonedentity.setTrueOwner(caster);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                if (summonedentity.m_6095_() != ModEntityType.SUNKEN_SKELETON_SERVANT.get()) {
                    MobUtil.moveDownToGround((Entity)summonedentity);
                }
                summonedentity.m_21530_();
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                summonedentity.setArrowPower(potency);
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.buffSummon(caster, (LivingEntity)summonedentity, potency);
                this.SummonSap(caster, (LivingEntity)summonedentity);
                this.setTarget(caster, (Mob)summonedentity);
                if (worldIn.m_7967_((Entity)summonedentity)) {
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle(worldIn, colorUtil, 0.1f, 0.1f, 0.05f, -1, summonedentity.m_20182_());
                }
                this.summonAdvancement(caster, (LivingEntity)summonedentity);
            }
            this.SummonDown(caster);
            SoundUtil.playNecromancerSummon((Entity)caster);
        }
    }
}

