/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.utility;

import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class IlluminateSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(16.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.IlluminateCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return 72000;
    }

    @Override
    public int defaultSpellCooldown() {
        return 20;
    }

    @Override
    public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            int range = 1;
            ColorUtil colorUtil = new ColorUtil(ChatFormatting.YELLOW);
            ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, caster.m_20182_().m_82520_(0.0, 2.0, 0.0)), (Entity)caster, serverLevel, range);
        }
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        if (castTime >= (Integer)SpellConfig.IlluminateChargeUp.get()) {
            double radius = spellStat.getRadius();
            if (WandUtil.enchantedFocus(caster)) {
                radius *= (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0;
            }
            int radiusInt = Mth.m_14107_((double)radius);
            Stream stream = BlockPos.m_121990_((BlockPos)caster.m_20183_().m_7918_(-radiusInt, -radiusInt / 2, -radiusInt), (BlockPos)caster.m_20183_().m_7918_(radiusInt, radiusInt / 2, radiusInt));
            if (castTime % (Integer)SpellConfig.IlluminateDuration.get() == 0 && stream.anyMatch(pos -> this.tryToPlaceAtPos(worldIn, caster, (BlockPos)pos) || this.replaceSoulLight((BlockPos)pos, worldIn))) {
                ServerParticleUtil.addParticlesAroundMiddleSelf(worldIn, (ParticleOptions)ModParticleTypes.GLOW_EFFECT.get(), (Entity)caster);
            }
        }
    }

    @Override
    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            if (!focus.m_41619_()) {
                SEHelper.addCooldown(player, focus.m_41720_(), this.spellCooldown(caster));
                SEHelper.sendSEUpdatePacket(player);
            }
        }
    }

    public boolean tryToPlaceAtPos(ServerLevel world, LivingEntity caster, BlockPos pos) {
        BlockPlaceContext context;
        Block block;
        int lightLevel = caster.f_19853_.m_45517_(LightLayer.BLOCK, pos);
        if (lightLevel > (Integer)SpellConfig.IlluminateMinLightLevel.get()) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (this.isBadPlacementToTry(world, pos, state, block = state.m_60734_(), context = new BlockPlaceContext((Level)world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(Vec3.m_82539_((Vec3i)pos), Direction.UP, pos, false)))) {
            return false;
        }
        return this.tryToPlaceGlowLightAround(pos, caster, world);
    }

    public boolean isBadPlacementToTry(ServerLevel world, BlockPos pos, BlockState state, Block block, BlockPlaceContext context) {
        return block instanceof LiquidBlock || world.m_8055_(pos.m_7495_()).m_60734_().m_49967_() || !state.m_60819_().m_76178_() || !state.m_60795_() && !state.m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)pos, (Direction)Direction.DOWN));
    }

    public boolean isBlockBlockingView(ServerLevel world, LivingEntity caster, BlockPos pos) {
        double playerEyeHeight = caster.m_20186_() + (double)caster.m_20192_();
        for (float xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    Vec3 rayTraceVector;
                    Vec3 playerVec = new Vec3(caster.m_20185_() + (double)xOff, playerEyeHeight + (double)yOff, caster.m_20189_() + (double)zOff);
                    BlockHitResult rayTraceResult = world.m_45547_(new ClipContext(playerVec, rayTraceVector = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5 + (double)xOff, 0.5 + (double)yOff, 0.5 + (double)zOff), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
                    if (rayTraceResult.m_6662_() != HitResult.Type.MISS) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean tryToPlaceGlowLightAround(BlockPos pos, LivingEntity caster, ServerLevel world) {
        if (this.isBlockBlockingView(world, caster, pos)) {
            return false;
        }
        return this.tryToPlaceGlowLight(pos, world);
    }

    public boolean replaceSoulLight(BlockPos pos, ServerLevel world) {
        if (world.m_8055_(pos).m_60713_((Block)ModBlocks.SOUL_LIGHT_BLOCK.get()) && world.m_7731_(pos, ((Block)ModBlocks.GLOW_LIGHT_BLOCK.get()).m_49966_(), 3)) {
            world.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.GLOW_EFFECT.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            world.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 0.8f);
            return true;
        }
        return false;
    }

    public boolean tryToPlaceGlowLight(BlockPos pos, ServerLevel world) {
        if (((Block)ModBlocks.GLOW_LIGHT_BLOCK.get()).m_49966_().m_60710_((LevelReader)world, pos)) {
            ArrayList trySides = Lists.newArrayList((Object[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
            for (Direction side : trySides) {
                BlockState blockState = world.m_8055_(pos.m_121945_(side));
                if (blockState.m_60795_() || !world.m_45752_(blockState, pos, CollisionContext.m_82749_()) || !world.m_7731_(pos, ((Block)ModBlocks.GLOW_LIGHT_BLOCK.get()).m_49966_(), 3)) continue;
                world.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.GLOW_EFFECT.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                world.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 0.8f);
                return true;
            }
        }
        return false;
    }
}

