/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.util.Cushion;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CushionSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(64).setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.CushionCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.CushionDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.CushionCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int duration = spellStat.getDuration();
        int radius = (int)spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            Cushion cushion = new Cushion((EntityType)ModEntityType.CUSHION.get(), (Level)worldIn);
            cushion.setRadius(radius);
            cushion.increaseLifeSpan(duration);
            cushion.m_146884_(target.m_20182_());
            worldIn.m_7967_((Entity)cushion);
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            Cushion cushion = new Cushion((EntityType)ModEntityType.CUSHION.get(), (Level)worldIn);
            cushion.setRadius(radius);
            cushion.increaseLifeSpan(duration);
            cushion.m_6034_((float)blockPos.m_123341_() + 0.5f, (float)blockPos.m_123342_() + 1.0f, (float)blockPos.m_123343_() + 0.5f);
            worldIn.m_7967_((Entity)cushion);
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11862_);
    }
}

