/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.blocks.entities.IWindPowered;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.WindBlowParticle;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.AbstractCyclone;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WindBlastSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setPotency(1).setRange(8);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.WindBlastCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.WindBlastDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.WindBlastCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        BlockPos blockPos;
        BlockEntity blockEntity;
        int i;
        Vec3 srcVec = new Vec3(caster.m_20185_(), caster.m_20188_(), caster.m_20189_());
        Vec3 lookVec = caster.m_20252_(1.0f);
        double knock = spellStat.getPotency();
        int range = spellStat.getRange();
        if (this.rightStaff(staff)) {
            range *= 2;
            knock *= 2.0;
        }
        if (WandUtil.enchantedFocus(caster)) {
            knock += (double)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 4.0;
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        double dist = 0.9;
        double px = caster.m_20185_() + lookVec.f_82479_ * dist;
        double py = caster.m_20188_() + lookVec.f_82480_ * dist;
        double pz = caster.m_20189_() + lookVec.f_82481_ * dist;
        for (i = 0; i < 16; ++i) {
            double pVelocity = (double)0.3f + (double)range / 10.0;
            double velocity = pVelocity + worldIn.m_213780_().m_188500_() * pVelocity;
            Vec3 vec3 = lookVec.m_82542_(velocity, velocity, velocity);
            Vec3 pos = new Vec3(px, py, pz);
            pos = pos.m_82520_(caster.m_217043_().m_188583_() / 2.0, caster.m_217043_().m_188583_() / 2.0, caster.m_217043_().m_188583_() / 2.0);
            int width = worldIn.m_213780_().m_216332_(1, 4);
            float height = worldIn.m_213780_().m_188501_() * 0.5f;
            worldIn.m_8767_((ParticleOptions)new WindBlowParticle.Option(ColorUtil.WHITE, width, height), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
        }
        for (i = 1; i < range; ++i) {
            Vec3 vector3d2 = srcVec.m_82549_(lookVec.m_82490_((double)i));
            if (this.typeStaff(staff, SpellType.FROST)) {
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FROST.get()), vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.typeStaff(staff, SpellType.WILD)) {
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FLY.get()), vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (!this.typeStaff(staff, SpellType.NETHER)) continue;
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123744_, vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        Vec3 rangeVec = new Vec3(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
        BlockHitResult result = this.blockResult((Level)worldIn, caster, range);
        if (result != null && (blockEntity = worldIn.m_7702_(blockPos = result.m_82425_())) instanceof IWindPowered) {
            IWindPowered windPowered = (IWindPowered)blockEntity;
            windPowered.activate(MathHelper.secondsToTicks(15));
        }
        List entities = caster.f_19853_.m_45933_((Entity)caster, caster.m_20191_().m_82400_(1.0).m_82369_(rangeVec));
        for (Entity entity : entities) {
            if (!caster.m_142582_(entity) || MobUtil.areAllies(entity, (Entity)caster) || entity.m_6095_().m_204039_(ModTags.EntityTypes.UNBLOWABLE_ENTITIES)) continue;
            MobUtil.knockBack(entity, (Entity)caster, 2.0 * knock, 0.2 * knock, 2.0 * knock);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (this.typeStaff(staff, SpellType.FROST)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(5)));
                }
                if (this.typeStaff(staff, SpellType.WILD)) {
                    MobEffect mobEffect = MobEffects.f_19614_;
                    if (CuriosFinder.hasWildRobe(caster)) {
                        mobEffect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                    }
                    living.m_7292_(new MobEffectInstance(mobEffect, MathHelper.secondsToTicks(5)));
                }
                if (this.typeStaff(staff, SpellType.NETHER)) {
                    living.m_20254_(5);
                }
            }
            if (!(entity instanceof AbstractCyclone)) continue;
            AbstractCyclone cyclone = (AbstractCyclone)entity;
            cyclone.trueRemove();
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.WIND_BLAST.get(), 0.3f, 1.3f);
    }
}

