/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.magic;

import com.Polarice3.Goety.api.magic.ISummonSpell;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.curios.MagicHatItem;
import com.Polarice3.Goety.common.items.curios.MagicRobeItem;
import com.Polarice3.Goety.common.items.curios.NecroGarbs;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.compat.serene_seasons.SSeasonsIntegration;
import com.Polarice3.Goety.compat.serene_seasons.SSeasonsLoaded;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModAttributes;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface ISpell {
    default public SpellStat defaultStats() {
        return new SpellStat(0, 0, 16, 2.0, 0, 0.0f);
    }

    public int defaultSoulCost();

    default public int soulCost(LivingEntity caster, ItemStack staff) {
        return this.SoulCalculation(caster);
    }

    default public int SoulCalculation(LivingEntity caster) {
        float cost = this.defaultSoulCost() * this.SoulCostUp(caster);
        BlockPos blockPos = caster.m_20183_();
        Level level = caster.f_19853_;
        Holder biomeHolder = level.m_204166_(blockPos);
        boolean enable = (Boolean)SpellConfig.EnvironmentalCost.get();
        if (this.SoulDiscount(caster)) {
            cost /= 1.15f;
        }
        if (this.getSpellType() == SpellType.FROST) {
            if (this.FrostSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (((Biome)biomeHolder.get()).m_198904_(blockPos) || biomeHolder.m_203656_(ModTags.Biomes.FROST_DISCOUNT) || level.m_46758_(blockPos) && ((Biome)biomeHolder.get()).m_198904_(blockPos)) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.FROST_MARKUP)) {
                    cost *= 1.5f;
                } else if (SSeasonsLoaded.SERENE_SEASONS.isLoaded() && SSeasonsIntegration.summonSnowVariant(level, blockPos)) {
                    cost /= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.WIND) {
            if (this.WindSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (blockPos.m_123342_() >= 128 && level.m_45527_(blockPos) || biomeHolder.m_203656_(ModTags.Biomes.WIND_DISCOUNT)) {
                    cost /= 1.5f;
                } else if (blockPos.m_123342_() <= 32 && !level.m_45527_(blockPos) || biomeHolder.m_203656_(ModTags.Biomes.WIND_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.STORM) {
            if (this.StormSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (level.m_45527_(blockPos) && level.m_46470_() || biomeHolder.m_203656_(ModTags.Biomes.STORM_DISCOUNT)) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.STORM_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.GEOMANCY) {
            if (this.GeoSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (blockPos.m_123342_() <= 32 || biomeHolder.m_203656_(ModTags.Biomes.GEOMANCY_DISCOUNT)) {
                    cost /= 1.5f;
                } else if (blockPos.m_123342_() >= 128 || biomeHolder.m_203656_(ModTags.Biomes.GEOMANCY_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.NETHER) {
            if (this.NetherSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (level.m_46472_() == Level.f_46429_ || biomeHolder.m_203656_(ModTags.Biomes.NETHER_DISCOUNT)) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.NETHER_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.NECROMANCY) {
            if (this.NecroSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (level.m_46940_() > 0.9f || biomeHolder.m_203656_(ModTags.Biomes.NECROMANCY_DISCOUNT) || BlockFinder.findStructure(level, blockPos, ModTags.Structures.NECROMANCER_POWER)) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.NECROMANCY_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.WILD) {
            if (this.WildSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (biomeHolder.m_203656_(ModTags.Biomes.WILD_DISCOUNT)) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.WILD_MARKUP)) {
                    cost *= 1.5f;
                } else if (SSeasonsLoaded.SERENE_SEASONS.isLoaded() && SSeasonsIntegration.summonSnowVariant(level, blockPos)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.ABYSS) {
            if (this.AbyssSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (biomeHolder.m_203656_(ModTags.Biomes.ABYSS_DISCOUNT)) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.ABYSS_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        if (this.getSpellType() == SpellType.VOID) {
            if (this.VoidSoulDiscount(caster)) {
                cost /= 2.0f;
            }
            if (enable) {
                if (biomeHolder.m_203656_(ModTags.Biomes.VOID_DISCOUNT) || level.m_46472_() == Level.f_46430_) {
                    cost /= 1.5f;
                } else if (biomeHolder.m_203656_(ModTags.Biomes.VOID_MARKUP)) {
                    cost *= 1.5f;
                }
            }
        }
        return (int)(cost *= (float)ModAttributes.getSoulDiscount(caster));
    }

    public int defaultCastDuration();

    default public int castDuration(LivingEntity caster, ItemStack staff) {
        double duration = this.defaultCastDuration();
        if (this.ReduceCastTime(caster)) {
            duration /= 2.0;
        }
        return (int)(duration *= ModAttributes.getCastingSpeed(caster));
    }

    @Nullable
    default public SoundEvent CastingSound(LivingEntity caster) {
        return this.CastingSound();
    }

    @Nullable
    default public SoundEvent CastingSound() {
        return SoundEvents.f_11862_;
    }

    default public float castingVolume() {
        return 0.5f;
    }

    default public float castingPitch() {
        return 1.0f;
    }

    public int defaultSpellCooldown();

    @Deprecated
    default public int spellCooldown() {
        return this.defaultSpellCooldown();
    }

    default public int spellCooldown(LivingEntity caster) {
        return (int)((double)this.defaultSpellCooldown() * ModAttributes.getCooldownDiscount(caster));
    }

    default public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
    }

    default public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
    }

    default public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
    }

    default public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
    }

    public SpellType getSpellType();

    default public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        return this.conditionsMet(worldIn, caster, WandUtil.getStats(caster, this));
    }

    default public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        return true;
    }

    public List<Enchantment> acceptedEnchantments();

    default public SoundEvent loopSound(LivingEntity caster) {
        return null;
    }

    default public ColorUtil particleColors(LivingEntity caster) {
        return new ColorUtil(0.2f, 0.2f, 0.2f);
    }

    @Nullable
    default public ParticleOptions getParticle(LivingEntity caster) {
        return ParticleTypes.f_123811_;
    }

    default public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        double d0 = this.particleColors(caster).red();
        double d1 = this.particleColors(caster).green();
        double d2 = this.particleColors(caster).blue();
        ParticleOptions particle = this.getParticle(caster);
        if (particle != null) {
            if (worldIn instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)worldIn;
                serverLevel.m_8767_(particle, caster.m_20185_(), caster.m_20191_().f_82292_ + 0.5, caster.m_20189_(), 0, d0, d1, d2, 0.5);
            } else {
                worldIn.m_7106_(particle, caster.m_20185_(), caster.m_20191_().f_82292_ + 0.5, caster.m_20189_(), d0, d1, d2);
            }
        }
    }

    @Nullable
    default public LivingEntity getTarget(LivingEntity caster) {
        return null;
    }

    default public HitResult rayTrace(Level worldIn, LivingEntity caster, int range, double radius) {
        if (this.entityResult(worldIn, caster, range, radius) == null) {
            return this.blockResult(worldIn, caster, range);
        }
        return this.entityResult(worldIn, caster, range, radius);
    }

    default public BlockHitResult blockResult(Level worldIn, LivingEntity caster, double range) {
        float f = caster.m_146909_();
        float f1 = caster.m_146908_();
        Vec3 vector3d = caster.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vector3d1 = vector3d.m_82520_((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)caster));
    }

    default public EntityHitResult entityResult(Level worldIn, LivingEntity caster, int range, double radius) {
        Vec3 srcVec = caster.m_20299_(1.0f);
        Vec3 lookVec = caster.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
        AABB axisalignedbb = caster.m_20191_().m_82369_(lookVec.m_82490_((double)range)).m_82377_(radius, radius, radius);
        return ProjectileUtil.m_37304_((Level)worldIn, (Entity)caster, (Vec3)srcVec, (Vec3)destVec, (AABB)axisalignedbb, entity -> entity instanceof LivingEntity && !entity.m_5833_() && entity.m_6087_());
    }

    default public boolean ReduceCastTime(LivingEntity caster) {
        if (this.getSpellType() == SpellType.FROST) {
            return CuriosFinder.hasFrostCrown(caster) || CuriosFinder.hasMagicHat(caster);
        }
        if (this.getSpellType() == SpellType.WILD) {
            return CuriosFinder.hasWildCrown(caster) || CuriosFinder.hasMagicHat(caster);
        }
        if (this.getSpellType() == SpellType.ABYSS) {
            return CuriosFinder.hasAbyssCrown(caster) || CuriosFinder.hasMagicHat(caster);
        }
        if (this.getSpellType() == SpellType.VOID) {
            return CuriosFinder.hasVoidCrown(caster) || CuriosFinder.hasMagicHat(caster);
        }
        if (this.getSpellType() == SpellType.NETHER) {
            return CuriosFinder.hasNetherCrown(caster) || CuriosFinder.hasMagicHat(caster);
        }
        if (this.getSpellType() == SpellType.NECROMANCY) {
            return CuriosFinder.hasUndeadCrown(caster) || CuriosFinder.hasMagicHat(caster);
        }
        return CuriosFinder.hasCurio(caster, itemStack -> {
            if (itemStack.m_41720_() instanceof MagicHatItem) return true;
            Item patt13316$temp = itemStack.m_41720_();
            if (!(patt13316$temp instanceof NecroGarbs.NecroCrownItem)) return false;
            NecroGarbs.NecroCrownItem crown = (NecroGarbs.NecroCrownItem)patt13316$temp;
            if (!crown.isNameless) return false;
            return true;
        });
    }

    @Nullable
    default public MobEffectInstance summonDownEffect(LivingEntity caster) {
        return caster.m_21124_((MobEffect)GoetyEffects.SUMMON_DOWN.get());
    }

    default public int SoulCostUp(LivingEntity caster) {
        MobEffectInstance mobEffectInstance = this.summonDownEffect(caster);
        if (mobEffectInstance != null && this instanceof ISummonSpell) {
            return mobEffectInstance.m_19564_() + 2;
        }
        return 1;
    }

    default public boolean SoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasCurio(caster, itemStack -> itemStack.m_41720_() instanceof MagicRobeItem);
    }

    default public boolean FrostSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasFrostRobes(caster);
    }

    default public boolean WindSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasCurio(caster, (Item)ModItems.WIND_ROBE.get());
    }

    default public boolean GeoSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasCurio(caster, (Item)ModItems.AMETHYST_NECKLACE.get());
    }

    default public boolean StormSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasCurio(caster, (Item)ModItems.STORM_ROBE.get());
    }

    default public boolean WildSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasWildRobe(caster);
    }

    default public boolean NetherSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasNetherRobe(caster);
    }

    default public boolean AbyssSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasAbyssRobes(caster);
    }

    default public boolean NecroSoulDiscount(LivingEntity caster) {
        return false;
    }

    default public boolean VoidSoulDiscount(LivingEntity caster) {
        return CuriosFinder.hasVoidRobe(caster);
    }
}

