/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.VanguardAnimations;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class VanguardModel<T extends VanguardServant>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart shield;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public VanguardModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightArm = this.body.m_171324_("right_arm");
        this.shield = this.rightArm.m_171324_("shield");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -10.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-1.0f, -12.0f, -6.0f, 2.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition helmet2 = helmet.m_171599_("helmet2", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171488_(-1.0f, -10.0f, -6.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(-1.0f, -10.0f, 5.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171488_(-1.0f, -10.0f, -5.0f, 2.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armor = body.m_171599_("armor", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-5.0f, 0.0f, -3.0f, 10.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(36, 119).m_171488_(-4.0f, 9.0f, -2.5f, 8.0f, 3.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-8.0f, (float)0.0f));
        PartDefinition shield = right_arm.m_171599_("shield", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = shield.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(32, 66).m_171488_(-1.0f, 13.0f, 12.0f, 16.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(32, 87).m_171488_(-1.0f, 13.0f, 13.0f, 16.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)23.0f, (float)-22.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition ridge = shield.m_171599_("ridge", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-5.0f, -0.5f, 3.625f, 0.0f, 1.0f, 10.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(-8.0f, -0.5f, 3.625f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 65).m_171488_(-8.0f, -0.5f, -1.375f, 0.0f, 1.0f, 5.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(-8.0f, -0.5f, -1.375f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 66).m_171488_(-6.0f, -0.5f, -5.375f, 0.0f, 1.0f, 4.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(-6.0f, -0.5f, -5.375f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 68).m_171488_(-3.0f, -0.5f, -7.375f, 0.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(-3.0f, -0.5f, -7.375f, 6.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 68).m_171488_(3.0f, -0.5f, -7.375f, 0.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(3.0f, -0.5f, -5.375f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 66).m_171488_(6.0f, -0.5f, -5.375f, 0.0f, 1.0f, 4.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(5.0f, -0.5f, -1.375f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 65).m_171488_(8.0f, -0.5f, -1.375f, 0.0f, 1.0f, 5.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(5.0f, -0.5f, 3.625f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 60).m_171488_(5.0f, -0.5f, 3.625f, 0.0f, 1.0f, 10.0f, new CubeDeformation(-0.01f)).m_171514_(0, 70).m_171488_(-5.0f, -0.5f, 13.625f, 10.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)-1.625f));
        PartDefinition ridge2 = shield.m_171599_("ridge2", CubeListBuilder.m_171558_().m_171514_(2, 75).m_171488_(-6.0f, -0.5f, 5.625f, 0.0f, 1.0f, 8.0f, new CubeDeformation(-0.01f)).m_171514_(0, 83).m_171488_(-7.0f, -0.5f, 5.625f, 1.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 72).m_171488_(-7.0f, -0.5f, -5.375f, 0.0f, 1.0f, 11.0f, new CubeDeformation(-0.01f)).m_171514_(0, 72).m_171488_(7.0f, -0.5f, -5.375f, 0.0f, 1.0f, 11.0f, new CubeDeformation(-0.01f)).m_171514_(0, 83).m_171488_(6.0f, -0.5f, 5.625f, 1.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(2, 75).m_171488_(6.0f, -0.5f, 5.625f, 0.0f, 1.0f, 8.0f, new CubeDeformation(-0.01f)).m_171514_(0, 83).m_171488_(-6.0f, -0.5f, 13.625f, 12.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)-1.625f));
        PartDefinition top = ridge2.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 83).m_171488_(-11.5f, -0.5f, 0.0f, 4.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 81).m_171488_(-7.5f, -0.5f, -2.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)).m_171514_(0, 83).m_171488_(-7.5f, -0.5f, -2.0f, 6.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(0, 81).m_171488_(-1.5f, -0.5f, -2.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)).m_171514_(0, 83).m_171488_(-1.5f, -0.5f, 0.0f, 4.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)-5.375f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-8.0f, (float)0.0f));
        PartDefinition glaive = left_arm.m_171599_("glaive", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-3.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bits = glaive.m_171599_("bits", CubeListBuilder.m_171558_().m_171514_(0, 91).m_171488_(0.0f, -16.0f, -15.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 91).m_171488_(0.0f, -15.0f, -14.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 91).m_171488_(0.0f, -14.0f, -13.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 91).m_171488_(0.0f, -13.0f, -12.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 91).m_171488_(0.0f, -12.0f, -11.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 91).m_171488_(0.0f, -11.0f, -10.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 91).m_171488_(0.0f, -10.0f, -9.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 91).m_171488_(0.0f, -9.0f, -8.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(16, 91).m_171488_(0.0f, -8.0f, -7.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(20, 90).m_171488_(0.0f, -7.0f, -6.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 89).m_171488_(0.0f, -3.0f, -7.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 92).m_171488_(0.0f, -6.0f, -5.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 89).m_171488_(0.0f, -4.0f, -4.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 88).m_171488_(0.0f, -3.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 88).m_171488_(0.0f, -2.0f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 1.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 2.0f, 2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(11, 88).m_171488_(0.0f, 3.0f, 3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(15, 88).m_171488_(0.0f, 4.0f, 4.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(15, 88).m_171488_(0.0f, 5.0f, 5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(15, 88).m_171488_(0.0f, 6.0f, 6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 7.0f, 7.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 8.0f, 8.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 9.0f, 9.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(7, 88).m_171488_(0.0f, 10.0f, 10.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 84).m_171488_(0.0f, 11.0f, 11.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 86).m_171488_(0.0f, 13.0f, 13.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition leg_armor_R = right_leg.m_171599_("leg_armor_R", CubeListBuilder.m_171558_().m_171514_(42, 49).m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 9.0f, 6.0f, new CubeDeformation(-0.49f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition leg_armor_L = left_leg.m_171599_("leg_armor_L", CubeListBuilder.m_171558_().m_171514_(42, 31).m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 9.0f, 6.0f, new CubeDeformation(-0.49f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
            if (((VanguardServant)entity).isMeleeAttacking()) {
                this.animateWalk(limbSwing, limbSwingAmount);
            }
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        this.m_233381_(((VanguardServant)entity).idleAnimationState, VanguardAnimations.IDLE, ageInTicks);
        if (this.f_102609_) {
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.m_233385_(((VanguardServant)entity).walkAnimationState, VanguardAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
        }
        this.m_233381_(((VanguardServant)entity).attackAnimationState, VanguardAnimations.ATTACK, ageInTicks);
        this.m_233381_(((VanguardServant)entity).stayingAnimationState, VanguardAnimations.STAYING, ageInTicks);
        this.shield.f_104207_ = ((VanguardServant)entity).hasShield();
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

