/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.NecroBrazierBlock;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.SoulCandlestickBlockEntity;
import com.Polarice3.Goety.common.crafting.BrazierRecipe;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ConstantPaths;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NecroBrazierBlockEntity
extends ModBlockEntity
implements Clearable {
    private final List<SoulCandlestickBlockEntity> candlestickBlockEntityList = Lists.newArrayList();
    public BrazierRecipe recipe;
    public ResourceLocation recipeId;
    public final SimpleContainer inventory = new SimpleContainer(5){

        public int m_6893_() {
            return 1;
        }
    };
    public int currentTime;

    public NecroBrazierBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.NECRO_BRAZIER.get(), p_155229_, p_155230_);
    }

    public Container getContainer() {
        return this.inventory;
    }

    public void setItems(NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.getContainer().m_6836_(i, (ItemStack)items.get(i));
        }
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList itemStacks = NonNullList.m_122780_((int)this.getContainer().m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.getContainer().m_6643_(); ++i) {
            itemStacks.set(i, (Object)this.getContainer().m_8020_(i));
        }
        return itemStacks;
    }

    public boolean isEmpty() {
        int i = 0;
        for (ItemStack itemStack : this.getItems()) {
            if (itemStack.m_41619_()) continue;
            ++i;
        }
        return i <= 0;
    }

    @Override
    public void readNetwork(CompoundTag compoundNBT) {
        NonNullList items = NonNullList.m_122780_((int)this.getContainer().m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundNBT, (NonNullList)items);
        this.setItems((NonNullList<ItemStack>)items);
        this.currentTime = compoundNBT.m_128451_("currentTime");
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag pCompound) {
        this.saveMetadataAndItems(pCompound);
        pCompound.m_128405_("currentTime", this.currentTime);
        return pCompound;
    }

    private CompoundTag saveMetadataAndItems(CompoundTag pCompound) {
        ContainerHelper.m_18976_((CompoundTag)pCompound, this.getItems(), (boolean)true);
        return pCompound;
    }

    public boolean addItem(@Nullable Player player, ItemStack stack) {
        if (this.currentTime > 0) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.getContainer().m_6643_(); ++i) {
            if (!this.getContainer().m_8020_(i).m_41619_()) continue;
            did = true;
            ItemStack stackToAdd = stack.m_255036_(1);
            this.getContainer().m_6836_(i, stackToAdd);
            if (player != null && player.m_150110_().f_35937_) break;
            stack.m_41774_(1);
            break;
        }
        if (did) {
            if (player != null && this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.markUpdated();
        }
        return did;
    }

    public void removeItem(Player player) {
        for (int i = this.getContainer().m_6643_() - 1; i >= 0; --i) {
            ItemStack stackAt = this.getContainer().m_8020_(i);
            if (stackAt.m_41619_()) continue;
            ItemStack copy = stackAt.m_41777_();
            player.m_150109_().m_150079_(copy);
            this.getContainer().m_6836_(i, ItemStack.f_41583_);
            break;
        }
    }

    public void removeAllItems() {
        for (int i = 0; i < this.getContainer().m_6643_(); ++i) {
            ItemStack stackAt = this.getContainer().m_8020_(i);
            if (stackAt.m_41619_()) continue;
            this.getContainer().m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void updateRecipe(Level world) {
        if (this.getRecipe() != null) {
            if (!this.getRecipe().m_5818_(this.getContainer(), world)) {
                this.stopBrazier(false);
            }
        } else {
            this.stopBrazier(false);
        }
    }

    public boolean activate(Level world) {
        if (this.getRecipe() == null) {
            BrazierRecipe brazierRecipe = world.m_7465_().m_44013_((RecipeType)ModRecipeSerializer.BRAZIER_TYPE.get()).stream().filter(r -> r.m_5818_(this.getContainer(), world)).findFirst().orElse(null);
            if (brazierRecipe != null) {
                this.recipe = brazierRecipe;
            } else {
                return false;
            }
        }
        return true;
    }

    public BrazierRecipe getRecipe() {
        if (this.recipeId != null && this.f_58857_ != null) {
            Optional recipe = this.f_58857_.m_7465_().m_44043_(this.recipeId);
            recipe.map(r -> (BrazierRecipe)r).ifPresent(r -> {
                this.recipe = r;
            });
            this.recipeId = null;
        }
        return this.recipe;
    }

    public void tick() {
        if (this.f_58857_ != null) {
            boolean flag = this.f_58857_.m_204166_(this.m_58899_()).m_203565_(Biomes.f_220594_);
            if (flag) {
                this.findCandlesticks();
                if (!this.f_58857_.f_46443_ && this.f_58857_.f_46441_.m_188501_() < 0.3f && this.f_58857_.f_46441_.m_188501_() < 0.17f) {
                    ModNetwork.sendToALL(new SPlayWorldSoundPacket(this.f_58858_, SoundEvents.f_11907_, 0.5f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.3f));
                }
                if (!this.candlestickBlockEntityList.isEmpty()) {
                    BrazierRecipe recipe = this.getRecipe();
                    double d0 = (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_();
                    double d1 = (double)this.f_58858_.m_123342_() + 0.5 + this.f_58857_.f_46441_.m_188500_();
                    double d2 = (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_();
                    if (!this.f_58857_.f_46443_) {
                        ServerLevel serverWorld = (ServerLevel)this.f_58857_;
                        this.makeParticles();
                        if (this.activate(this.f_58857_) && recipe != null) {
                            for (int p = 0; p < 2; ++p) {
                                serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SMALL_NECRO_FIRE.get()), d0, (double)((float)this.f_58858_.m_123342_() + 0.5f), d2, 1, 0.0, 0.0, 0.0, 0.0);
                                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, 0.0, 5.0E-4, 0.0, 0.5);
                                serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.NECRO_EFFECT.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            for (SoulCandlestickBlockEntity candlestickBlock : this.candlestickBlockEntityList) {
                                if (candlestickBlock.getSouls() <= 0) continue;
                                candlestickBlock.drainSouls(1, this.m_58899_());
                                ++this.currentTime;
                            }
                            if (this.currentTime == 1) {
                                ModNetwork.sendToALL(new SPlayWorldSoundPacket(this.f_58858_, SoundEvents.f_11701_, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f));
                            }
                            if (this.f_58857_.m_46467_() % 20L == 0L) {
                                ModNetwork.sendToALL(new SPlayWorldSoundPacket(this.f_58858_, SoundEvents.f_11936_, 1.0f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.3f));
                                ModNetwork.sendToALL(new SPlayWorldSoundPacket(this.f_58858_, SoundEvents.f_215740_, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f));
                                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.15, (double)this.f_58858_.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
                            }
                            if (this.currentTime >= recipe.getSoulCost()) {
                                this.stopBrazier(true);
                            } else {
                                this.updateRecipe(this.f_58857_);
                            }
                        }
                    }
                } else if (!this.f_58857_.f_46443_) {
                    this.stopBrazier(false);
                }
            } else if (!this.f_58857_.f_46443_) {
                this.stopBrazier(false);
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)NecroBrazierBlock.LIT, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void stopBrazier(boolean finished) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BrazierRecipe recipe = this.getRecipe();
            if (recipe != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (finished) {
                    ItemStack itemstack1 = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeSerializer.BRAZIER_TYPE.get(), this.getContainer(), this.f_58857_).map(recipes -> recipes.m_5874_(this.getContainer(), this.f_58857_.m_9598_())).orElse(ItemStack.f_41583_);
                    BlockPos blockpos = this.m_58899_();
                    NecroBrazierBlockEntity.dropItemStack(this.f_58857_, blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_(), itemstack1);
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.CAST_SPELL.get(), SoundSource.BLOCKS, 2.0f, 0.5f);
                } else if (!this.isEmpty()) {
                    Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_(), this.getItems());
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SPELL_FAIL.get(), SoundSource.BLOCKS, 2.0f, 0.5f);
                }
            } else if (!this.isEmpty()) {
                Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_(), this.getItems());
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SPELL_FAIL.get(), SoundSource.BLOCKS, 2.0f, 0.5f);
            }
            this.removeAllItems();
            this.m_6211_();
            this.recipe = null;
            this.currentTime = 0;
            this.markUpdated();
        }
    }

    public static void dropItemStack(Level pLevel, double pX, double pY, double pZ, ItemStack pStack) {
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(pX) + pLevel.f_46441_.m_188500_() * d1 + d2;
        double d4 = Math.floor(pY) + pLevel.f_46441_.m_188500_() * d1;
        double d5 = Math.floor(pZ) + pLevel.f_46441_.m_188500_() * d1 + d2;
        while (!pStack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(pLevel, d3, d4, d5, pStack.m_41620_(pLevel.f_46441_.m_188503_(21) + 10));
            itementity.m_20049_(ConstantPaths.resultItem());
            itementity.m_20334_(pLevel.f_46441_.m_216328_(0.0, 0.11485000171139836), pLevel.f_46441_.m_216328_(0.2, 0.11485000171139836), pLevel.f_46441_.m_216328_(0.0, 0.11485000171139836));
            pLevel.m_7967_((Entity)itementity);
        }
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    private void makeParticles() {
        BlockPos blockpos = this.m_58899_();
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        if (serverLevel != null) {
            long t = serverLevel.m_46467_();
            double d0 = (double)blockpos.m_123341_() + serverLevel.f_46441_.m_188500_();
            double d1 = (double)blockpos.m_123342_() + serverLevel.f_46441_.m_188500_();
            double d2 = (double)blockpos.m_123343_() + serverLevel.f_46441_.m_188500_();
            if (t % 20L == 0L) {
                if (((Boolean)this.m_58900_().m_61143_((Property)NecroBrazierBlock.WATERLOGGED)).booleanValue()) {
                    if (serverLevel.m_6425_(blockpos.m_7494_()).m_76178_() && serverLevel.m_8055_(blockpos.m_7494_()).m_60795_()) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.NECRO_FIRE.get()), (double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 1.0f), (double)((float)blockpos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.NECRO_FIRE_DROP.get()), (double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 1.0f), (double)((float)blockpos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                    } else {
                        for (int p = 0; p < 4; ++p) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123774_, d0, d1, d2, 0, 0.0, 0.04, 0.0, 0.5);
                        }
                    }
                } else if (serverLevel.m_6425_(blockpos.m_7494_()).m_76178_() && serverLevel.m_8055_(blockpos.m_7494_()).m_60795_()) {
                    for (int p = 0; p < 4; ++p) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, 0.0, 5.0E-4, 0.0, 0.5);
                    }
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.NECRO_FIRE.get()), (double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 1.0f), (double)((float)blockpos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.NECRO_FIRE_DROP.get()), (double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 1.0f), (double)((float)blockpos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void findCandlesticks() {
        if (this.f_58857_ != null) {
            this.candlestickBlockEntityList.clear();
            for (int i = -8; i <= 8; ++i) {
                for (int j = -8; j <= 8; ++j) {
                    for (int k = -8; k <= 8; ++k) {
                        SoulCandlestickBlockEntity soulCandlestickBlockEntity;
                        BlockPos blockpos1 = this.m_58899_().m_7918_(i, j, k);
                        BlockEntity blockEntity = this.f_58857_.m_7702_(blockpos1);
                        if (!(blockEntity instanceof SoulCandlestickBlockEntity) || (soulCandlestickBlockEntity = (SoulCandlestickBlockEntity)blockEntity).getSouls() <= 0) continue;
                        this.candlestickBlockEntityList.add(soulCandlestickBlockEntity);
                    }
                }
            }
        }
    }
}

