/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.MagicFire;
import com.Polarice3.Goety.common.entities.projectiles.SpellThrowableProjectile;
import com.Polarice3.Goety.common.entities.projectiles.VoidShock;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class VoidShockBomb
extends SpellThrowableProjectile {
    public double prevDeltaMovementX;
    public double prevDeltaMovementY;
    public double prevDeltaMovementZ;
    public int growTick = 0;
    public float size = 1.0f;
    public float alpha = 1.0f;
    public float baseDamage = 6.0f;
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public VoidShockBomb(EntityType<? extends VoidShockBomb> type, Level world) {
        super((EntityType<? extends SpellThrowableProjectile>)type, world);
    }

    public VoidShockBomb(LivingEntity thrower, Level world) {
        super((EntityType<? extends SpellThrowableProjectile>)((EntityType)ModEntityType.VOID_SHOCK_BOMB.get()), thrower, world);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("GrowTicks")) {
            this.growTick = pCompound.m_128451_("GrowTicks");
        }
        if (pCompound.m_128441_("BaseDamage")) {
            this.baseDamage = pCompound.m_128457_("BaseDamage");
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("GrowTicks", this.growTick);
        pCompound.m_128350_("BaseDamage", this.baseDamage);
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_ && this.growTick <= 0) {
            LivingEntity entity = this.getOwner();
            Vec3 vec30 = Vec3.m_82512_((Vec3i)this.m_20183_());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (result instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)result;
                    BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    if (BlockFinder.canBeReplaced(this.f_19853_, blockpos)) {
                        vec30 = Vec3.m_82512_((Vec3i)blockpos);
                    }
                } else if (result instanceof EntityHitResult) {
                    Direction[] entityHitResult = (Direction[])result;
                    Entity entity1 = entityHitResult.m_82443_();
                    vec30 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
                }
                MagicFire magicFire = new MagicFire(this.f_19853_, vec30, livingEntity);
                if (this.f_19853_.m_7967_((Entity)magicFire)) {
                    for (Direction direction : Direction.values()) {
                        if (!direction.m_122434_().m_122479_()) continue;
                        MagicFire magicFire1 = new MagicFire(this.f_19853_, Vec3.m_82512_((Vec3i)magicFire.m_20183_().m_121945_(direction)), livingEntity);
                        this.f_19853_.m_7967_((Entity)magicFire1);
                    }
                }
            }
            this.m_5496_(SoundEvents.f_11892_, 1.5f, 0.75f);
            for (int i = 0; i < 8; ++i) {
                VoidShock voidShock = new VoidShock((EntityType)ModEntityType.VOID_SHOCK.get(), this.f_19853_);
                voidShock.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Vec3 vec3 = this.m_20182_().m_82520_((double)this.f_19853_.m_213780_().m_216339_(-3, 3), (double)this.f_19853_.m_213780_().m_216339_(3, 6), (double)this.f_19853_.m_213780_().m_216339_(-3, 3));
                voidShock.signalTo(vec3, MathHelper.secondsToTicks(2) + i * 5);
                voidShock.setBaseDamage(this.baseDamage);
                voidShock.setExtraDamage(this.getExtraDamage());
                if (this.getOwner() != null) {
                    voidShock.setOwner(this.getOwner());
                    LivingEntity livingEntity = this.getOwner();
                    if (livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        voidShock.setTarget(mob.m_5448_());
                    }
                }
                this.f_19853_.m_7967_((Entity)voidShock);
            }
            this.f_19853_.m_7605_((Entity)this, (byte)6);
            this.growTick = 1;
            float damage = this.baseDamage + this.getExtraDamage();
            new SpellExplosion(this.f_19853_, (Entity)this, this.m_269291_().m_269104_((Entity)this, (Entity)this.getOwner()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, damage);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        LivingEntity shooter = this.getOwner();
        Entity entity = result.m_82443_();
        if (!this.f_19853_.f_46443_ && !MobUtil.areAllies((Entity)shooter, entity)) {
            float damage = this.baseDamage + this.getExtraDamage();
            if (shooter instanceof LivingEntity) {
                LivingEntity livingentity = shooter;
                boolean flag = entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), damage);
                if (flag && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                entity.m_6469_(this.m_269291_().m_269425_(), damage);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevDeltaMovementX = this.m_20184_().f_82479_;
        this.prevDeltaMovementY = this.m_20184_().f_82480_;
        this.prevDeltaMovementZ = this.m_20184_().f_82481_;
        this.m_146922_(-((float)Mth.m_14136_((double)this.m_20184_().f_82479_, (double)this.m_20184_().f_82481_)) * 57.295776f);
        if (!this.f_19853_.f_46443_ && this.growTick >= 1) {
            this.m_20256_(Vec3.f_82478_);
            ++this.growTick;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
            if (this.growTick >= 5) {
                this.m_146870_();
            }
        }
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        if (this.trailPointer == -1) {
            Vec3 backAt = trailAt;
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i] = backAt;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.getOwner() != null) {
            Projectile projectile;
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (this.getOwner() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof Projectile && (projectile = (Projectile)pEntity).m_19749_() == this.getOwner()) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    public void m_7822_(byte id) {
        if (id == 6) {
            this.growTick = 1;
        } else if (id == 8) {
            this.size += 3.0f;
            this.alpha -= 0.2f;
        } else {
            super.m_7822_(id);
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Override
    protected float getGravity() {
        return 0.025f;
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

