/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.common.entities.ModEntityType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class CameraShake
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAGNITUDE = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FADE_DURATION = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CameraShake(EntityType<?> type, Level world) {
        super(type, world);
    }

    public CameraShake(Level world, Vec3 position, float radius, float magnitude, int duration, int fadeDuration) {
        super((EntityType)ModEntityType.CAMERA_SHAKE.get(), world);
        this.setRadius(radius);
        this.setMagnitude(magnitude);
        this.setDuration(duration);
        this.setFadeDuration(fadeDuration);
        this.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(10.0f));
        this.m_20088_().m_135372_(MAGNITUDE, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(DURATION, (Object)0);
        this.m_20088_().m_135372_(FADE_DURATION, (Object)5);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Radius")) {
            this.setRadius(compound.m_128457_("Radius"));
        }
        if (compound.m_128441_("Magnitude")) {
            this.setMagnitude(compound.m_128457_("Magnitude"));
        }
        if (compound.m_128441_("Duration")) {
            this.setDuration(compound.m_128451_("Duration"));
        }
        if (compound.m_128441_("Fade")) {
            this.setFadeDuration(compound.m_128451_("Fade"));
        }
        if (compound.m_128441_("TickAmount")) {
            this.f_19797_ = compound.m_128451_("TickAmount");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("Radius", this.getRadius());
        compound.m_128350_("Magnitude", this.getMagnitude());
        compound.m_128405_("Duration", this.getDuration());
        compound.m_128405_("Fade", this.getFadeDuration());
        compound.m_128405_("TickAmount", this.f_19797_);
    }

    public boolean m_20145_() {
        return true;
    }

    public boolean m_20177_(Player p_20178_) {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6673_(DamageSource p_20122_) {
        return !p_20122_.m_269533_(DamageTypeTags.f_268738_);
    }

    public float getShakeAmount(Player player, float delta) {
        float ticksDelta = (float)this.f_19797_ + delta;
        float timeFrac = 1.0f - (ticksDelta - (float)this.getDuration()) / ((float)this.getFadeDuration() + 1.0f);
        float baseAmount = ticksDelta < (float)this.getDuration() ? this.getMagnitude() : timeFrac * timeFrac * this.getMagnitude();
        Vec3 playerPos = player.m_20299_(delta);
        float distFrac = (float)(1.0 - Mth.m_14008_((double)(this.m_20182_().m_82554_(playerPos) / (double)this.getRadius()), (double)0.0, (double)1.0));
        return baseAmount * distFrac * distFrac;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > this.getDuration() + this.getFadeDuration()) {
            this.m_146870_();
        }
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getMagnitude() {
        return ((Float)this.m_20088_().m_135370_(MAGNITUDE)).floatValue();
    }

    public void setMagnitude(float magnitude) {
        this.m_20088_().m_135381_(MAGNITUDE, (Object)Float.valueOf(magnitude));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DURATION, (Object)duration);
    }

    public int getFadeDuration() {
        return (Integer)this.m_20088_().m_135370_(FADE_DURATION);
    }

    public void setFadeDuration(int fadeDuration) {
        this.m_20088_().m_135381_(FADE_DURATION, (Object)fadeDuration);
    }

    public static void cameraShake(Level world, Vec3 position, float radius, float magnitude, int duration, int fadeDuration) {
        if (!world.f_46443_) {
            CameraShake cameraShake = new CameraShake(world, position, radius, magnitude, duration, fadeDuration);
            world.m_7967_((Entity)cameraShake);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

