/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.curios;

import com.Polarice3.Goety.api.items.curios.IActivatable;
import com.Polarice3.Goety.common.items.curios.SingleStackItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class OminousCharmItem
extends SingleStackItem
implements IActivatable {
    private static final String OMEN_LEVEL = "Omen Level";

    @Override
    public void activate(Level level, Player player, ItemStack itemStack) {
        if (itemStack.m_150930_((Item)this)) {
            if (player.m_21023_(MobEffects.f_19594_)) {
                MobEffectInstance instance = player.m_21124_(MobEffects.f_19594_);
                if (instance != null) {
                    OminousCharmItem.increaseOmenLevel(itemStack, instance.m_19564_() + 1);
                    level.m_6269_(null, (Entity)player, SoundEvents.f_11771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21195_(MobEffects.f_19594_);
                }
            } else if (OminousCharmItem.hasOmen(itemStack)) {
                MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_19594_, 120000, OminousCharmItem.getOmenAmount(itemStack) - 1, false, false, true);
                player.m_7292_(mobeffectinstance);
                level.m_6269_(null, (Entity)player, (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                OminousCharmItem.setOmenLevel(itemStack, 0);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)this)) {
            if (player.m_21023_(MobEffects.f_19594_)) {
                MobEffectInstance instance = player.m_21124_(MobEffects.f_19594_);
                if (instance != null) {
                    OminousCharmItem.increaseOmenLevel(itemstack, instance.m_19564_() + 1);
                    level.m_6269_(null, (Entity)player, SoundEvents.f_11771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21195_(MobEffects.f_19594_);
                    return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
                }
            } else if (OminousCharmItem.hasOmen(itemstack)) {
                MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_19594_, 120000, OminousCharmItem.getOmenAmount(itemstack) - 1, false, false, true);
                player.m_7292_(mobeffectinstance);
                level.m_6269_(null, (Entity)player, (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                OminousCharmItem.setOmenLevel(itemstack, 0);
                return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public static void increaseOmenLevel(ItemStack stack, int amount) {
        OminousCharmItem.setOmenLevel(stack, OminousCharmItem.getOmenAmount(stack) + amount);
    }

    public static void setOmenLevel(ItemStack stack, int amount) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128405_(OMEN_LEVEL, Math.min(5, amount));
        } else {
            CompoundTag compound = stack.m_41784_();
            compound.m_128405_(OMEN_LEVEL, Math.min(5, amount));
        }
    }

    public static int getOmenAmount(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_(OMEN_LEVEL);
        }
        return 0;
    }

    public static boolean hasOmen(ItemStack stack) {
        return OminousCharmItem.getOmenAmount(stack) > 0;
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compound = pStack.m_41784_();
        compound.m_128405_(OMEN_LEVEL, 0);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }
}

