/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SonicBoomSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(15);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SonicBoomCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SonicBoomDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SonicBoomCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_215772_;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float damage = ((Double)SpellConfig.SonicBoomDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        damage += (float)spellStat.getPotency();
        LivingEntity livingEntity = this.getTarget(caster, range);
        if (livingEntity != null) {
            Vec3 vec3 = caster.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
            Vec3 vec31 = livingEntity.m_146892_().m_82546_(vec3);
            Vec3 vec32 = vec31.m_82541_();
            for (int i = 1; i < Mth.m_14107_((double)vec31.m_82553_()) + 7; ++i) {
                Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)i));
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.playSound(worldIn, (Entity)caster, SoundEvents.f_215771_, 3.0f, 1.0f);
            livingEntity.m_6469_(caster.m_269291_().m_269285_((Entity)caster), damage);
            double d1 = 0.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            double d0 = 2.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            livingEntity.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
        } else {
            Vec3 vector3d2;
            Vec3 srcVec = new Vec3(caster.m_20185_(), caster.m_20188_(), caster.m_20189_());
            Vec3 lookVec = caster.m_20252_(1.0f);
            Vec3 destVec = srcVec.m_82520_(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
            int i = 1;
            while ((double)i < Math.floor(destVec.m_82553_()) + 7.0) {
                vector3d2 = srcVec.m_82549_(lookVec.m_82490_((double)i));
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_235902_, vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                ++i;
            }
            vector3d2 = MobUtil.getSingleTarget((Level)worldIn, caster, range, 3.0);
            if (vector3d2 instanceof LivingEntity) {
                LivingEntity target1 = (LivingEntity)vector3d2;
                target1.m_6469_(caster.m_269291_().m_269285_((Entity)caster), damage);
                double d0 = target1.m_20185_() - caster.m_20185_();
                double d1 = target1.m_20189_() - caster.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                MobUtil.push((Entity)target1, d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
            }
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_215771_, 3.0f, 1.0f);
    }
}

