/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.TouchSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.Vec3Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChargeSpell
extends TouchSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ChargeCost.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ZAP.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ChargeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public void touchResult(ServerLevel worldIn, LivingEntity caster, LivingEntity target, ItemStack staff, SpellStat spellStat) {
        if (this.rightStaff(staff)) {
            this.chainCharge(worldIn, target, caster, 6.0);
        } else if (!target.m_21023_((MobEffect)GoetyEffects.CHARGED.get())) {
            this.playSound(worldIn, target, 1.0f, 0.5f);
            target.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CHARGED.get(), MathHelper.secondsToTicks(30), 0, false, false));
        } else {
            MobEffectInstance instance = target.m_21124_((MobEffect)GoetyEffects.CHARGED.get());
            if (instance != null) {
                if (instance.m_19564_() >= 1) {
                    target.m_6469_(ModDamageSource.directShock(caster), ((Double)SpellConfig.ChargeDamage.get()).floatValue());
                } else {
                    this.playSound(worldIn, target, 1.0f, 0.75f);
                }
                EffectsUtil.amplifyEffect(target, (MobEffect)GoetyEffects.CHARGED.get(), MathHelper.secondsToTicks(30), 3, false, false);
            }
        }
    }

    public void chainCharge(ServerLevel serverLevel, LivingEntity pTarget, LivingEntity pAttacker, double range) {
        ArrayList<LivingEntity> harmed = new ArrayList<LivingEntity>();
        Predicate<Entity> selector = entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && !harmed.contains(livingEntity = (LivingEntity)entity);
        };
        if (pAttacker != null) {
            selector = selector.and(entity -> {
                OwnableEntity ownable;
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != pAttacker && pTarget instanceof OwnableEntity && (ownable = (OwnableEntity)pTarget).m_269323_() == pAttacker;
            });
        }
        LivingEntity prevTarget = pTarget;
        int hops = serverLevel.m_46470_() ? 8 : 4;
        for (int i = 0; i < hops; ++i) {
            Entity entity2;
            LivingEntity finalPrevTarget;
            AABB aabb = new AABB(Vec3Util.subtract(prevTarget.m_20182_(), range), Vec3Util.add(prevTarget.m_20182_(), range));
            List entities = serverLevel.m_6249_((Entity)prevTarget, aabb, selector.and(arg_0 -> ChargeSpell.lambda$chainCharge$2((Entity)(finalPrevTarget = prevTarget), arg_0)));
            if (entities.isEmpty() || !((entity2 = (Entity)entities.get(serverLevel.m_213780_().m_188503_(entities.size()))) instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity2;
            if (!target.m_21023_((MobEffect)GoetyEffects.CHARGED.get())) {
                this.playSound(serverLevel, target, 1.0f, 0.5f);
                target.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CHARGED.get(), MathHelper.secondsToTicks(30), 0, false, false));
            } else {
                MobEffectInstance instance = target.m_21124_((MobEffect)GoetyEffects.CHARGED.get());
                if (instance != null) {
                    if (instance.m_19564_() >= 1) {
                        target.m_6469_(ModDamageSource.directShock(pAttacker), ((Double)SpellConfig.ChargeDamage.get()).floatValue());
                    } else {
                        this.playSound(serverLevel, target, 1.0f, 0.75f);
                    }
                    EffectsUtil.amplifyEffect(target, (MobEffect)GoetyEffects.CHARGED.get(), MathHelper.secondsToTicks(30), 3, false, false);
                }
            }
            if (prevTarget != target) {
                Vec3 vec3 = prevTarget.m_146892_();
                Vec3 vec31 = target.m_146892_();
                ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 5));
            }
            harmed.add(target);
            prevTarget = target;
        }
    }

    private static /* synthetic */ boolean lambda$chainCharge$2(Entity finalPrevTarget, Entity entity) {
        return MobUtil.hasLineOfSight(finalPrevTarget, entity);
    }
}

